/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.interpreter;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreterManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeJsInterpreterManager {
    private static final String NODEJS_INTERPRETER_PATH = "nodejs_interpreter_path";
    private final Project myProject;
    private NodeJsInterpreter myDefaultInterpreter;

    public NodeJsInterpreterManager(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/interpreter/NodeJsInterpreterManager", "<init>"));
        }
        this.myProject = project;
    }

    @NotNull
    public static NodeJsInterpreterManager getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/interpreter/NodeJsInterpreterManager", "getInstance"));
        }
        NodeJsInterpreterManager nodeJsInterpreterManager = (NodeJsInterpreterManager)ServiceManager.getService((Project)project, NodeJsInterpreterManager.class);
        if (nodeJsInterpreterManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/NodeJsInterpreterManager", "getInstance"));
        }
        return nodeJsInterpreterManager;
    }

    @Nullable
    public NodeJsInterpreter getDefault() {
        NodeJsInterpreter interpreter = this.myDefaultInterpreter;
        if (interpreter == null) {
            PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)this.myProject);
            String reference = propertiesComponent.getValue(NODEJS_INTERPRETER_PATH);
            if (StringUtil.isNotEmpty((String)reference)) {
                interpreter = NodeJsInterpreterRef.create(reference).resolveWithoutAliases();
            } else {
                interpreter = NodeJsLocalInterpreterManager.getInstance().detectMostRelevant();
                if (interpreter != null) {
                    propertiesComponent.setValue(NODEJS_INTERPRETER_PATH, interpreter.getReferenceName());
                }
            }
            this.myDefaultInterpreter = interpreter;
        }
        return interpreter;
    }

    public void setDefault(@Nullable NodeJsInterpreter interpreter) {
        this.myDefaultInterpreter = interpreter;
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)this.myProject);
        if (interpreter == null) {
            propertiesComponent.unsetValue(NODEJS_INTERPRETER_PATH);
        } else {
            propertiesComponent.setValue(NODEJS_INTERPRETER_PATH, interpreter.getReferenceName());
        }
    }
}

