/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.library;

import com.intellij.javascript.nodejs.library.NodeModulesLibraryDirectory;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeModulesLibrariesSnapshot {
    private static final Logger LOG = Logger.getInstance(NodeModulesLibrariesSnapshot.class);
    private final List<NodeModulesLibraryDirectory> myLibraryDirs;
    private final Map<VirtualFile, NodeModulesLibraryDirectory> myMap;

    public NodeModulesLibrariesSnapshot(@NotNull Project project, @NotNull Collection<VirtualFile> nodeModulesDirs) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/library/NodeModulesLibrariesSnapshot", "<init>"));
        }
        if (nodeModulesDirs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeModulesDirs", "com/intellij/javascript/nodejs/library/NodeModulesLibrariesSnapshot", "<init>"));
        }
        ArrayList copy = ContainerUtil.newArrayList(nodeModulesDirs);
        this.myLibraryDirs = ContainerUtil.newArrayListWithCapacity((int)copy.size());
        this.myMap = ContainerUtilRt.newHashMap((int)copy.size());
        ReadAction.run(() -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/library/NodeModulesLibrariesSnapshot", "lambda$new$1"));
            }
            NotNullLazyValue contentRoots = NotNullLazyValue.createValue(() -> {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/library/NodeModulesLibrariesSnapshot", "lambda$null$0"));
                }
                return ContainerUtil.newHashSet((Object[])ProjectRootManager.getInstance((Project)project).getContentRoots());
            });
            for (VirtualFile dir : copy) {
                if (dir.isValid()) {
                    String name = NodeModulesLibrariesSnapshot.buildLibraryName(project, dir, (NotNullLazyValue<Set<VirtualFile>>)contentRoots);
                    NodeModulesLibraryDirectory libraryDir = new NodeModulesLibraryDirectory(project, dir, name);
                    this.myLibraryDirs.add(libraryDir);
                    this.myMap.put(dir, libraryDir);
                    continue;
                }
                LOG.warn("Filtering out invalid library node_modules: " + dir.getPath());
            }
        });
    }

    @NotNull
    public List<NodeModulesLibraryDirectory> getLibraryDirs() {
        List<NodeModulesLibraryDirectory> list = this.myLibraryDirs;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/library/NodeModulesLibrariesSnapshot", "getLibraryDirs"));
        }
        return list;
    }

    @Nullable
    public String findLibraryName(@NotNull VirtualFile nodeModulesDir) {
        if (nodeModulesDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeModulesDir", "com/intellij/javascript/nodejs/library/NodeModulesLibrariesSnapshot", "findLibraryName"));
        }
        NodeModulesLibraryDirectory directory = this.myMap.get(nodeModulesDir);
        return directory != null ? directory.getLibraryName() : null;
    }

    @Nullable
    public NodeModulesLibraryDirectory findLibraryDir(@NotNull VirtualFile nodeModulesDir) {
        if (nodeModulesDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeModulesDir", "com/intellij/javascript/nodejs/library/NodeModulesLibrariesSnapshot", "findLibraryDir"));
        }
        return this.myMap.get(nodeModulesDir);
    }

    public void onFileCreatedOrDeleted(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/javascript/nodejs/library/NodeModulesLibrariesSnapshot", "onFileCreatedOrDeleted"));
        }
        NodeModulesLibraryDirectory d = this.findNodeModulesDirectoryByTopLevelDependentFile(file);
        if (d != null) {
            d.invalidateRoots();
        }
    }

    public void onPackageJsonFileChanged(@NotNull VirtualFile packageJson) {
        NodeModulesLibraryDirectory d;
        NodeModulesLibraryDirectory directory;
        if (packageJson == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageJson", "com/intellij/javascript/nodejs/library/NodeModulesLibrariesSnapshot", "onPackageJsonFileChanged"));
        }
        VirtualFile nodeModulesDir = NodeModuleUtil.findNodeModulesByPackageJson(packageJson);
        if (nodeModulesDir != null && (directory = this.myMap.get(nodeModulesDir)) != null) {
            directory.invalidateRoots();
        }
        if ((d = this.findNodeModulesDirectoryByTopLevelDependentFile(packageJson)) != null) {
            d.invalidateRoots();
        }
    }

    @Nullable
    private NodeModulesLibraryDirectory findNodeModulesDirectoryByTopLevelDependentFile(@NotNull VirtualFile file) {
        VirtualFile dir;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/javascript/nodejs/library/NodeModulesLibrariesSnapshot", "findNodeModulesDirectoryByTopLevelDependentFile"));
        }
        VirtualFile virtualFile = dir = file.isDirectory() ? file : file.getParent();
        for (int steps = 3; steps > 0 && dir != null; dir = dir.getParent(), --steps) {
            NodeModulesLibraryDirectory directory = this.myMap.get(dir);
            if (directory == null) continue;
            return directory;
        }
        return null;
    }

    @NotNull
    private static String buildLibraryName(@NotNull Project project, @NotNull VirtualFile nodeModulesDir, @NotNull NotNullLazyValue<Set<VirtualFile>> contentRoots) {
        String relativePath;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/library/NodeModulesLibrariesSnapshot", "buildLibraryName"));
        }
        if (nodeModulesDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeModulesDir", "com/intellij/javascript/nodejs/library/NodeModulesLibrariesSnapshot", "buildLibraryName"));
        }
        if (contentRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentRoots", "com/intellij/javascript/nodejs/library/NodeModulesLibrariesSnapshot", "buildLibraryName"));
        }
        VirtualFile baseDir = project.getBaseDir();
        if (baseDir != null && (relativePath = NodeModulesLibrariesSnapshot.buildRelativeName(nodeModulesDir, baseDir, false)) != null) {
            String string = relativePath;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/library/NodeModulesLibrariesSnapshot", "buildLibraryName"));
            }
            return string;
        }
        VirtualFile contentRoot = NodeModulesLibrariesSnapshot.findContentRoot(nodeModulesDir, (Set)contentRoots.getValue());
        if (contentRoot != null) {
            String relativePath2 = NodeModulesLibrariesSnapshot.buildRelativeName(nodeModulesDir, contentRoot, false);
            if (relativePath2 != null) {
                String string = relativePath2;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/library/NodeModulesLibrariesSnapshot", "buildLibraryName"));
                }
                return string;
            }
            LOG.error("Failed to buildRelativeName(" + nodeModulesDir.getPath() + ", " + contentRoot.getPath() + ")");
        }
        LOG.warn("Cannot generate library name for " + nodeModulesDir.getPath());
        String path = NodeModulesLibrariesSnapshot.buildRelativeName(nodeModulesDir, nodeModulesDir, true);
        if (path != null) {
            String string = path;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/library/NodeModulesLibrariesSnapshot", "buildLibraryName"));
            }
            return string;
        }
        LOG.error("Failed to build relative name to itself: " + nodeModulesDir.getPath());
        if ("unknown_node_modules" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/library/NodeModulesLibrariesSnapshot", "buildLibraryName"));
        }
        return "unknown_node_modules";
    }

    @Nullable
    private static String buildRelativeName(@NotNull VirtualFile nodeModulesDir, @NotNull VirtualFile root, boolean prependEllipses) {
        String relativePath;
        if (nodeModulesDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeModulesDir", "com/intellij/javascript/nodejs/library/NodeModulesLibrariesSnapshot", "buildRelativeName"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/javascript/nodejs/library/NodeModulesLibrariesSnapshot", "buildRelativeName"));
        }
        if (nodeModulesDir.equals(root)) {
            VirtualFile parentRoot = root.getParent();
            if (parentRoot == null) {
                return nodeModulesDir.getPath();
            }
            root = parentRoot;
        }
        if ((relativePath = VfsUtilCore.getRelativePath((VirtualFile)nodeModulesDir, (VirtualFile)root, (char)'/')) != null) {
            String path = root.getName() + '/' + relativePath;
            return prependEllipses ? ".../" + path : path;
        }
        return null;
    }

    @Nullable
    private static VirtualFile findContentRoot(@NotNull VirtualFile file, @NotNull Set<VirtualFile> contentRoots) {
        VirtualFile f;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/javascript/nodejs/library/NodeModulesLibrariesSnapshot", "findContentRoot"));
        }
        if (contentRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentRoots", "com/intellij/javascript/nodejs/library/NodeModulesLibrariesSnapshot", "findContentRoot"));
        }
        for (f = file; f != null && !contentRoots.contains(f); f = f.getParent()) {
        }
        return f;
    }
}

