/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.library;

import com.intellij.javascript.nodejs.library.NodeModulesDirectoryManager;
import com.intellij.javascript.nodejs.library.NodeModulesLibraryDirectory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.AdditionalLibraryRootsProvider;
import com.intellij.openapi.roots.SyntheticLibrary;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class NodeModulesSyntheticLibraryProvider
extends AdditionalLibraryRootsProvider {
    @NotNull
    public Collection<SyntheticLibrary> getAdditionalProjectLibraries(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/library/NodeModulesSyntheticLibraryProvider", "getAdditionalProjectLibraries"));
        }
        NodeModulesDirectoryManager manager = NodeModulesDirectoryManager.getInstance(project);
        List libraries = (List)manager.computeFileIndexExtensionPreventingRecursion(() -> NodeModulesSyntheticLibraryProvider.computeRoots(manager));
        List list = ContainerUtil.notNullize((List)libraries);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/library/NodeModulesSyntheticLibraryProvider", "getAdditionalProjectLibraries"));
        }
        return list;
    }

    @NotNull
    private static List<SyntheticLibrary> computeRoots(@NotNull NodeModulesDirectoryManager manager) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/javascript/nodejs/library/NodeModulesSyntheticLibraryProvider", "computeRoots"));
        }
        List<NodeModulesLibraryDirectory> libraryDirs = manager.getNodeModulesDirectories();
        List list = ContainerUtil.mapNotNull(libraryDirs, libraryDir -> {
            HashSet<VirtualFile> excludedRoots;
            if (manager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/javascript/nodejs/library/NodeModulesSyntheticLibraryProvider", "lambda$computeRoots$2"));
            }
            if (!manager.isLibraryWithMappings((NodeModulesLibraryDirectory)libraryDir)) {
                return null;
            }
            SyntheticLibrary library = libraryDir.getLibrary();
            Collection sourceRoots = library.getSourceRoots();
            if (!sourceRoots.stream().allMatch(VirtualFile::isValid)) {
                sourceRoots = ContainerUtil.filter((Collection)sourceRoots, VirtualFile::isValid);
            }
            if (!(excludedRoots = library.getExcludedRoots()).stream().allMatch(VirtualFile::isValid)) {
                excludedRoots = new HashSet<VirtualFile>(excludedRoots);
                excludedRoots.removeIf(file -> !file.isValid());
            }
            return SyntheticLibrary.newImmutableLibrary((Collection)sourceRoots, (Set)excludedRoots, null);
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/library/NodeModulesSyntheticLibraryProvider", "computeRoots"));
        }
        return list;
    }
}

