/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.packageJson;

import com.intellij.lang.javascript.modules.InstallNodeLocalDependenciesAction;
import com.intellij.notification.Notification;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public class PackageJsonGetDependenciesAction
extends DumbAwareAction {
    private final VirtualFile myPackageJson;
    private final Notification myNotification;

    public PackageJsonGetDependenciesAction(@NotNull VirtualFile packageJson, boolean install, @NotNull Notification notification) {
        if (packageJson == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageJson", "com/intellij/javascript/nodejs/packageJson/PackageJsonGetDependenciesAction", "<init>"));
        }
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/javascript/nodejs/packageJson/PackageJsonGetDependenciesAction", "<init>"));
        }
        super("Run \"" + (install ? "npm install" : "npm update") + "\"");
        this.myPackageJson = packageJson;
        this.myNotification = notification;
    }

    public void update(AnActionEvent e) {
        e.getPresentation().setEnabledAndVisible(true);
    }

    public void actionPerformed(AnActionEvent e) {
        this.myNotification.expire();
        Project project = e.getProject();
        if (project != null) {
            InstallNodeLocalDependenciesAction.runAndShowConsole(project, this.myPackageJson);
        }
    }
}

