/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.packageJson;

import com.intellij.lang.javascript.buildTools.base.JsbtUtil;
import com.intellij.lang.javascript.modules.InstallNodeLocalDependenciesAction;
import com.intellij.notification.Notification;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.CheckBoxList;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.util.ui.JBUI;
import java.awt.Dimension;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageJsonSeveralFilesAction
extends DumbAwareAction {
    private final Project myProject;
    private final List<VirtualFile> myPackageJsonFiles;
    private final Notification myNotification;

    public PackageJsonSeveralFilesAction(@NotNull Project project, @NotNull List<VirtualFile> packageJsonFiles, @NotNull Notification notification) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/packageJson/PackageJsonSeveralFilesAction", "<init>"));
        }
        if (packageJsonFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageJsonFiles", "com/intellij/javascript/nodejs/packageJson/PackageJsonSeveralFilesAction", "<init>"));
        }
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/javascript/nodejs/packageJson/PackageJsonSeveralFilesAction", "<init>"));
        }
        super("View and Install...");
        this.myProject = project;
        this.myPackageJsonFiles = packageJsonFiles;
        this.myNotification = notification;
    }

    public void actionPerformed(AnActionEvent e) {
        this.myNotification.expire();
        new MyDialog().show();
    }

    @NotNull
    private CheckBoxList<VirtualFile> createPanel() {
        CheckBoxList list = new CheckBoxList();
        for (VirtualFile packageJson : this.myPackageJsonFiles) {
            String presentablePath = JsbtUtil.getRelativePath(this.myProject, packageJson);
            list.addItem((Object)packageJson, presentablePath, true);
        }
        list.setSelectionMode(2);
        new ListSpeedSearch((JList)list, checkbox -> checkbox.getText());
        list.setPreferredSize(new Dimension(JBUI.scale((int)450), JBUI.scale((int)400)));
        CheckBoxList checkBoxList = list;
        if (checkBoxList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/packageJson/PackageJsonSeveralFilesAction", "createPanel"));
        }
        return checkBoxList;
    }

    private class MyDialog
    extends DialogWrapper {
        private final CheckBoxList<VirtualFile> myList;

        protected MyDialog() {
            super(PackageJsonSeveralFilesAction.this.myProject);
            this.setTitle("Missing Dependencies");
            this.myList = PackageJsonSeveralFilesAction.this.createPanel();
            this.setOKButtonText("Install/Update");
            this.init();
        }

        @Nullable
        protected JComponent createCenterPanel() {
            return this.myList;
        }

        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return this.myList;
        }

        protected void doOKAction() {
            super.doOKAction();
            InstallNodeLocalDependenciesAction.runAndShowConsole(PackageJsonSeveralFilesAction.this.myProject, PackageJsonSeveralFilesAction.this.myPackageJsonFiles);
        }
    }
}

