/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.reference;

import com.google.common.collect.Lists;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.icons.AllIcons;
import com.intellij.javascript.JSModuleBaseReference;
import com.intellij.javascript.nodejs.CompletionModuleInfo;
import com.intellij.javascript.nodejs.ModuleType;
import com.intellij.javascript.nodejs.ResolvedModuleInfo;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.typescript.psi.TypeScriptExternalModuleReference;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.css.CssString;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NodeFileModulePsiReferenceBase
implements PsiReference,
JSModuleBaseReference {
    protected final PsiElement myPsiElement;
    protected final String myRequiredModuleName;

    public NodeFileModulePsiReferenceBase(@NotNull PsiElement literalExpression, @NotNull String requiredModuleName) {
        if (literalExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "literalExpression", "com/intellij/javascript/nodejs/reference/NodeFileModulePsiReferenceBase", "<init>"));
        }
        if (requiredModuleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requiredModuleName", "com/intellij/javascript/nodejs/reference/NodeFileModulePsiReferenceBase", "<init>"));
        }
        this.myPsiElement = literalExpression;
        this.myRequiredModuleName = requiredModuleName;
    }

    @NotNull
    public PsiElement getElement() {
        PsiElement psiElement = this.myPsiElement;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/reference/NodeFileModulePsiReferenceBase", "getElement"));
        }
        return psiElement;
    }

    public TextRange getRangeInElement() {
        if (this.myPsiElement instanceof ES6FromClause || this.myPsiElement instanceof ES6ImportDeclaration || this.myPsiElement instanceof TypeScriptExternalModuleReference) {
            Pair<String, PsiElement> pair = JSPsiImplUtils.getChildStringLiteralWithText(this.myPsiElement);
            if (pair != null && ((PsiElement)pair.getSecond()).getTextLength() > 2) {
                return TextRange.from((int)(((PsiElement)pair.getSecond()).getStartOffsetInParent() + 1), (int)(((PsiElement)pair.getSecond()).getTextLength() - 2));
            }
        } else if (this.myPsiElement instanceof TypeScriptModule) {
            PsiElement identifier = ((TypeScriptModule)this.myPsiElement).getNameIdentifier();
            if (identifier instanceof JSLiteralExpression && identifier.getTextLength() > 2) {
                return TextRange.from((int)(identifier.getStartOffsetInParent() + 1), (int)(identifier.getTextLength() - 2));
            }
        } else {
            if (this.myPsiElement instanceof CssString) {
                String value = ((CssString)this.myPsiElement).getValue();
                int valueIndex = this.myPsiElement.getText().indexOf(value);
                assert (valueIndex >= 0 && value.startsWith("~")) : value + "\n" + this.myPsiElement.getParent().getText();
                return TextRange.from((int)(valueIndex + 1), (int)(value.length() - 1));
            }
            assert (this.myPsiElement instanceof JSLiteralExpression);
            int length = this.myPsiElement.getTextLength();
            if (length >= 2) {
                return new TextRange(1, length - 1);
            }
        }
        return new TextRange(0, this.myPsiElement.getTextLength());
    }

    public PsiElement resolve() {
        ResolvedModuleInfo resolvedModuleInfo = this.resolveModule();
        if (resolvedModuleInfo == null) {
            return null;
        }
        VirtualFile resolvedVirtualFile = resolvedModuleInfo.getModuleMainFile();
        if (resolvedVirtualFile.isValid()) {
            return this.myPsiElement.getManager().findFile(resolvedVirtualFile);
        }
        return null;
    }

    @Nullable
    public abstract ResolvedModuleInfo resolveModule();

    @NotNull
    public String getCanonicalText() {
        TextRange range = this.getRangeInElement();
        String string = range.substring(this.myPsiElement.getText());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/reference/NodeFileModulePsiReferenceBase", "getCanonicalText"));
        }
        return string;
    }

    public PsiElement handleElementRename(String newContent) throws IncorrectOperationException {
        return null;
    }

    public PsiElement bindToElement(@NotNull PsiElement psiElement) throws IncorrectOperationException {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/javascript/nodejs/reference/NodeFileModulePsiReferenceBase", "bindToElement"));
        }
        return psiElement;
    }

    public boolean isReferenceTo(PsiElement psiElement) {
        return this.myPsiElement.getManager().areElementsEquivalent(this.resolve(), psiElement);
    }

    @NotNull
    public Object[] getVariants() {
        VirtualFile requester = this.getContainingFile();
        CompletionModuleInfo[] modules = this.getModuleInfos(requester);
        Arrays.sort(modules, Comparator.comparing(CompletionModuleInfo::getName));
        ArrayList lookupElements = Lists.newArrayListWithCapacity((int)modules.length);
        for (CompletionModuleInfo module : modules) {
            lookupElements.add(NodeFileModulePsiReferenceBase.createLookupElement(requester, module));
        }
        Object[] objectArray = lookupElements.toArray(new LookupElement[lookupElements.size()]);
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/reference/NodeFileModulePsiReferenceBase", "getVariants"));
        }
        return objectArray;
    }

    @NotNull
    public static LookupElement createLookupElement(final @Nullable VirtualFile context, final @NotNull CompletionModuleInfo module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/javascript/nodejs/reference/NodeFileModulePsiReferenceBase", "createLookupElement"));
        }
        LookupElementBuilder element = LookupElementBuilder.create((String)module.getName());
        LookupElementBuilder lookupElementBuilder = element = element.withRenderer((LookupElementRenderer)new LookupElementRenderer<LookupElement>(){

            public void renderElement(LookupElement element, LookupElementPresentation presentation) {
                presentation.setItemText(element.getLookupString());
                presentation.setTypeGrayed(true);
                presentation.setIcon(AllIcons.Nodes.Folder);
                if (module.getType() == ModuleType.CORE_MODULE) {
                    presentation.setTypeText("Node.js core module");
                } else {
                    String presentablePath = module.getPresentablePath(context);
                    if (presentablePath != null) {
                        presentation.setTypeText(presentablePath);
                        presentation.setTypeGrayed(true);
                    }
                }
            }
        });
        if (lookupElementBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/reference/NodeFileModulePsiReferenceBase", "createLookupElement"));
        }
        return lookupElementBuilder;
    }

    @NotNull
    protected abstract CompletionModuleInfo[] getModuleInfos(VirtualFile var1);

    @Nullable
    public VirtualFile getContainingFile() {
        VirtualFile vFile;
        PsiFile psiFile = this.getElement().getContainingFile();
        if (psiFile != null && (vFile = (psiFile = psiFile.getOriginalFile()).getVirtualFile()) != null && vFile.isValid()) {
            return vFile;
        }
        return null;
    }

    @NotNull
    public String getRequiredModuleName() {
        String string = this.myRequiredModuleName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/reference/NodeFileModulePsiReferenceBase", "getRequiredModuleName"));
        }
        return string;
    }

    public boolean isSoft() {
        return true;
    }
}

