/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.util;

import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.util.NodePackageDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.SemVer;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodePackage {
    private final String mySystemDependentPath;
    private final File myDir;

    public NodePackage(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/javascript/nodejs/util/NodePackage", "<init>"));
        }
        path = StringUtil.trimEnd((String)FileUtil.toSystemIndependentName((String)path), (char)'/');
        this.mySystemDependentPath = FileUtil.toSystemDependentName((String)path);
        this.myDir = new File(this.mySystemDependentPath);
    }

    @NotNull
    public String getSystemIndependentPath() {
        String string = FileUtil.toSystemIndependentName((String)this.mySystemDependentPath);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/util/NodePackage", "getSystemIndependentPath"));
        }
        return string;
    }

    @NotNull
    public String getSystemDependentPath() {
        String string = this.mySystemDependentPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/util/NodePackage", "getSystemDependentPath"));
        }
        return string;
    }

    public boolean isEmptyPath() {
        return this.mySystemDependentPath.isEmpty();
    }

    @NotNull
    public String getName() {
        String string = PathUtil.getFileName((String)this.mySystemDependentPath);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/util/NodePackage", "getName"));
        }
        return string;
    }

    @Nullable
    public SemVer getVersion() {
        VirtualFile file = LocalFileSystem.getInstance().findFileByIoFile(new File(this.myDir, "package.json"));
        return file != null ? PackageJsonData.getOrCreate(file).getVersion() : null;
    }

    @NotNull
    public String getPresentablePath() {
        String userHome = StringUtil.trimEnd((String)FileUtil.toSystemDependentName((String)SystemProperties.getUserHome()), (char)File.separatorChar);
        if (StringUtil.isEmptyOrSpaces((String)userHome)) {
            String string = this.mySystemDependentPath;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/util/NodePackage", "getPresentablePath"));
            }
            return string;
        }
        if (this.mySystemDependentPath.startsWith(userHome + File.separatorChar)) {
            String string = "~" + this.mySystemDependentPath.substring(userHome.length());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/util/NodePackage", "getPresentablePath"));
            }
            return string;
        }
        String string = this.mySystemDependentPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/util/NodePackage", "getPresentablePath"));
        }
        return string;
    }

    public boolean isValid() {
        return !StringUtil.isEmptyOrSpaces((String)this.mySystemDependentPath) && this.myDir.isAbsolute() && this.myDir.isDirectory();
    }

    @Nullable
    public String getErrorMessage(@NotNull String packageName) {
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/intellij/javascript/nodejs/util/NodePackage", "getErrorMessage"));
        }
        if (StringUtil.isEmptyOrSpaces((String)this.mySystemDependentPath)) {
            return "Unspecified " + packageName + " package";
        }
        if (!this.myDir.isAbsolute() || !this.myDir.isDirectory()) {
            return "Invalid " + packageName + " package: no such directory";
        }
        return null;
    }

    public void validateForRunConfiguration(@NotNull String packageName) throws RuntimeConfigurationError {
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/intellij/javascript/nodejs/util/NodePackage", "validateForRunConfiguration"));
        }
        String message = this.getErrorMessage(packageName);
        if (message != null) {
            throw new RuntimeConfigurationError(message);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodePackage aPackage = (NodePackage)o;
        return this.mySystemDependentPath.equals(aPackage.mySystemDependentPath);
    }

    public int hashCode() {
        return this.mySystemDependentPath.hashCode();
    }

    @Nullable
    public static NodePackage findDefaultPackage(@NotNull Project project, @NotNull String packageName, @Nullable NodeJsInterpreter interpreter) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/util/NodePackage", "findDefaultPackage"));
        }
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/intellij/javascript/nodejs/util/NodePackage", "findDefaultPackage"));
        }
        List<NodePackage> packages = NodePackage.collectAvailableNodePackages(project, packageName, interpreter, false);
        return (NodePackage)ContainerUtil.getFirstItem(packages);
    }

    @NotNull
    public static NodePackage findPreferredPackage(@NotNull Project project, @NotNull String packageName, @Nullable NodeJsInterpreter interpreter) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/util/NodePackage", "findPreferredPackage"));
        }
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/intellij/javascript/nodejs/util/NodePackage", "findPreferredPackage"));
        }
        NodePackage nodePackage = NodePackage.findPreferredPackage(project, packageName, interpreter, false);
        if (nodePackage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/util/NodePackage", "findPreferredPackage"));
        }
        return nodePackage;
    }

    @NotNull
    public static NodePackage findPreferredPackage(@NotNull Project project, @NotNull String packageName, @Nullable NodeJsInterpreter interpreter, boolean includeSecondLevelPackages) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/util/NodePackage", "findPreferredPackage"));
        }
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/intellij/javascript/nodejs/util/NodePackage", "findPreferredPackage"));
        }
        NodePackage nodePackage = new NodePackageDescriptor(packageName).findPreferredPackage(project, interpreter, null);
        if (nodePackage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/util/NodePackage", "findPreferredPackage"));
        }
        return nodePackage;
    }

    @NotNull
    public static List<NodePackage> collectAvailableNodePackages(@NotNull Project project, @NotNull String packageName, @Nullable NodeJsInterpreter interpreter, boolean includeSecondLevelPackages) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/util/NodePackage", "collectAvailableNodePackages"));
        }
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/intellij/javascript/nodejs/util/NodePackage", "collectAvailableNodePackages"));
        }
        NodePackageDescriptor descriptor2 = new NodePackageDescriptor(packageName);
        List<NodePackage> list = descriptor2.listAvailable(project, interpreter, null);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/util/NodePackage", "collectAvailableNodePackages"));
        }
        return list;
    }

    public String toString() {
        return this.mySystemDependentPath;
    }
}

