/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.util;

import com.google.common.collect.ImmutableList;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.javascript.nodejs.CompletionModuleInfo;
import com.intellij.javascript.nodejs.ModuleType;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodePackageDescriptor {
    private final List<String> myPackageNames;

    public NodePackageDescriptor(@NotNull String packageName) {
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/intellij/javascript/nodejs/util/NodePackageDescriptor", "<init>"));
        }
        this.myPackageNames = Collections.singletonList(packageName);
    }

    public NodePackageDescriptor(String ... packageNames) {
        if (packageNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageNames", "com/intellij/javascript/nodejs/util/NodePackageDescriptor", "<init>"));
        }
        this.myPackageNames = ImmutableList.copyOf((Object[])packageNames);
    }

    public NodePackageDescriptor(@NotNull List<String> packageNames) {
        if (packageNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageNames", "com/intellij/javascript/nodejs/util/NodePackageDescriptor", "<init>"));
        }
        this.myPackageNames = ImmutableList.copyOf(packageNames);
    }

    @NotNull
    public List<String> getPackageNames() {
        List<String> list = this.myPackageNames;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/util/NodePackageDescriptor", "getPackageNames"));
        }
        return list;
    }

    @NotNull
    public NodePackage findPreferredPackage(@NotNull Project project, @Nullable NodeJsInterpreter interpreter, @Nullable VirtualFile contextFileOrDirectory) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/util/NodePackageDescriptor", "findPreferredPackage"));
        }
        NodePackage nodePackage = (NodePackage)ReadAction.compute(() -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/util/NodePackageDescriptor", "lambda$findPreferredPackage$0"));
            }
            List<NodePackage> packages = this.listAvailable(project, interpreter, contextFileOrDirectory);
            ProjectFileIndex fileIndex = ProjectFileIndex.getInstance((Project)project);
            NodePackage localPackage = null;
            for (NodePackage pkg : packages) {
                VirtualFile dir = LocalFileSystem.getInstance().findFileByPath(pkg.getSystemIndependentPath());
                if (JSLibraryUtil.getContentRootForFile(fileIndex, dir) == null) continue;
                if (localPackage != null) {
                    return new NodePackage("");
                }
                localPackage = pkg;
            }
            if (localPackage != null) {
                return localPackage;
            }
            if (packages.size() == 1) {
                return (NodePackage)ContainerUtil.getFirstItem(packages);
            }
            return new NodePackage("");
        });
        if (nodePackage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/util/NodePackageDescriptor", "findPreferredPackage"));
        }
        return nodePackage;
    }

    @NotNull
    public final List<NodePackage> listAvailable(@NotNull Project project, @Nullable NodeJsInterpreter interpreter, @Nullable VirtualFile contextFileOrDirectory) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/util/NodePackageDescriptor", "listAvailable"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        LinkedHashSet<NodePackage> packages = new LinkedHashSet<NodePackage>();
        for (String packageName : this.myPackageNames) {
            this.listAvailable(packages, packageName, project, interpreter, contextFileOrDirectory);
        }
        ArrayList<NodePackage> arrayList = new ArrayList<NodePackage>(packages);
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/util/NodePackageDescriptor", "listAvailable"));
        }
        return arrayList;
    }

    protected void listAvailable(@NotNull Set<NodePackage> packages, @NotNull String packageName, @NotNull Project project, @Nullable NodeJsInterpreter interpreter, @Nullable VirtualFile contextFileOrDirectory) {
        if (packages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packages", "com/intellij/javascript/nodejs/util/NodePackageDescriptor", "listAvailable"));
        }
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/intellij/javascript/nodejs/util/NodePackageDescriptor", "listAvailable"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/util/NodePackageDescriptor", "listAvailable"));
        }
        ArrayList modules = ContainerUtil.newArrayList();
        if (contextFileOrDirectory != null) {
            NodeModuleSearchUtil.findModulesWithName((List<CompletionModuleInfo>)modules, packageName, contextFileOrDirectory, false, null);
        }
        NodeModuleSearchUtil.findModulesByNameInContentRoots(modules, packageName, project, false, interpreter, true);
        Collection<Object> packageJsonFiles = Collections.emptyList();
        if (!DumbService.isDumb((Project)project)) {
            try {
                packageJsonFiles = FilenameIndex.getVirtualFilesByName((Project)project, (String)"package.json", (GlobalSearchScope)GlobalSearchScope.projectScope((Project)project));
            }
            catch (IndexNotReadyException indexNotReadyException) {
                // empty catch block
            }
        }
        for (VirtualFile packageJson : packageJsonFiles) {
            VirtualFile nodeModulesDir;
            PackageJsonData data = PackageJsonData.getOrCreate(packageJson);
            if (!data.getAllDependencies().contains(packageName) || (nodeModulesDir = NodeModuleUtil.findNodeModulesByPackageJson(packageJson)) == null) continue;
            NodeModuleSearchUtil.findModuleWithNameInDirectory(modules, nodeModulesDir, ModuleType.NODE_MODULES_DIR, packageName);
        }
        for (CompletionModuleInfo module : modules) {
            VirtualFile dir = module.getVirtualFile();
            if (dir == null || !dir.isDirectory()) continue;
            packages.add(new NodePackage(dir.getPath()));
        }
        if ("yarn".equals(packageName)) {
            if (SystemInfo.isWindows) {
                NodePackageDescriptor.tryAdd(packages, new File("C:\\Program Files (x86)\\Yarn"));
                NodePackageDescriptor.tryAdd(packages, new File("C:\\Program Files\\Yarn"));
            } else {
                NodePackageDescriptor.tryAdd(packages, new File("/usr/share/yarn"));
                NodePackageDescriptor.tryAdd(packages, new File("/opt/local/libexec/yarn"));
                File cellarYarnDir = NodePackageDescriptor.findCellarYarnDir();
                if (cellarYarnDir != null) {
                    File[] versions;
                    for (File version : versions = (File[])ObjectUtils.notNull((Object)cellarYarnDir.listFiles(), (Object)ArrayUtil.EMPTY_FILE_ARRAY)) {
                        if (NodePackageDescriptor.tryAdd(packages, new File(version, "libexec"))) continue;
                        NodePackageDescriptor.tryAdd(packages, new File(version, "libexec/lib/node_modules/yarn"));
                    }
                }
            }
        }
    }

    private static boolean tryAdd(@NotNull Set<NodePackage> packages, @NotNull File packageDir) {
        File packageJson;
        if (packages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packages", "com/intellij/javascript/nodejs/util/NodePackageDescriptor", "tryAdd"));
        }
        if (packageDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageDir", "com/intellij/javascript/nodejs/util/NodePackageDescriptor", "tryAdd"));
        }
        if (packageDir.isDirectory() && (packageJson = new File(packageDir, "package.json")).isFile()) {
            packages.add(new NodePackage(packageDir.getAbsolutePath()));
            return true;
        }
        return false;
    }

    private static File findCellarYarnDir() {
        File yarn;
        File root;
        File bin;
        File yarnExe = PathEnvironmentVariableUtil.findInPath((String)"yarn");
        if (yarnExe != null && (bin = yarnExe.getParentFile()) != null && bin.getName().equals("bin") && (root = bin.getParentFile()) != null && (yarn = new File(root, "Cellar/yarn")).isDirectory()) {
            return yarn;
        }
        File yarn2 = new File(SystemProperties.getUserHome(), ".linuxbrew/Cellar/yarn");
        if (yarn2.isDirectory()) {
            return yarn2;
        }
        yarn2 = new File("/usr/local/Cellar/yarn");
        if (yarn2.isDirectory()) {
            return yarn2;
        }
        return null;
    }
}

