/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.css.linter.stylelint;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.css.linter.stylelint.StylelintConfigurable;
import com.intellij.lang.css.linter.stylelint.StylelintConfiguration;
import com.intellij.lang.css.linter.stylelint.StylelintExternalRunner;
import com.intellij.lang.css.linter.stylelint.StylelintInspection;
import com.intellij.lang.css.linter.stylelint.StylelintState;
import com.intellij.lang.javascript.linter.JSLinterAnnotationResult;
import com.intellij.lang.javascript.linter.JSLinterAnnotationsBuilder;
import com.intellij.lang.javascript.linter.JSLinterConfigurable;
import com.intellij.lang.javascript.linter.JSLinterConfiguration;
import com.intellij.lang.javascript.linter.JSLinterEditSettingsAction;
import com.intellij.lang.javascript.linter.JSLinterExternalAnnotator;
import com.intellij.lang.javascript.linter.JSLinterInput;
import com.intellij.lang.javascript.linter.JSLinterInspection;
import com.intellij.lang.javascript.linter.JSLinterStandardFixes;
import com.intellij.lang.javascript.linter.JSLinterWithInspectionExternalAnnotator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssFileType;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.util.containers.ContainerUtil;
import icons.JavaScriptLanguageIcons;
import java.util.Locale;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StylelintExternalAnnotator
extends JSLinterExternalAnnotator<StylelintState> {
    public static final StylelintExternalAnnotator INSTANCE_FOR_BATCH_INSPECTION = new StylelintExternalAnnotator(false);
    private static final Set<String> STYLELINT_SUPPORTED_FORMATS = ContainerUtil.set((Object[])new String[]{"css", "less", "scss", "pcss"});

    public StylelintExternalAnnotator() {
        super(true);
    }

    public StylelintExternalAnnotator(boolean onTheFly) {
        super(onTheFly);
    }

    @Override
    @NotNull
    protected JSLinterConfigurable<StylelintState> createSettingsConfigurable(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/css/linter/stylelint/StylelintExternalAnnotator", "createSettingsConfigurable"));
        }
        StylelintConfigurable stylelintConfigurable = new StylelintConfigurable(project, true);
        if (stylelintConfigurable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/css/linter/stylelint/StylelintExternalAnnotator", "createSettingsConfigurable"));
        }
        return stylelintConfigurable;
    }

    @Override
    protected Class<? extends JSLinterConfiguration<StylelintState>> getConfigurationClass() {
        return StylelintConfiguration.class;
    }

    @Override
    protected Class<? extends JSLinterInspection> getInspectionClass() {
        return StylelintInspection.class;
    }

    @Override
    @Nullable
    public Icon getFileLevelAnnotationDefaultIcon() {
        return JavaScriptLanguageIcons.FileTypes.Stylelint;
    }

    @Override
    protected boolean acceptPsiFile(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/css/linter/stylelint/StylelintExternalAnnotator", "acceptPsiFile"));
        }
        return file instanceof StylesheetFile && StylelintExternalAnnotator.isSupportedFormat(file);
    }

    @Override
    @Nullable
    public JSLinterAnnotationResult<StylelintState> annotate(@NotNull JSLinterInput<StylelintState> input) {
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/intellij/lang/css/linter/stylelint/StylelintExternalAnnotator", "annotate"));
        }
        return new StylelintExternalRunner(this.isOnTheFly()).execute(input);
    }

    @Override
    public void apply(@NotNull PsiFile file, @Nullable JSLinterAnnotationResult<StylelintState> annotationResult, @NotNull AnnotationHolder holder) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/css/linter/stylelint/StylelintExternalAnnotator", "apply"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/css/linter/stylelint/StylelintExternalAnnotator", "apply"));
        }
        if (annotationResult == null) {
            return;
        }
        HighlightDisplayKey inspectionKey = JSLinterInspection.getHighlightDisplayKeyByClass(this.getInspectionClass());
        String prefix = CssBundle.message((String)"css.stylelint.message.prefix", (Object[])new Object[0]) + " ";
        StylelintConfigurable configurable = new StylelintConfigurable(file.getProject(), true);
        JSLinterStandardFixes fixes = new JSLinterStandardFixes().setEditSettingsAction(new JSLinterEditSettingsAction(configurable, JavaScriptLanguageIcons.FileTypes.Stylelint));
        new JSLinterAnnotationsBuilder<StylelintState>(file, annotationResult, holder, inspectionKey, configurable, prefix, this.getInspectionClass(), fixes).setHighlightingGranularity(JSLinterWithInspectionExternalAnnotator.HighlightingGranularity.element).apply();
    }

    private static boolean isSupportedFormat(PsiFile file) {
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        if (file.getFileType() == CssFileType.INSTANCE) {
            return true;
        }
        String extension = virtualFile.getExtension();
        return extension != null && STYLELINT_SUPPORTED_FORMATS.contains(extension.toLowerCase(Locale.US));
    }
}

