/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.css.linter.stylelint;

import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.linter.JSLinterNpmPackageDoesNotExistsException;
import com.intellij.lang.javascript.linter.JSLinterUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.text.SemVer;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class StylelintPackage {
    private static final String UNDEFINED_VERSION = "<unknown>";
    private final VirtualFile myCli;
    private final String myVersion;

    public StylelintPackage(@NotNull VirtualFile cli, @NotNull String version) throws IOException {
        if (cli == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cli", "com/intellij/lang/css/linter/stylelint/StylelintPackage", "<init>"));
        }
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/intellij/lang/css/linter/stylelint/StylelintPackage", "<init>"));
        }
        this.myCli = cli;
        this.myVersion = version;
    }

    @NotNull
    public static StylelintPackage fromNodePackage(@NotNull Project project, @NotNull NodePackage pkg, boolean refresh) throws IOException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/css/linter/stylelint/StylelintPackage", "fromNodePackage"));
        }
        if (pkg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pkg", "com/intellij/lang/css/linter/stylelint/StylelintPackage", "fromNodePackage"));
        }
        String path = pkg.getSystemIndependentPath();
        if (StringUtil.isEmpty((String)path)) {
            throw new JSLinterNpmPackageDoesNotExistsException(JSLinterUtil.createLinterPackageError(project, path, "Stylelint"));
        }
        VirtualFile packageDir = LocalFileSystem.getInstance().findFileByPath(path);
        if (packageDir == null || !packageDir.isValid() || !packageDir.isDirectory()) {
            throw new JSLinterNpmPackageDoesNotExistsException(JSLinterUtil.createLinterPackageError(project, path, "Stylelint"));
        }
        VirtualFile packageJson = packageDir.findChild("package.json");
        if (packageJson == null || !packageJson.isValid() || packageJson.isDirectory()) {
            throw new IOException("Please specify Stylelint package correctly: \".../package.json\" file not found");
        }
        PackageJsonData packageJsonData = PackageJsonUtil.getOrCreateData(packageJson, refresh);
        SemVer version = packageJsonData.getVersion();
        String packageVersion = version != null ? version.getRawVersion() : UNDEFINED_VERSION;
        String binPath = (String)ObjectUtils.notNull((Object)packageJsonData.getBinPath(), (Object)("dist" + File.separator + "cli.js"));
        VirtualFile cli = packageDir.findFileByRelativePath(binPath);
        if (cli == null || !cli.isValid() || cli.isDirectory()) {
            throw new IOException("Please specify Stylelint package correctly: \".../" + binPath + "\" file not found");
        }
        StylelintPackage stylelintPackage = new StylelintPackage(cli, packageVersion);
        if (stylelintPackage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/css/linter/stylelint/StylelintPackage", "fromNodePackage"));
        }
        return stylelintPackage;
    }

    @NotNull
    public VirtualFile getCli() {
        VirtualFile virtualFile = this.myCli;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/css/linter/stylelint/StylelintPackage", "getCli"));
        }
        return virtualFile;
    }

    @NotNull
    public String getVersionStr() {
        String string = this.myVersion;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/css/linter/stylelint/StylelintPackage", "getVersionStr"));
        }
        return string;
    }
}

