/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.findUsages;

import com.intellij.lang.ecmascript6.psi.ES6ExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ExportedDefaultBinding;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSPsiNamedElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.QuerySearchRequest;
import com.intellij.psi.search.RequestResultProcessor;
import com.intellij.psi.search.SearchRequestCollector;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6ExportDefaultReferenceSearcher
extends QueryExecutorBase<PsiReference, ReferencesSearch.SearchParameters> {
    public ES6ExportDefaultReferenceSearcher() {
        super(true);
    }

    public void processQuery(@NotNull ReferencesSearch.SearchParameters queryParameters, @NotNull Processor<PsiReference> consumer) {
        if (queryParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryParameters", "com/intellij/lang/ecmascript6/findUsages/ES6ExportDefaultReferenceSearcher", "processQuery"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/lang/ecmascript6/findUsages/ES6ExportDefaultReferenceSearcher", "processQuery"));
        }
        PsiElement element = queryParameters.getElementToSearch();
        if (!(element instanceof JSElement)) {
            return;
        }
        SearchScope scope = queryParameters.getEffectiveSearchScope();
        if (scope instanceof LocalSearchScope) {
            return;
        }
        PsiElement exportElement = ES6ExportDefaultReferenceSearcher.getExportDefaultElement(element);
        if (exportElement != null) {
            ES6ExportDefaultReferenceSearcher.searchExportDefaultUsages(exportElement, queryParameters, new SearchRequestCollector(queryParameters.getOptimizer().getSearchSession()), consumer);
        } else {
            if (!(element instanceof JSPsiNamedElementBase)) {
                return;
            }
            DialectOptionHolder holder = DialectDetector.dialectOfElement(element);
            if (holder == null || !holder.hasFeature(JSLanguageFeature.EXPORT_DECLARATIONS)) {
                return;
            }
            String name = ((JSPsiNamedElementBase)element).getName();
            if (name != null) {
                SearchRequestCollector collector = queryParameters.getOptimizer();
                collector.searchWord(name, scope, (short)1, true, element, (RequestResultProcessor)new MyProcessor(queryParameters));
            }
        }
    }

    @Nullable
    private static PsiElement getExportDefaultElement(PsiElement element) {
        PsiElement exportElement = null;
        if (element instanceof ES6ExportDefaultAssignment || ES6ExportDefaultReferenceSearcher.isDefaultExportThroughSpecifier(element)) {
            exportElement = element;
        } else {
            PsiElement parent = element.getContext();
            if (parent instanceof ES6ExportDefaultAssignment) {
                exportElement = parent;
            }
        }
        return exportElement;
    }

    private static boolean isDefaultExportThroughSpecifier(PsiElement element) {
        if (!(element instanceof ES6ExportSpecifier)) {
            return false;
        }
        ES6ExportSpecifierAlias alias = ((ES6ExportSpecifier)element).getAlias();
        return alias != null && "default".equals(alias.getName());
    }

    private static void searchExportDefaultUsages(@NotNull PsiElement exportElement, @NotNull ReferencesSearch.SearchParameters queryParameters, @NotNull SearchRequestCollector newCollector, @NotNull Processor<PsiReference> consumer) {
        if (exportElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exportElement", "com/intellij/lang/ecmascript6/findUsages/ES6ExportDefaultReferenceSearcher", "searchExportDefaultUsages"));
        }
        if (queryParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryParameters", "com/intellij/lang/ecmascript6/findUsages/ES6ExportDefaultReferenceSearcher", "searchExportDefaultUsages"));
        }
        if (newCollector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newCollector", "com/intellij/lang/ecmascript6/findUsages/ES6ExportDefaultReferenceSearcher", "searchExportDefaultUsages"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/lang/ecmascript6/findUsages/ES6ExportDefaultReferenceSearcher", "searchExportDefaultUsages"));
        }
        JSElement container = ES6PsiUtil.getExportScope(exportElement);
        if (container == null && (container = PsiTreeUtil.getContextOfType((PsiElement)exportElement, (Class[])new Class[]{XmlFile.class})) == null) {
            return;
        }
        SearchScope scope = queryParameters.getScopeDeterminedByUser();
        queryParameters.getOptimizer().searchQuery(new QuerySearchRequest(ReferencesSearch.search((PsiElement)container), newCollector, false, (fileReference, _collector) -> {
            if (queryParameters == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryParameters", "com/intellij/lang/ecmascript6/findUsages/ES6ExportDefaultReferenceSearcher", "lambda$searchExportDefaultUsages$0"));
            }
            if (consumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/lang/ecmascript6/findUsages/ES6ExportDefaultReferenceSearcher", "lambda$searchExportDefaultUsages$0"));
            }
            PsiElement fileReferenceElement = fileReference.getElement();
            if (!(fileReferenceElement instanceof ES6FromClause)) {
                return true;
            }
            PsiElement importOrExportDeclaration = fileReferenceElement.getParent();
            if (!ES6ExportDefaultReferenceSearcher.processImportDeclaration(_collector, queryParameters, consumer, scope, importOrExportDeclaration)) {
                return false;
            }
            return ES6ExportDefaultReferenceSearcher.processExportDeclaration(_collector, queryParameters, consumer, scope, importOrExportDeclaration);
        }));
    }

    private static boolean processImportDeclaration(@NotNull SearchRequestCollector collector, @NotNull ReferencesSearch.SearchParameters queryParameters, @NotNull Processor<PsiReference> consumer, @NotNull SearchScope scope, @Nullable PsiElement importDeclarationCandidate) {
        ES6ImportedBinding[] importedBindings;
        if (collector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collector", "com/intellij/lang/ecmascript6/findUsages/ES6ExportDefaultReferenceSearcher", "processImportDeclaration"));
        }
        if (queryParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryParameters", "com/intellij/lang/ecmascript6/findUsages/ES6ExportDefaultReferenceSearcher", "processImportDeclaration"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/lang/ecmascript6/findUsages/ES6ExportDefaultReferenceSearcher", "processImportDeclaration"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/ecmascript6/findUsages/ES6ExportDefaultReferenceSearcher", "processImportDeclaration"));
        }
        if (!(importDeclarationCandidate instanceof ES6ImportDeclaration)) {
            return true;
        }
        ES6ImportDeclaration importDeclaration = (ES6ImportDeclaration)importDeclarationCandidate;
        for (ES6ImportedBinding eS6ImportedBinding : importedBindings = importDeclaration.getImportedBindings()) {
            PsiElement nameIdentifier;
            if (eS6ImportedBinding.isNamespaceImport() || (nameIdentifier = eS6ImportedBinding.getNameIdentifier()) == null) continue;
            ES6ExportDefaultReferenceSearcher.addExplicitReference(queryParameters, consumer, nameIdentifier, (PsiElement)eS6ImportedBinding);
            if (ES6ExportDefaultReferenceSearcher.searchAdditionalReferences(collector, consumer, scope, (PsiNamedElement)eS6ImportedBinding)) continue;
            return false;
        }
        for (ES6ImportedBinding eS6ImportedBinding : importDeclaration.getImportSpecifiers()) {
            if (ES6ExportDefaultReferenceSearcher.processSpecifier(collector, queryParameters, consumer, scope, (ES6ImportExportSpecifier)eS6ImportedBinding)) continue;
            return false;
        }
        return true;
    }

    private static boolean processSpecifier(@NotNull SearchRequestCollector collector, @NotNull ReferencesSearch.SearchParameters queryParameters, @NotNull Processor<PsiReference> consumer, @NotNull SearchScope scope, @NotNull ES6ImportExportSpecifier specifier) {
        if (collector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collector", "com/intellij/lang/ecmascript6/findUsages/ES6ExportDefaultReferenceSearcher", "processSpecifier"));
        }
        if (queryParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryParameters", "com/intellij/lang/ecmascript6/findUsages/ES6ExportDefaultReferenceSearcher", "processSpecifier"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/lang/ecmascript6/findUsages/ES6ExportDefaultReferenceSearcher", "processSpecifier"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/ecmascript6/findUsages/ES6ExportDefaultReferenceSearcher", "processSpecifier"));
        }
        if (specifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "specifier", "com/intellij/lang/ecmascript6/findUsages/ES6ExportDefaultReferenceSearcher", "processSpecifier"));
        }
        if (!specifier.isDefault()) {
            return true;
        }
        ES6ImportExportSpecifierAlias alias = specifier.getAlias();
        if (alias == null) {
            return true;
        }
        PsiElement nameElement = specifier.getReferenceNameElement();
        if (nameElement == null) {
            return true;
        }
        ES6ExportDefaultReferenceSearcher.addExplicitReference(queryParameters, consumer, nameElement, (PsiElement)specifier);
        return ES6ExportDefaultReferenceSearcher.searchAdditionalReferences(collector, consumer, scope, (PsiNamedElement)alias);
    }

    private static boolean processExportDeclaration(@NotNull SearchRequestCollector collector, @NotNull ReferencesSearch.SearchParameters queryParameters, @NotNull Processor<PsiReference> consumer, @NotNull SearchScope scope, @Nullable PsiElement exportDeclarationCandidate) {
        PsiElement nameIdentifier;
        if (collector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collector", "com/intellij/lang/ecmascript6/findUsages/ES6ExportDefaultReferenceSearcher", "processExportDeclaration"));
        }
        if (queryParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryParameters", "com/intellij/lang/ecmascript6/findUsages/ES6ExportDefaultReferenceSearcher", "processExportDeclaration"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/lang/ecmascript6/findUsages/ES6ExportDefaultReferenceSearcher", "processExportDeclaration"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/ecmascript6/findUsages/ES6ExportDefaultReferenceSearcher", "processExportDeclaration"));
        }
        if (!(exportDeclarationCandidate instanceof ES6ExportDeclaration)) {
            return true;
        }
        ES6ExportDeclaration exportDeclaration = (ES6ExportDeclaration)exportDeclarationCandidate;
        ES6ExportedDefaultBinding exportBinding = exportDeclaration.getExportedDefaultBinding();
        PsiElement psiElement = nameIdentifier = exportBinding == null ? null : exportBinding.getNameIdentifier();
        if (nameIdentifier != null) {
            ES6ExportDefaultReferenceSearcher.addExplicitReference(queryParameters, consumer, nameIdentifier, (PsiElement)exportBinding);
            if (!ES6ExportDefaultReferenceSearcher.searchAdditionalReferences(collector, consumer, scope, (PsiNamedElement)exportBinding)) {
                return false;
            }
        }
        for (ES6ExportSpecifier specifier : exportDeclaration.getExportSpecifiers()) {
            if (ES6ExportDefaultReferenceSearcher.processSpecifier(collector, queryParameters, consumer, scope, (ES6ImportExportSpecifier)specifier)) continue;
            return false;
        }
        return true;
    }

    private static boolean searchAdditionalReferences(@NotNull SearchRequestCollector collector, @NotNull Processor<PsiReference> consumer, @NotNull SearchScope scope, @NotNull PsiNamedElement elementToSearch) {
        if (collector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collector", "com/intellij/lang/ecmascript6/findUsages/ES6ExportDefaultReferenceSearcher", "searchAdditionalReferences"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/lang/ecmascript6/findUsages/ES6ExportDefaultReferenceSearcher", "searchAdditionalReferences"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/ecmascript6/findUsages/ES6ExportDefaultReferenceSearcher", "searchAdditionalReferences"));
        }
        if (elementToSearch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToSearch", "com/intellij/lang/ecmascript6/findUsages/ES6ExportDefaultReferenceSearcher", "searchAdditionalReferences"));
        }
        String name = elementToSearch.getName();
        if (name != null) {
            ReferencesSearch.searchOptimized((PsiElement)elementToSearch, (SearchScope)scope.intersectWith(elementToSearch.getUseScope()), (boolean)false, (SearchRequestCollector)collector, consumer);
        }
        return true;
    }

    private static void addExplicitReference(@NotNull ReferencesSearch.SearchParameters queryParameters, @NotNull Processor<PsiReference> consumer, @NotNull PsiElement nameIdentifier, @NotNull PsiElement parent) {
        if (queryParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryParameters", "com/intellij/lang/ecmascript6/findUsages/ES6ExportDefaultReferenceSearcher", "addExplicitReference"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/lang/ecmascript6/findUsages/ES6ExportDefaultReferenceSearcher", "addExplicitReference"));
        }
        if (nameIdentifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameIdentifier", "com/intellij/lang/ecmascript6/findUsages/ES6ExportDefaultReferenceSearcher", "addExplicitReference"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/lang/ecmascript6/findUsages/ES6ExportDefaultReferenceSearcher", "addExplicitReference"));
        }
        TextRange nameRange = ES6ExportDefaultReferenceSearcher.getRangeInParentElement(parent, nameIdentifier);
        PsiReferenceBase.Immediate ref = new PsiReferenceBase.Immediate(parent, nameRange, queryParameters.getElementToSearch());
        consumer.process((Object)ref);
    }

    private static TextRange getRangeInParentElement(PsiElement importedBinding, PsiElement nameIdentifier) {
        return nameIdentifier.getTextRange().shiftRight(-importedBinding.getTextRange().getStartOffset());
    }

    private static class MyProcessor
    extends RequestResultProcessor {
        private final ReferencesSearch.SearchParameters myQueryParameters;
        private final SearchRequestCollector myOwnCollector;

        MyProcessor(@NotNull ReferencesSearch.SearchParameters queryParameters) {
            if (queryParameters == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryParameters", "com/intellij/lang/ecmascript6/findUsages/ES6ExportDefaultReferenceSearcher$MyProcessor", "<init>"));
            }
            super(new Object[0]);
            this.myQueryParameters = queryParameters;
            this.myOwnCollector = new SearchRequestCollector(queryParameters.getOptimizer().getSearchSession());
        }

        public boolean processTextOccurrence(@NotNull PsiElement element, int offsetInElement, @NotNull Processor<PsiReference> consumer) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/ecmascript6/findUsages/ES6ExportDefaultReferenceSearcher$MyProcessor", "processTextOccurrence"));
            }
            if (consumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/lang/ecmascript6/findUsages/ES6ExportDefaultReferenceSearcher$MyProcessor", "processTextOccurrence"));
            }
            if (!(element instanceof JSReferenceExpression)) {
                return true;
            }
            JSReferenceExpression reference = (JSReferenceExpression)element;
            if (!reference.isReferenceTo(this.myQueryParameters.getElementToSearch())) {
                return true;
            }
            PsiElement parent = element.getParent();
            if (parent instanceof ES6ExportDefaultAssignment) {
                ES6ExportDefaultReferenceSearcher.searchExportDefaultUsages(parent, this.myQueryParameters, this.myOwnCollector, (Processor<PsiReference>)consumer);
            }
            return true;
        }
    }
}

