/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.ecmascript6.ES6ElementTypes;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportExportSpecifierAliasBase;
import com.intellij.lang.ecmascript6.psi.stubs.ES6ImportExportSpecifierStub;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPolyVariantReferenceBase;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.rename.BindablePsiReference;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ES6ImportExportSpecifierBase<T extends ES6ImportExportSpecifierStub<?>>
extends JSPolyVariantReferenceBase<T>
implements BindablePsiReference,
ES6ImportExportSpecifier,
StubBasedPsiElement<T> {
    public ES6ImportExportSpecifierBase(ASTNode node) {
        super(node);
    }

    public ES6ImportExportSpecifierBase(T stub, IStubElementType type) {
        super(stub, type);
    }

    @NotNull
    protected static ResolveResult[] resolveDefaultExport(@NotNull ES6ImportExportSpecifierBase specifier) {
        if (specifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "specifier", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportExportSpecifierBase", "resolveDefaultExport"));
        }
        ES6FromClause clause = specifier.getDeclarationFromClause();
        if (clause != null) {
            for (PsiElement element : clause.resolveReferencedElements()) {
                JSElement defaultExport;
                if (!(element instanceof JSElement) || (defaultExport = ES6PsiUtil.findDefaultExport((PsiElement)((JSElement)element))) == null) continue;
                ResolveResult[] resolveResultArray = new ResolveResult[]{new JSResolveResult((PsiElement)defaultExport)};
                if (resolveResultArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportExportSpecifierBase", "resolveDefaultExport"));
                }
                return resolveResultArray;
            }
        }
        if (ResolveResult.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportExportSpecifierBase", "resolveDefaultExport"));
        }
        return ResolveResult.EMPTY_ARRAY;
    }

    @Nullable
    protected ASTNode getReferenceElement() {
        return ES6ImportExportSpecifierBase.getReferenceElement(this.getNode());
    }

    @Nullable
    private static ASTNode getReferenceElement(@NotNull ASTNode importExportSpecifierNode) {
        if (importExportSpecifierNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importExportSpecifierNode", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportExportSpecifierBase", "getReferenceElement"));
        }
        return importExportSpecifierNode.findChildByType(JSKeywordSets.IDENTIFIER_NAMES);
    }

    @Nullable
    public String getDeclaredName() {
        ES6ImportExportSpecifierAlias alias = this.getAlias();
        if (alias != null) {
            return alias.getName();
        }
        return this.getReferenceName();
    }

    @Nullable
    public static ASTNode getDeclarationNameElement(@NotNull ASTNode importExportSpecifierNode) {
        if (importExportSpecifierNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importExportSpecifierNode", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportExportSpecifierBase", "getDeclarationNameElement"));
        }
        ASTNode alias = importExportSpecifierNode.findChildByType((IElementType)ES6ElementTypes.IMPORT_SPECIFIER_ALIAS);
        if (alias == null) {
            alias = importExportSpecifierNode.findChildByType((IElementType)ES6ElementTypes.EXPORT_SPECIFIER_ALIAS);
        }
        if (alias != null) {
            return ES6ImportExportSpecifierAliasBase.findNameIdentifier(alias);
        }
        return ES6ImportExportSpecifierBase.getReferenceElement(importExportSpecifierNode);
    }

    public TextRange getRangeInElement() {
        int length;
        int startOffset;
        ASTNode nameIdentifier = this.getReferenceElement();
        if (nameIdentifier != null) {
            startOffset = nameIdentifier.getTextRange().getStartOffset() - this.getNode().getStartOffset();
            length = nameIdentifier.getTextLength();
        } else {
            startOffset = 0;
            length = this.getTextLength();
        }
        return new TextRange(startOffset, startOffset + length);
    }

    @NotNull
    public String getCanonicalText() {
        TextRange range = this.getRangeInElement();
        String string = this.getText().substring(range.getStartOffset(), range.getEndOffset());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportExportSpecifierBase", "getCanonicalText"));
        }
        return string;
    }

    @NotNull
    public String getReferenceName() {
        ES6ImportExportSpecifierStub stub = (ES6ImportExportSpecifierStub)this.getGreenStub();
        if (stub != null) {
            String string = stub.getReferencedName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportExportSpecifierBase", "getReferenceName"));
            }
            return string;
        }
        String string = this.getCanonicalText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportExportSpecifierBase", "getReferenceName"));
        }
        return string;
    }

    @Override
    public PsiElement getElement() {
        return this;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        throw new IncorrectOperationException("Unexpected rename request");
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportExportSpecifierBase", "bindToElement"));
        }
        if (!(element instanceof JSNamedElement)) {
            return this;
        }
        String newName = ((JSNamedElement)element).getName();
        ASTNode referenceElement = this.getReferenceElement();
        if (newName != null && referenceElement != null && !newName.equals(referenceElement.getText())) {
            ASTNode nameElement = JSChangeUtil.createNameIdentifier(this.getProject(), newName, DialectDetector.languageDialectOfElement((PsiElement)this));
            this.getNode().replaceChild(referenceElement, nameElement);
        }
        return this;
    }

    public boolean isSoft() {
        return false;
    }

    @Nullable
    public ES6ImportExportDeclaration getDeclaration() {
        ES6ImportExportSpecifierStub stub = (ES6ImportExportSpecifierStub)this.getGreenStub();
        if (stub != null) {
            return (ES6ImportExportDeclaration)stub.getParentStubOfType(ES6ImportExportDeclaration.class);
        }
        return (ES6ImportExportDeclaration)PsiTreeUtil.getParentOfType((PsiElement)this, ES6ImportExportDeclaration.class);
    }

    @Nullable
    protected ES6FromClause getDeclarationFromClause() {
        ES6ImportExportDeclaration declaration = this.getDeclaration();
        if (declaration != null) {
            return declaration.getFromClause();
        }
        return null;
    }

    public boolean isDefault() {
        ES6ImportExportSpecifierStub stub = (ES6ImportExportSpecifierStub)this.getGreenStub();
        if (stub != null) {
            return stub.isDefault();
        }
        ASTNode element = this.getReferenceElement();
        return element != null && element.getElementType() == JSTokenTypes.DEFAULT_KEYWORD;
    }

    @NotNull
    public ResolveResult[] resolveOverAliases() {
        ResolveResult[] results = this.multiResolve(false);
        ArrayList newResults = ContainerUtil.newArrayList();
        for (ResolveResult result : results) {
            PsiElement element = result.getElement();
            if (element instanceof ES6ImportExportSpecifierAlias) {
                ES6ImportExportSpecifier aliasedElement = ((ES6ImportExportSpecifierAlias)element).findSpecifierElement();
                if (aliasedElement instanceof ES6ImportExportSpecifierBase) {
                    Object[] resolveOverAliases = ((ES6ImportExportSpecifierBase)aliasedElement).resolveOverAliases();
                    ContainerUtil.addAll((Collection)newResults, (Object[])resolveOverAliases);
                    continue;
                }
                newResults.add(new JSResolveResult((PsiElement)aliasedElement));
                continue;
            }
            newResults.add(result);
        }
        ResolveResult[] resolveResultArray = (ResolveResult[])ContainerUtil.toArray((Collection)newResults, (Object[])new ResolveResult[newResults.size()]);
        if (resolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportExportSpecifierBase", "resolveOverAliases"));
        }
        return resolveResultArray;
    }

    @Nullable
    public PsiElement getReferenceNameElement() {
        ASTNode element = this.getReferenceElement();
        return element != null ? element.getPsi() : null;
    }

    @NotNull
    public HighlightSeverity getUnresolvedReferenceSeverity() {
        Collection fromElements;
        ES6FromClause fromClause;
        PsiElement parent = this.getParent();
        if (parent instanceof ES6ImportExportDeclaration && (fromClause = ((ES6ImportExportDeclaration)parent).getFromClause()) != null && !(fromElements = fromClause.resolveReferencedElements()).isEmpty()) {
            HighlightSeverity highlightSeverity = HighlightSeverity.WEAK_WARNING;
            if (highlightSeverity == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportExportSpecifierBase", "getUnresolvedReferenceSeverity"));
            }
            return highlightSeverity;
        }
        HighlightSeverity highlightSeverity = HighlightSeverity.INFORMATION;
        if (highlightSeverity == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportExportSpecifierBase", "getUnresolvedReferenceSeverity"));
        }
        return highlightSeverity;
    }
}

