/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.refactoring;

import com.intellij.lang.ImportOptimizer;
import com.intellij.lang.LanguageImportStatements;
import com.intellij.lang.ecmascript6.psi.ES6ExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ExportedDefaultBinding;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclarationPart;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.ecmascript6.psi.impl.ES6CreateImportUtil;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.ecmascript6.refactoring.ES6ModuleMemberInfo;
import com.intellij.lang.ecmascript6.refactoring.ES6ReferenceExpressionsInfo;
import com.intellij.lang.ecmascript6.resolve.ES6ImportHandler;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.imports.ES6ImportOptimizer;
import com.intellij.lang.javascript.inspections.FileHeaderKeeper;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.lang.javascript.refactoring.introduce.BasicIntroducedEntityInfoProvider;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.ui.UsageViewDescriptorAdapter;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6MoveModuleMembersProcessor
extends BaseRefactoringProcessor {
    @NotNull
    private final Collection<JSQualifiedNamedElement> mySourceElements;
    @NotNull
    private final PsiElement myToModule;
    @NotNull
    private final PsiElement mySourceModule;
    @Nullable
    private final Consumer<Collection<JSQualifiedNamedElement>> myCallback;

    public ES6MoveModuleMembersProcessor(Project project, @NotNull Collection<JSQualifiedNamedElement> elements, @NotNull PsiElement toModule, @NotNull PsiElement fromModule, @Nullable Consumer<Collection<JSQualifiedNamedElement>> callbackForResults) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/lang/ecmascript6/refactoring/ES6MoveModuleMembersProcessor", "<init>"));
        }
        if (toModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toModule", "com/intellij/lang/ecmascript6/refactoring/ES6MoveModuleMembersProcessor", "<init>"));
        }
        if (fromModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromModule", "com/intellij/lang/ecmascript6/refactoring/ES6MoveModuleMembersProcessor", "<init>"));
        }
        super(project);
        this.mySourceElements = elements;
        this.mySourceModule = fromModule;
        this.myToModule = toModule;
        this.myCallback = callbackForResults;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/lang/ecmascript6/refactoring/ES6MoveModuleMembersProcessor", "createUsageViewDescriptor"));
        }
        UsageViewDescriptorAdapter usageViewDescriptorAdapter = new UsageViewDescriptorAdapter(){

            @NotNull
            public PsiElement[] getElements() {
                PsiElement[] psiElementArray = ES6MoveModuleMembersProcessor.this.mySourceElements.toArray(PsiElement.EMPTY_ARRAY);
                if (psiElementArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/refactoring/ES6MoveModuleMembersProcessor$1", "getElements"));
                }
                return psiElementArray;
            }

            public String getProcessedElementsHeader() {
                return ES6MoveModuleMembersProcessor.this.getCommandName();
            }
        };
        if (usageViewDescriptorAdapter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/refactoring/ES6MoveModuleMembersProcessor", "createUsageViewDescriptor"));
        }
        return usageViewDescriptorAdapter;
    }

    @NotNull
    protected UsageInfo[] findUsages() {
        ArrayList result = ContainerUtil.newArrayList();
        for (JSQualifiedNamedElement element : this.mySourceElements) {
            ReferencesSearch.search((PsiElement)element).forEach(reference -> {
                if (!this.isInMovedElement(reference.getElement())) {
                    result.add(new MoveRenameUsageInfo(reference, (PsiElement)element));
                }
            });
        }
        UsageInfo[] usageInfoArray = result.toArray(UsageInfo.EMPTY_ARRAY);
        if (usageInfoArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/refactoring/ES6MoveModuleMembersProcessor", "findUsages"));
        }
        return usageInfoArray;
    }

    private boolean isInMovedElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/ecmascript6/refactoring/ES6MoveModuleMembersProcessor", "isInMovedElement"));
        }
        for (PsiElement psiElement : this.mySourceElements) {
            if (!PsiTreeUtil.isAncestor((PsiElement)psiElement, (PsiElement)element, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    private void validateUnExportedElementsUsages(@NotNull MultiMap<PsiElement, UsageInfo> elementToUsages) {
        if (elementToUsages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToUsages", "com/intellij/lang/ecmascript6/refactoring/ES6MoveModuleMembersProcessor", "validateUnExportedElementsUsages"));
        }
        for (JSQualifiedNamedElement element : this.mySourceElements) {
            this.checkUsagesIfUnExportedMember(element, elementToUsages.get((Object)element));
        }
    }

    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/lang/ecmascript6/refactoring/ES6MoveModuleMembersProcessor", "performRefactoring"));
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        this.validateDestinationModuleDeclarations();
        Collection<ES6ReferenceExpressionsInfo> infos = this.validateAndGetReferenceExpressionInfos();
        MultiMap<PsiElement, UsageInfo> elementToUsages = ES6MoveModuleMembersProcessor.splitUsagesByElements(usages);
        this.validateUnExportedElementsUsages(elementToUsages);
        Collection<ES6ImportExportDeclaration> importOrExportTargetModule = this.getImportOrExportTargetModuleReferences();
        ArrayList<FormatFixer> postponedFormatters = new ArrayList<FormatFixer>();
        FileHeaderKeeper keeper = new FileHeaderKeeper(this.myToModule);
        keeper.saveStateAndCutHeader();
        List newElements = this.moveElementsAndUpdateUsages(elementToUsages, importOrExportTargetModule, postponedFormatters).stream().map(el -> this.createPointer((JSQualifiedNamedElement)el)).collect(Collectors.toList());
        this.addRequiredImportsToDestinationModule(infos);
        ES6MoveModuleMembersProcessor.optimizeImports(this.myToModule);
        keeper.returnHeaderForSavedState();
        this.deleteTargetElements();
        ES6MoveModuleMembersProcessor.optimizeImports(this.mySourceModule);
        JSRefactoringUtil.format(postponedFormatters);
        if (this.myCallback != null) {
            List result = newElements.stream().map(el -> (JSQualifiedNamedElement)el.getElement()).filter(el -> el != null).collect(Collectors.toList());
            this.myCallback.consume(result);
        }
    }

    @NotNull
    private SmartPsiElementPointer<JSQualifiedNamedElement> createPointer(@NotNull JSQualifiedNamedElement el) {
        if (el == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "el", "com/intellij/lang/ecmascript6/refactoring/ES6MoveModuleMembersProcessor", "createPointer"));
        }
        SmartPsiElementPointer smartPsiElementPointer = SmartPointerManager.getInstance((Project)this.myProject).createSmartPsiElementPointer((PsiElement)el);
        if (smartPsiElementPointer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/refactoring/ES6MoveModuleMembersProcessor", "createPointer"));
        }
        return smartPsiElementPointer;
    }

    private void validateDestinationModuleDeclarations() throws IncorrectOperationException {
        for (JSQualifiedNamedElement element : this.mySourceElements) {
            String name = element.getName();
            if (!StringUtil.isEmpty((String)name)) {
                Collection<PsiElement> elements;
                PsiElement resolved = JSStubBasedPsiTreeUtil.resolveLocally(name, this.myToModule, false);
                if (resolved == null || element.equals(resolved) || (resolved instanceof ES6ImportExportSpecifier ? (elements = JSResolveResult.toElements(((ES6ImportExportSpecifier)resolved).multiResolve(false))).contains(element) : resolved instanceof ES6ImportExportDeclarationPart && this.isFromPartEqualsSource((ES6ImportExportDeclarationPart)resolved))) continue;
                throw new IncorrectOperationException("Destination module contains a symbol with name \"" + name + "\"");
            }
            if (!element.isExportedWithDefault() || ES6PsiUtil.findDefaultExport(this.mySourceModule) == null) continue;
            throw new IncorrectOperationException("Destination module contains a default export");
        }
    }

    private boolean isFromPartEqualsSource(@NotNull ES6ImportExportDeclarationPart importPart) {
        Collection elements;
        ES6FromClause clause;
        if (importPart == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importPart", "com/intellij/lang/ecmascript6/refactoring/ES6MoveModuleMembersProcessor", "isFromPartEqualsSource"));
        }
        ES6ImportExportDeclaration declaration = importPart.getDeclaration();
        ES6FromClause eS6FromClause = clause = declaration == null ? null : declaration.getFromClause();
        return clause != null && (elements = clause.resolveReferencedElements()).contains(this.mySourceModule);
    }

    private void addRequiredImportsToDestinationModule(@NotNull Collection<ES6ReferenceExpressionsInfo> infos) {
        if (infos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "infos", "com/intellij/lang/ecmascript6/refactoring/ES6MoveModuleMembersProcessor", "addRequiredImportsToDestinationModule"));
        }
        for (ES6ReferenceExpressionsInfo info : infos) {
            Map<ES6ImportPsiUtil.CreateImportExportInfo, PsiElement> imports = info.getReferencedImports();
            for (Map.Entry<ES6ImportPsiUtil.CreateImportExportInfo, PsiElement> entry : imports.entrySet()) {
                JSElement assingmentElement;
                ES6ImportPsiUtil.CreateImportExportInfo createInfo = entry.getKey();
                PsiElement element = entry.getValue();
                PsiElement module = ES6PsiUtil.findExternalModule(element);
                if (this.myToModule.isEquivalentTo(module)) continue;
                if (element instanceof JSExportAssignment && (assingmentElement = ((JSExportAssignment)element).getStubSafeElement()) != null) {
                    element = assingmentElement;
                }
                String name = createInfo.getImportedName();
                if (element instanceof JSQualifiedNamedElement) {
                    ES6CreateImportUtil.insertImport(this.getDestinationPlace(), (JSQualifiedNamedElement)element, name);
                    continue;
                }
                if (name == null) continue;
                ES6ImportPsiUtil.insertJSImport(this.getDestinationPlace(), name, createInfo.getImportType(), element, null);
            }
            for (PsiElement element : info.getExportedLocalReferencedElements()) {
                if (this.isInMovedElement(element) || !(element instanceof JSQualifiedNamedElement)) continue;
                JSQualifiedNamedElement qualifiedNamedElement = (JSQualifiedNamedElement)element;
                ES6CreateImportUtil.insertImport(this.getDestinationPlace(), qualifiedNamedElement, qualifiedNamedElement.getName());
            }
        }
    }

    private static void optimizeImports(@NotNull PsiElement toOptimize) {
        if (toOptimize == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toOptimize", "com/intellij/lang/ecmascript6/refactoring/ES6MoveModuleMembersProcessor", "optimizeImports"));
        }
        PsiFile file = toOptimize.getContainingFile();
        Set optimizers = LanguageImportStatements.INSTANCE.forFile(file);
        for (ImportOptimizer optimizer : optimizers) {
            if (!optimizer.supports(file)) continue;
            optimizer.processFile(file).run();
            return;
        }
        new ES6ImportOptimizer().processFile(file).run();
    }

    private List<JSQualifiedNamedElement> moveElementsAndUpdateUsages(@NotNull MultiMap<PsiElement, UsageInfo> elementToUsages, @NotNull Collection<ES6ImportExportDeclaration> importOrExportTargetModule, @NotNull List<FormatFixer> postponedFormatters) {
        if (elementToUsages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToUsages", "com/intellij/lang/ecmascript6/refactoring/ES6MoveModuleMembersProcessor", "moveElementsAndUpdateUsages"));
        }
        if (importOrExportTargetModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importOrExportTargetModule", "com/intellij/lang/ecmascript6/refactoring/ES6MoveModuleMembersProcessor", "moveElementsAndUpdateUsages"));
        }
        if (postponedFormatters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "postponedFormatters", "com/intellij/lang/ecmascript6/refactoring/ES6MoveModuleMembersProcessor", "moveElementsAndUpdateUsages"));
        }
        ArrayList newElements = ContainerUtil.newArrayList();
        PsiElement anchor = this.getInsertionAnchor(elementToUsages.values());
        for (JSQualifiedNamedElement member : this.mySourceElements) {
            RefactoringElementListener elementListener = this.getTransaction().getElementListener((PsiElement)member);
            Collection elementUsages = elementToUsages.get((Object)member);
            JSQualifiedNamedElement newMember = this.moveElement(member, importOrExportTargetModule, elementUsages, postponedFormatters, anchor);
            if (newMember != null) {
                newElements.add(newMember);
                anchor = ES6MoveModuleMembersProcessor.getPsiElementToMove(newMember);
            }
            elementListener.elementMoved((PsiElement)(newMember == null ? member : newMember));
        }
        return newElements;
    }

    @Nullable
    private PsiElement getInsertionAnchor(@NotNull Collection<? extends UsageInfo> elementUsages) {
        if (elementUsages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementUsages", "com/intellij/lang/ecmascript6/refactoring/ES6MoveModuleMembersProcessor", "getInsertionAnchor"));
        }
        PsiFile myToFile = this.myToModule.getContainingFile();
        List usagesStatements = elementUsages.stream().map(el -> {
            PsiFile file = el.getFile();
            if (!myToFile.isEquivalentTo((PsiElement)file)) {
                return null;
            }
            PsiReference reference = el.getReference();
            if (reference == null) {
                return null;
            }
            PsiElement element = reference.getElement();
            if (element == null || element instanceof ES6ImportExportSpecifier || element instanceof ES6ImportedBinding) {
                return null;
            }
            PsiElement parent = element;
            boolean matched = false;
            while (parent != null) {
                PsiElement nextParent = parent.getParent();
                if (this.myToModule.isEquivalentTo(nextParent)) {
                    matched = true;
                    break;
                }
                parent = nextParent;
            }
            return matched ? parent : null;
        }).filter(el -> el != null).sorted((el, el2) -> Comparing.compare((int)el.getTextRange().getStartOffset(), (int)el2.getTextRange().getStartOffset())).collect(Collectors.toList());
        PsiElement[] children = this.myToModule.getChildren();
        if (usagesStatements.isEmpty()) {
            for (int i = children.length - 1; i >= 0; --i) {
                PsiElement child = children[i];
                if (!(child instanceof JSSourceElement)) continue;
                return child;
            }
        } else {
            PsiElement element = (PsiElement)usagesStatements.get(0);
            PsiElement prev = element.getPrevSibling();
            if (prev != null) {
                PsiElement candidate = element;
                PsiElement newCandidate = JSRefactoringUtil.skipWhitespaces(element, false);
                while (newCandidate instanceof PsiComment) {
                    candidate = newCandidate;
                    if ((newCandidate = newCandidate.getPrevSibling()) == null) continue;
                    newCandidate = JSRefactoringUtil.skipWhitespaces(newCandidate, false);
                }
                return candidate.getPrevSibling();
            }
            return element.getPrevSibling();
        }
        return null;
    }

    private void deleteTargetElements() {
        for (JSQualifiedNamedElement member : this.mySourceElements) {
            JSRefactoringUtil.deleteWithNoPostponedFormatting(ES6MoveModuleMembersProcessor.getPsiElementToMove(member));
        }
    }

    private JSQualifiedNamedElement moveElement(@NotNull JSQualifiedNamedElement oldMember, @NotNull Collection<ES6ImportExportDeclaration> importOrExportTargetModule, @NotNull Collection<UsageInfo> elementUsages, @NotNull List<FormatFixer> postponedFormatters, @Nullable PsiElement anchor) {
        if (oldMember == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldMember", "com/intellij/lang/ecmascript6/refactoring/ES6MoveModuleMembersProcessor", "moveElement"));
        }
        if (importOrExportTargetModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importOrExportTargetModule", "com/intellij/lang/ecmascript6/refactoring/ES6MoveModuleMembersProcessor", "moveElement"));
        }
        if (elementUsages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementUsages", "com/intellij/lang/ecmascript6/refactoring/ES6MoveModuleMembersProcessor", "moveElement"));
        }
        if (postponedFormatters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "postponedFormatters", "com/intellij/lang/ecmascript6/refactoring/ES6MoveModuleMembersProcessor", "moveElement"));
        }
        PsiElement psiElementToMove = ES6MoveModuleMembersProcessor.getPsiElementToMove(oldMember);
        PsiElement newElement = JSChangeUtil.doDoAddAfter(this.myToModule, psiElementToMove, anchor);
        postponedFormatters.add(FormatFixer.create(newElement, FormatFixer.Mode.Reformat));
        JSRefactoringUtil.handleDocCommentAndFormat(newElement, postponedFormatters);
        JSQualifiedNamedElement newMember = ES6ModuleMemberInfo.getMember(newElement);
        if (newMember == null) {
            return null;
        }
        ArrayList toRemoveElements = ContainerUtil.newArrayList();
        HashMap updatedModules = ContainerUtil.newHashMap();
        for (UsageInfo usage : elementUsages) {
            this.updateUsage(usage, newMember, toRemoveElements, updatedModules);
        }
        if (newMember.isExportedWithDefault()) {
            this.updateForDefaultExportedMember(importOrExportTargetModule, oldMember, newMember);
        }
        ES6MoveModuleMembersProcessor.updateExportAllDeclarations(importOrExportTargetModule, newMember);
        for (PsiElement element : toRemoveElements) {
            ES6MoveModuleMembersProcessor.deletePsiElement(element);
        }
        for (PsiElement module : updatedModules.keySet()) {
            ES6MoveModuleMembersProcessor.optimizeImports(module);
        }
        return newMember;
    }

    private void checkUsagesIfUnExportedMember(@NotNull JSQualifiedNamedElement oldMember, @NotNull Collection<UsageInfo> elementUsages) {
        if (oldMember == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldMember", "com/intellij/lang/ecmascript6/refactoring/ES6MoveModuleMembersProcessor", "checkUsagesIfUnExportedMember"));
        }
        if (elementUsages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementUsages", "com/intellij/lang/ecmascript6/refactoring/ES6MoveModuleMembersProcessor", "checkUsagesIfUnExportedMember"));
        }
        if (!ES6ImportHandler.isExportedWithNameOrDefault((PsiElement)oldMember) && elementUsages.size() > 0) {
            UsageInfo item = (UsageInfo)ContainerUtil.getFirstItem(elementUsages);
            assert (item != null);
            PsiFile file = item.getFile();
            if (file == null) {
                file = this.mySourceModule.getContainingFile();
            }
            throw new IncorrectOperationException("Local member \"" + oldMember.getName() + "\" has usages in " + file.getName());
        }
    }

    private static void updateExportAllDeclarations(@NotNull Collection<ES6ImportExportDeclaration> importOrExportTargetModule, @NotNull JSQualifiedNamedElement newMember) {
        if (importOrExportTargetModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importOrExportTargetModule", "com/intellij/lang/ecmascript6/refactoring/ES6MoveModuleMembersProcessor", "updateExportAllDeclarations"));
        }
        if (newMember == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newMember", "com/intellij/lang/ecmascript6/refactoring/ES6MoveModuleMembersProcessor", "updateExportAllDeclarations"));
        }
        boolean isDefault = newMember.isExportedWithDefault();
        if (isDefault) {
            return;
        }
        for (ES6ImportExportDeclaration declaration : importOrExportTargetModule) {
            String newName;
            if (!(declaration instanceof ES6ExportDeclaration) || !((ES6ExportDeclaration)declaration).isExportAll() || (newName = newMember.getName()) == null) continue;
            ES6CreateImportUtil.insertExport(newMember, ES6ImportPsiUtil.ImportExportType.SPECIFIER, newName, newName, (PsiElement)declaration);
        }
    }

    private void updateForDefaultExportedMember(@NotNull Collection<ES6ImportExportDeclaration> importOrExportTargetModule, @NotNull JSQualifiedNamedElement oldMember, @NotNull JSQualifiedNamedElement newMember) {
        if (importOrExportTargetModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importOrExportTargetModule", "com/intellij/lang/ecmascript6/refactoring/ES6MoveModuleMembersProcessor", "updateForDefaultExportedMember"));
        }
        if (oldMember == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldMember", "com/intellij/lang/ecmascript6/refactoring/ES6MoveModuleMembersProcessor", "updateForDefaultExportedMember"));
        }
        if (newMember == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newMember", "com/intellij/lang/ecmascript6/refactoring/ES6MoveModuleMembersProcessor", "updateForDefaultExportedMember"));
        }
        for (ES6ImportExportDeclaration declaration : importOrExportTargetModule) {
            String name;
            ES6ImportExportDeclarationPart defaultElement;
            ES6FromClause clause = declaration.getFromClause();
            if (clause == null || (defaultElement = ES6MoveModuleMembersProcessor.getDefault(declaration)) == null) continue;
            PsiElement declarationModule = ES6PsiUtil.findExternalModule((PsiElement)declaration);
            boolean fromDestinationModule = this.myToModule.isEquivalentTo(declarationModule);
            if (fromDestinationModule) {
                name = oldMember.getName();
                if (name == null || !name.equals(defaultElement.getDeclaredName())) {
                    ReferencesSearch.search((PsiElement)defaultElement, (SearchScope)GlobalSearchScope.fileScope((PsiFile)this.myToModule.getContainingFile())).forEach(el -> {
                        if (newMember == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newMember", "com/intellij/lang/ecmascript6/refactoring/ES6MoveModuleMembersProcessor", "lambda$updateForDefaultExportedMember$7"));
                        }
                        el.bindToElement((PsiElement)newMember);
                    });
                }
                ES6MoveModuleMembersProcessor.deletePsiElement((PsiElement)defaultElement);
                return;
            }
            if (ES6MoveModuleMembersProcessor.isSingleElementImportExportDeclaration(declaration)) {
                this.rebindFromClause(clause, this.mySourceModule);
                continue;
            }
            name = defaultElement.getDeclaredName();
            if (name == null) continue;
            if (declaration instanceof ES6ImportDeclaration) {
                ES6CreateImportUtil.insertImport((PsiElement)declaration, newMember, name);
            } else if (declaration instanceof ES6ExportDeclaration) {
                ES6ImportPsiUtil.ImportExportType importExportType = defaultElement instanceof ES6ImportedBinding ? ES6ImportPsiUtil.ImportExportType.DEFAULT : ES6ImportPsiUtil.ImportExportType.SPECIFIER;
                ES6CreateImportUtil.insertExport(newMember, importExportType, name, "default", (PsiElement)declaration);
            }
            ES6MoveModuleMembersProcessor.deletePsiElement((PsiElement)defaultElement);
        }
    }

    private static boolean isSingleElementImportExportDeclaration(@NotNull ES6ImportExportDeclaration importExportDeclaration) {
        if (importExportDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importExportDeclaration", "com/intellij/lang/ecmascript6/refactoring/ES6MoveModuleMembersProcessor", "isSingleElementImportExportDeclaration"));
        }
        if (importExportDeclaration instanceof ES6ImportDeclaration) {
            ES6ImportDeclaration declaration = (ES6ImportDeclaration)importExportDeclaration;
            ES6ImportSpecifier[] specifiers = declaration.getImportSpecifiers();
            ES6ImportedBinding[] bindings = declaration.getImportedBindings();
            return specifiers.length == 0 && bindings.length == 1 || specifiers.length == 1 && bindings.length == 0;
        }
        if (importExportDeclaration instanceof ES6ExportDeclaration) {
            ES6ExportDeclaration declaration = (ES6ExportDeclaration)importExportDeclaration;
            ES6ExportSpecifier[] specifiers = declaration.getExportSpecifiers();
            ES6ExportedDefaultBinding binding = declaration.getExportedDefaultBinding();
            return binding != null && specifiers.length == 0 || binding == null && specifiers.length == 1;
        }
        return false;
    }

    private static ES6ImportExportDeclarationPart getDefault(@NotNull ES6ImportExportDeclaration importExportDeclaration) {
        if (importExportDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importExportDeclaration", "com/intellij/lang/ecmascript6/refactoring/ES6MoveModuleMembersProcessor", "getDefault"));
        }
        if (importExportDeclaration instanceof ES6ImportDeclaration) {
            ES6ImportedBinding[] bindings;
            ES6ImportDeclaration declaration = (ES6ImportDeclaration)importExportDeclaration;
            for (ES6ImportedBinding binding : bindings = declaration.getImportedBindings()) {
                if (binding.isNamespaceImport()) continue;
                return binding;
            }
            return ES6MoveModuleMembersProcessor.getDefaultSpecifier((ES6ImportExportSpecifier[])declaration.getImportSpecifiers());
        }
        if (importExportDeclaration instanceof ES6ExportDeclaration) {
            ES6ExportDeclaration declaration = (ES6ExportDeclaration)importExportDeclaration;
            boolean all = declaration.isExportAll();
            if (all) {
                return null;
            }
            ES6ExportedDefaultBinding binding = declaration.getExportedDefaultBinding();
            if (binding != null) {
                return binding;
            }
            return ES6MoveModuleMembersProcessor.getDefaultSpecifier((ES6ImportExportSpecifier[])declaration.getExportSpecifiers());
        }
        return null;
    }

    @Nullable
    private static ES6ImportExportDeclarationPart getDefaultSpecifier(@NotNull ES6ImportExportSpecifier[] specifiers) {
        if (specifiers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "specifiers", "com/intellij/lang/ecmascript6/refactoring/ES6MoveModuleMembersProcessor", "getDefaultSpecifier"));
        }
        for (ES6ImportExportSpecifier specifier : specifiers) {
            String name = specifier.getReferenceName();
            if (!"default".equals(name)) continue;
            return specifier;
        }
        return null;
    }

    private void rebindFromClause(@NotNull ES6FromClause clause, @NotNull PsiElement refModule) {
        PsiReference[] references;
        if (clause == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clause", "com/intellij/lang/ecmascript6/refactoring/ES6MoveModuleMembersProcessor", "rebindFromClause"));
        }
        if (refModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refModule", "com/intellij/lang/ecmascript6/refactoring/ES6MoveModuleMembersProcessor", "rebindFromClause"));
        }
        for (PsiReference reference : references = clause.getReferences()) {
            if (!reference.isReferenceTo(refModule)) continue;
            reference.bindToElement(this.myToModule);
            break;
        }
    }

    private void updateUsage(@NotNull UsageInfo usage, @NotNull JSQualifiedNamedElement newMember, @NotNull List<PsiElement> toRemoveElements, @NotNull Map<PsiElement, String> updatedModules) {
        if (usage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usage", "com/intellij/lang/ecmascript6/refactoring/ES6MoveModuleMembersProcessor", "updateUsage"));
        }
        if (newMember == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newMember", "com/intellij/lang/ecmascript6/refactoring/ES6MoveModuleMembersProcessor", "updateUsage"));
        }
        if (toRemoveElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toRemoveElements", "com/intellij/lang/ecmascript6/refactoring/ES6MoveModuleMembersProcessor", "updateUsage"));
        }
        if (updatedModules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updatedModules", "com/intellij/lang/ecmascript6/refactoring/ES6MoveModuleMembersProcessor", "updateUsage"));
        }
        PsiReference reference = usage.getReference();
        if (reference instanceof JSReferenceExpression) {
            this.updateReferenceExpressionUsage((JSReferenceExpression)reference, newMember, toRemoveElements, updatedModules);
        } else if (reference instanceof ES6ImportSpecifier) {
            this.updateImportSpecifier((ES6ImportSpecifier)reference, newMember, toRemoveElements);
        } else if (reference instanceof ES6ExportSpecifier) {
            this.updateExportSpecifier((ES6ExportSpecifier)reference, newMember, toRemoveElements);
        }
    }

    private void updateExportSpecifier(@NotNull ES6ExportSpecifier specifier, JSQualifiedNamedElement newMember, @NotNull List<PsiElement> toRemoveElements) {
        if (specifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "specifier", "com/intellij/lang/ecmascript6/refactoring/ES6MoveModuleMembersProcessor", "updateExportSpecifier"));
        }
        if (toRemoveElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toRemoveElements", "com/intellij/lang/ecmascript6/refactoring/ES6MoveModuleMembersProcessor", "updateExportSpecifier"));
        }
        ES6ExportDeclaration declaration = specifier.getDeclaration();
        if (this.skipDeclaration((ES6ImportExportDeclaration)declaration)) {
            return;
        }
        String name = specifier.getDeclaredName();
        if (name == null) {
            return;
        }
        PsiElement declarationModule = ES6PsiUtil.findExternalModule((PsiElement)declaration);
        if (declaration.getFromClause() == null) {
            if (this.mySourceModule.isEquivalentTo(declarationModule)) {
                ES6CreateImportUtil.insertExportName(ES6ImportPsiUtil.ImportExportType.SPECIFIER, name, newMember.getName(), this.getDestinationPlace());
                toRemoveElements.add((PsiElement)specifier);
            }
            return;
        }
        boolean fromDestinationModule = this.myToModule.isEquivalentTo(declarationModule);
        if (fromDestinationModule) {
            toRemoveElements.add((PsiElement)specifier);
            return;
        }
        if (ES6MoveModuleMembersProcessor.isSingleElementImportExportDeclaration((ES6ImportExportDeclaration)declaration)) {
            this.rebindImportExportDeclaration((ES6ImportExportDeclaration)declaration);
        } else {
            ES6CreateImportUtil.insertExport(newMember, ES6ImportPsiUtil.ImportExportType.SPECIFIER, name, newMember.getName(), (PsiElement)declaration);
            toRemoveElements.add((PsiElement)specifier);
        }
    }

    @NotNull
    private PsiElement getDestinationPlace() {
        PsiElement child = this.myToModule.getFirstChild();
        PsiElement psiElement = child == null ? this.myToModule : child;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/refactoring/ES6MoveModuleMembersProcessor", "getDestinationPlace"));
        }
        return psiElement;
    }

    private void updateImportSpecifier(@NotNull ES6ImportSpecifier specifier, @NotNull JSQualifiedNamedElement newMember, @NotNull List<PsiElement> toRemoveElements) {
        if (specifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "specifier", "com/intellij/lang/ecmascript6/refactoring/ES6MoveModuleMembersProcessor", "updateImportSpecifier"));
        }
        if (newMember == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newMember", "com/intellij/lang/ecmascript6/refactoring/ES6MoveModuleMembersProcessor", "updateImportSpecifier"));
        }
        if (toRemoveElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toRemoveElements", "com/intellij/lang/ecmascript6/refactoring/ES6MoveModuleMembersProcessor", "updateImportSpecifier"));
        }
        ES6ImportDeclaration declaration = specifier.getDeclaration();
        if (this.skipDeclaration((ES6ImportExportDeclaration)declaration)) {
            return;
        }
        boolean fromDestinationModule = this.myToModule.isEquivalentTo(ES6PsiUtil.findExternalModule((PsiElement)declaration));
        if (fromDestinationModule) {
            toRemoveElements.add((PsiElement)specifier);
            return;
        }
        if (ES6MoveModuleMembersProcessor.isSingleElementImportExportDeclaration((ES6ImportExportDeclaration)declaration)) {
            this.rebindImportExportDeclaration((ES6ImportExportDeclaration)declaration);
        } else {
            ES6CreateImportUtil.insertImport((PsiElement)declaration, newMember, StringUtil.notNullize((String)newMember.getName()));
            toRemoveElements.add((PsiElement)specifier);
        }
    }

    private boolean skipDeclaration(@Nullable ES6ImportExportDeclaration declaration) {
        if (declaration == null) {
            return true;
        }
        ES6FromClause clause = declaration.getFromClause();
        if (clause == null) {
            return false;
        }
        Collection elements = clause.resolveReferencedElements();
        return elements.size() != 0 && !elements.contains(this.mySourceModule);
    }

    private void rebindImportExportDeclaration(@NotNull ES6ImportExportDeclaration declaration) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "com/intellij/lang/ecmascript6/refactoring/ES6MoveModuleMembersProcessor", "rebindImportExportDeclaration"));
        }
        ES6FromClause clause = declaration.getFromClause();
        if (clause == null) {
            return;
        }
        this.rebindFromClause(clause, this.mySourceModule);
    }

    private static void deletePsiElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/ecmascript6/refactoring/ES6MoveModuleMembersProcessor", "deletePsiElement"));
        }
        JSRefactoringUtil.deleteWithNoPostponedFormatting(element);
    }

    private void updateQualifiedReferenceExpressionUsage(@NotNull JSReferenceExpression reference, @NotNull JSQualifiedNamedElement newMember, @NotNull Map<PsiElement, String> updatedModules) {
        boolean hasImportFromPrevUsage;
        ResolveResult[] results;
        Collection<PsiElement> elements;
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/lang/ecmascript6/refactoring/ES6MoveModuleMembersProcessor", "updateQualifiedReferenceExpressionUsage"));
        }
        if (newMember == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newMember", "com/intellij/lang/ecmascript6/refactoring/ES6MoveModuleMembersProcessor", "updateQualifiedReferenceExpressionUsage"));
        }
        if (updatedModules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updatedModules", "com/intellij/lang/ecmascript6/refactoring/ES6MoveModuleMembersProcessor", "updateQualifiedReferenceExpressionUsage"));
        }
        PsiElement module = ES6PsiUtil.findExternalModule((PsiElement)reference);
        if (module == null) {
            ES6MoveModuleMembersProcessor.throwErrorUpdateUsage((PsiElement)reference);
        }
        if ((elements = JSResolveResult.toElements(results = reference.multiResolve(false))).isEmpty()) {
            return;
        }
        for (PsiElement element : elements) {
            if (this.isInMovedElement(element)) continue;
            ES6MoveModuleMembersProcessor.throwErrorUpdateUsage((PsiElement)reference);
        }
        String name = newMember.getName();
        if (name == null) {
            ES6MoveModuleMembersProcessor.throwErrorUpdateUsage((PsiElement)reference);
        }
        boolean isDestinationModule = this.myToModule.isEquivalentTo(module);
        String updatedName = updatedModules.get(module);
        boolean bl = hasImportFromPrevUsage = updatedName != null;
        if (!isDestinationModule) {
            if (updatedName == null) {
                PsiElement element = JSStubBasedPsiTreeUtil.resolveLocally(name, module, false);
                if (element != null) {
                    name = BasicIntroducedEntityInfoProvider.generateUniqueVariableName(name, module, ContainerUtil.newArrayList((Object[])new String[]{name}), false);
                }
            } else {
                name = updatedName;
            }
        }
        JSReferenceExpression newElement = JSChangeUtil.createExpressionPsiWithContext(name, module, JSReferenceExpression.class);
        JSExpression newExpression = reference.replace((JSExpression)newElement);
        if (!isDestinationModule && !hasImportFromPrevUsage) {
            ES6CreateImportUtil.insertImport((PsiElement)newExpression, newMember, name);
            updatedModules.put(module, name);
        }
    }

    private static void throwErrorUpdateUsage(@NotNull PsiElement reference) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/lang/ecmascript6/refactoring/ES6MoveModuleMembersProcessor", "throwErrorUpdateUsage"));
        }
        throw new IncorrectOperationException("Cannot update usage " + reference.getText() + " from " + reference.getContainingFile().getVirtualFile().getPath());
    }

    private void updateReferenceExpressionUsage(@NotNull JSReferenceExpression reference, @NotNull JSQualifiedNamedElement newMember, @NotNull List<PsiElement> toRemoveElements, @NotNull Map<PsiElement, String> updatedModules) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/lang/ecmascript6/refactoring/ES6MoveModuleMembersProcessor", "updateReferenceExpressionUsage"));
        }
        if (newMember == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newMember", "com/intellij/lang/ecmascript6/refactoring/ES6MoveModuleMembersProcessor", "updateReferenceExpressionUsage"));
        }
        if (toRemoveElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toRemoveElements", "com/intellij/lang/ecmascript6/refactoring/ES6MoveModuleMembersProcessor", "updateReferenceExpressionUsage"));
        }
        if (updatedModules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updatedModules", "com/intellij/lang/ecmascript6/refactoring/ES6MoveModuleMembersProcessor", "updateReferenceExpressionUsage"));
        }
        if (reference.getQualifier() != null) {
            this.updateQualifiedReferenceExpressionUsage(reference, newMember, updatedModules);
            return;
        }
        PsiElement module = ES6PsiUtil.findExternalModule((PsiElement)reference);
        if (module == null) {
            module = reference.getContainingFile();
        }
        if (this.mySourceModule.isEquivalentTo(module)) {
            String name = newMember.getName();
            if (name == null) {
                return;
            }
            PsiElement parent = reference.getParent();
            if (parent instanceof ES6ExportDefaultAssignment) {
                ES6CreateImportUtil.insertExportName(ES6ImportPsiUtil.ImportExportType.DEFAULT, name, name, this.getDestinationPlace());
                toRemoveElements.add(parent);
            } else {
                ES6CreateImportUtil.insertImport(this.mySourceModule.getFirstChild(), newMember, name);
            }
        }
    }

    @NotNull
    private static PsiElement getPsiElementToMove(@NotNull JSQualifiedNamedElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/ecmascript6/refactoring/ES6MoveModuleMembersProcessor", "getPsiElementToMove"));
        }
        PsiElement parent = element.getParent();
        if (parent instanceof ES6ExportDefaultAssignment || parent instanceof JSVarStatement) {
            PsiElement psiElement = parent;
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/refactoring/ES6MoveModuleMembersProcessor", "getPsiElementToMove"));
            }
            return psiElement;
        }
        JSQualifiedNamedElement jSQualifiedNamedElement = element;
        if (jSQualifiedNamedElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/refactoring/ES6MoveModuleMembersProcessor", "getPsiElementToMove"));
        }
        return jSQualifiedNamedElement;
    }

    @NotNull
    private Collection<ES6ReferenceExpressionsInfo> validateAndGetReferenceExpressionInfos() {
        HashSet infos = ContainerUtil.newHashSet();
        for (JSQualifiedNamedElement element : this.mySourceElements) {
            ES6ReferenceExpressionsInfo info = ES6ReferenceExpressionsInfo.getInfo((JSPsiElementBase)element);
            Collection<PsiElement> localReferencedElements = info.getLocalReferencedElements();
            for (PsiElement referencedElement : localReferencedElements) {
                if (this.isInMovedElement(referencedElement)) continue;
                String name = ResolveProcessor.getName(referencedElement);
                if (referencedElement instanceof ES6ImportSpecifier) {
                    throw new IncorrectOperationException("Selected member \"" + element.getName() + "\" references unresolved import \"" + name + "\"");
                }
                throw new IncorrectOperationException("Selected member \"" + element.getName() + "\" references local element \"" + name + "\"");
            }
            infos.add(info);
        }
        HashSet hashSet = infos;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/refactoring/ES6MoveModuleMembersProcessor", "validateAndGetReferenceExpressionInfos"));
        }
        return hashSet;
    }

    @NotNull
    private Collection<ES6ImportExportDeclaration> getImportOrExportTargetModuleReferences() {
        ArrayList result = ContainerUtil.newArrayList();
        ReferencesSearch.search((PsiElement)this.mySourceModule).forEach(el -> {
            PsiElement parent;
            PsiElement element = el.getElement();
            if (element instanceof ES6FromClause && (parent = element.getParent()) instanceof ES6ImportExportDeclaration) {
                result.add((ES6ImportExportDeclaration)parent);
            }
            return true;
        });
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/refactoring/ES6MoveModuleMembersProcessor", "getImportOrExportTargetModuleReferences"));
        }
        return arrayList;
    }

    @NotNull
    private static MultiMap<PsiElement, UsageInfo> splitUsagesByElements(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/lang/ecmascript6/refactoring/ES6MoveModuleMembersProcessor", "splitUsagesByElements"));
        }
        MultiMap result = MultiMap.create();
        for (UsageInfo usage : usages) {
            if (!(usage instanceof MoveRenameUsageInfo)) continue;
            result.putValue((Object)((MoveRenameUsageInfo)usage).getReferencedElement(), (Object)usage);
        }
        MultiMap multiMap = result;
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/refactoring/ES6MoveModuleMembersProcessor", "splitUsagesByElements"));
        }
        return multiMap;
    }

    @NotNull
    protected String getCommandName() {
        String string = JSBundle.message((String)"es6.move.module.members.refactoring.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/refactoring/ES6MoveModuleMembersProcessor", "getCommandName"));
        }
        return string;
    }
}

