/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.resolve;

import com.intellij.javascript.JSFileReference;
import com.intellij.javascript.JSModuleBaseReference;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSModuleReferenceContributor;
import com.intellij.lang.javascript.psi.types.JSRequireCallExpressionType;
import com.intellij.lang.typescript.psi.TypeScriptExternalModuleReference;
import com.intellij.lang.typescript.resolve.TypeScriptAugmentationUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.PsiCachedValueImpl;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSFileReferencesUtil {
    private static final Key<ParameterizedCachedValue<Collection<PsiElement>, PsiElement>> CACHE_KEY = Key.create((String)"TypeScript.External.Module.Resolve");
    private static final ParameterizedCachedValueProvider<Collection<PsiElement>, PsiElement> CACHED_VALUE_PROVIDER = e -> CachedValueProvider.Result.create(JSFileReferencesUtil.getModulesWithAugmentations(e), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
    private static final Key<ParameterizedCachedValue<Collection<PsiElement>, PsiElement>> CACHE_LIBRARY_MODULES_KEY = Key.create((String)"Library.External.Module.Resolve");
    private static final ParameterizedCachedValueProvider<Collection<PsiElement>, PsiElement> CACHED_LIBRARY_MODULES_VALUE_PROVIDER = new ParameterizedCachedValueProvider<Collection<PsiElement>, PsiElement>(){

        public CachedValueProvider.Result<Collection<PsiElement>> compute(PsiElement param) {
            Collection elements = JSFileReferencesUtil.getMainModules(param);
            ProjectFileIndex index = ProjectRootManager.getInstance((Project)param.getProject()).getFileIndex();
            VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)param);
            ArrayList deps = ContainerUtil.newArrayListWithCapacity((int)(elements.size() + 2));
            deps.add(file);
            deps.add(VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS);
            boolean allResolveResultsFromLibrary = true;
            for (PsiElement element : elements) {
                VirtualFile curr;
                if (element instanceof JSFile && (curr = PsiUtilCore.getVirtualFile((PsiElement)element)) != null && (index.isInLibrary(curr) || index.isExcluded(curr))) {
                    deps.add(curr);
                    continue;
                }
                allResolveResultsFromLibrary = false;
                break;
            }
            if (allResolveResultsFromLibrary) {
                return CachedValueProvider.Result.create((Object)elements, (Object[])deps.toArray());
            }
            return CachedValueProvider.Result.create((Object)elements, (Object[])new Object[]{JSTypeUtils.getTypeInvalidationDependency()});
        }
    };
    private static final Key<ParameterizedCachedValue<Map<String, CachedValue<Collection<PsiElement>>>, PsiFile>> FILE_MAP_KEY = Key.create((String)"js.file.references.map");
    private static final ParameterizedCachedValueProvider<Map<String, CachedValue<Collection<PsiElement>>>, PsiFile> FILE_MAP_PROVIDER = new ParameterizedCachedValueProvider<Map<String, CachedValue<Collection<PsiElement>>>, PsiFile>(){

        @NotNull
        public CachedValueProvider.Result<Map<String, CachedValue<Collection<PsiElement>>>> compute(PsiFile param) {
            CachedValueProvider.Result result = CachedValueProvider.Result.create((Object)ContainerUtil.newHashMap(), (Object[])new Object[]{param});
            if (result == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/resolve/JSFileReferencesUtil$2", "compute"));
            }
            return result;
        }
    };

    @NotNull
    public static Collection<PsiElement> resolveModuleReferences(@NotNull PsiElement moduleReference) {
        if (moduleReference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleReference", "com/intellij/lang/ecmascript6/resolve/JSFileReferencesUtil", "resolveModuleReferences"));
        }
        Collection collection = (Collection)CachedValuesManager.getManager((Project)moduleReference.getProject()).getParameterizedCachedValue((UserDataHolder)moduleReference, CACHE_KEY, CACHED_VALUE_PROVIDER, false, (Object)moduleReference);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/resolve/JSFileReferencesUtil", "resolveModuleReferences"));
        }
        return collection;
    }

    @NotNull
    public static Collection<PsiElement> resolveModuleReference(@NotNull PsiFile scope, @NotNull String refText) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/ecmascript6/resolve/JSFileReferencesUtil", "resolveModuleReference"));
        }
        if (refText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refText", "com/intellij/lang/ecmascript6/resolve/JSFileReferencesUtil", "resolveModuleReference"));
        }
        Map cache = (Map)CachedValuesManager.getManager((Project)scope.getProject()).getParameterizedCachedValue((UserDataHolder)scope, FILE_MAP_KEY, FILE_MAP_PROVIDER, false, (Object)scope);
        CachedValue value = (CachedValue)cache.get(refText);
        if (value == null) {
            value = new PsiCachedValueImpl(scope.getManager(), () -> {
                if (scope == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/ecmascript6/resolve/JSFileReferencesUtil", "lambda$resolveModuleReference$1"));
                }
                if (refText == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refText", "com/intellij/lang/ecmascript6/resolve/JSFileReferencesUtil", "lambda$resolveModuleReference$1"));
                }
                Collection<PsiElement> elements = JSFileReferencesUtil.calculateMainModules((PsiElement)scope, refText);
                return CachedValueProvider.Result.create(elements, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            });
            cache.put(refText, value);
        }
        Collection collection = (Collection)value.getValue();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/resolve/JSFileReferencesUtil", "resolveModuleReference"));
        }
        return collection;
    }

    @Nullable
    private static String getReferenceModuleText(@NotNull PsiElement element) {
        JSType exportsInnerAlias;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/ecmascript6/resolve/JSFileReferencesUtil", "getReferenceModuleText"));
        }
        if (element instanceof ES6FromClause) {
            return ((ES6FromClause)element).getReferenceText();
        }
        if (element instanceof TypeScriptExternalModuleReference) {
            return ((TypeScriptExternalModuleReference)element).getReferenceText();
        }
        if (element instanceof TypeScriptModule) {
            return ((TypeScriptModule)element).getName();
        }
        if (element instanceof JSFile && (exportsInnerAlias = ((JSFile)element).getExportsInnerAlias()) instanceof JSRequireCallExpressionType) {
            return ((JSRequireCallExpressionType)exportsInnerAlias).getReferencedModule();
        }
        return null;
    }

    public static PsiReference[] createImportExportFromClauseReferences(@NotNull PsiElement host, int offset, @NotNull String text, @Nullable PsiReferenceProvider provider) {
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/lang/ecmascript6/resolve/JSFileReferencesUtil", "createImportExportFromClauseReferences"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/lang/ecmascript6/resolve/JSFileReferencesUtil", "createImportExportFromClauseReferences"));
        }
        String unquoted = StringUtil.unquoteString((String)text);
        return JSModuleReferenceContributor.getReferences(unquoted, host, offset, provider, false);
    }

    private static Collection<PsiElement> getModulesWithAugmentations(@NotNull PsiElement moduleRef) {
        Collection<PsiElement> modules;
        if (moduleRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleRef", "com/intellij/lang/ecmascript6/resolve/JSFileReferencesUtil", "getModulesWithAugmentations"));
        }
        String referenceText = JSFileReferencesUtil.getReferenceModuleText(moduleRef);
        if (referenceText == null) {
            return Collections.emptyList();
        }
        Collection<PsiElement> collection = modules = JSFileReferencesUtil.isLibraryElement(moduleRef) ? JSFileReferencesUtil.getMainModulesFromCache(moduleRef) : JSFileReferencesUtil.getMainModules(moduleRef);
        if (moduleRef instanceof TypeScriptModule && ((TypeScriptModule)moduleRef).isAugmentation() || modules.isEmpty()) {
            return modules;
        }
        return JSFileReferencesUtil.mergeWithAugmentations(moduleRef, modules);
    }

    private static boolean isLibraryElement(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/ecmascript6/resolve/JSFileReferencesUtil", "isLibraryElement"));
        }
        if (DumbService.isDumb((Project)context.getProject())) {
            return false;
        }
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)context.getProject()).getFileIndex();
        VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)context);
        return file != null && index.isInLibrary(file);
    }

    private static Collection<PsiElement> getMainModulesFromCache(@NotNull PsiElement moduleRef) {
        if (moduleRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleRef", "com/intellij/lang/ecmascript6/resolve/JSFileReferencesUtil", "getMainModulesFromCache"));
        }
        return (Collection)CachedValuesManager.getManager((Project)moduleRef.getProject()).getParameterizedCachedValue((UserDataHolder)moduleRef, CACHE_LIBRARY_MODULES_KEY, CACHED_LIBRARY_MODULES_VALUE_PROVIDER, false, (Object)moduleRef);
    }

    private static Collection<PsiElement> getMainModules(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/ecmascript6/resolve/JSFileReferencesUtil", "getMainModules"));
        }
        String text = JSFileReferencesUtil.getReferenceModuleText(context);
        if (StringUtil.isEmpty((String)text)) {
            return ContainerUtil.emptyList();
        }
        return JSFileReferencesUtil.calculateMainModules(context, text);
    }

    private static Collection<PsiElement> calculateMainModules(@NotNull PsiElement context, @NotNull String text) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/ecmascript6/resolve/JSFileReferencesUtil", "calculateMainModules"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/lang/ecmascript6/resolve/JSFileReferencesUtil", "calculateMainModules"));
        }
        PsiReference[] references = JSFileReferencesUtil.createImportExportFromClauseReferences(context, 0, text, null);
        return JSFileReferencesUtil.getMostPriorityModules(context, references);
    }

    public static Collection<PsiElement> getMostPriorityModules(@NotNull PsiElement context, @NotNull PsiReference[] references) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/ecmascript6/resolve/JSFileReferencesUtil", "getMostPriorityModules"));
        }
        if (references == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "references", "com/intellij/lang/ecmascript6/resolve/JSFileReferencesUtil", "getMostPriorityModules"));
        }
        THashSet results = new THashSet();
        THashSet invalidResults = new THashSet();
        int maxWeight = Integer.MIN_VALUE;
        for (PsiReference reference : references) {
            Collection<PsiElement> currentResults;
            int weight = JSFileReferencesUtil.getReferenceWeight(reference);
            if (maxWeight > weight && results.size() > 0 || (currentResults = JSModuleReferenceContributor.resolveModuleReference(reference)).size() == 0) continue;
            String[] extensions = DialectDetector.isTypeScript(context) ? TypeScriptUtil.TYPESCRIPT_EXTENSIONS : JSFileReference.IMPLICIT_EXTENSIONS;
            for (PsiElement result : currentResults) {
                PsiElement current = JSFileReferencesUtil.getModuleForPsiElement(extensions, result);
                if (current == null) continue;
                boolean isValid = JSFileReferencesUtil.isValidModule(context, current);
                if (isValid) {
                    if (weight > maxWeight) {
                        results.clear();
                        maxWeight = weight;
                    }
                    results.add(current);
                    continue;
                }
                invalidResults.add(current);
            }
        }
        return results.isEmpty() ? invalidResults : results;
    }

    @Nullable
    public static PsiElement getModuleForPsiElement(@NotNull String[] extensions, @NotNull PsiElement result) {
        if (extensions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensions", "com/intellij/lang/ecmascript6/resolve/JSFileReferencesUtil", "getModuleForPsiElement"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/ecmascript6/resolve/JSFileReferencesUtil", "getModuleForPsiElement"));
        }
        PsiElement current = null;
        if (result instanceof PsiFileSystemItem && ((PsiFileSystemItem)result).isDirectory()) {
            PsiFile file = JSFileReferencesUtil.findIndexFile(extensions, (PsiFileSystemItem)result);
            if (file != null) {
                current = file;
            }
        } else {
            current = JSFileReferencesUtil.findModule(result);
        }
        return current;
    }

    private static boolean isValidModule(@NotNull PsiElement context, @NotNull PsiElement module) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/ecmascript6/resolve/JSFileReferencesUtil", "isValidModule"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/lang/ecmascript6/resolve/JSFileReferencesUtil", "isValidModule"));
        }
        if (DialectDetector.isTypeScript(context) && module instanceof TypeScriptModule) {
            return TypeScriptConfigService.Provider.isAccessible(context, module);
        }
        return true;
    }

    private static int getReferenceWeight(@NotNull PsiReference reference) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/lang/ecmascript6/resolve/JSFileReferencesUtil", "getReferenceWeight"));
        }
        if (reference instanceof JSModuleBaseReference) {
            return ((JSModuleBaseReference)reference).getWeight();
        }
        return 0;
    }

    private static PsiElement findModule(PsiElement result) {
        for (FrameworkIndexingHandler handler : (FrameworkIndexingHandler[])FrameworkIndexingHandler.EP_NAME.getExtensions()) {
            PsiElement processed = handler.findModule(result);
            if (processed == null) continue;
            return processed;
        }
        return result;
    }

    public static PsiFile findIndexFile(@NotNull String[] extensions, @NotNull PsiFileSystemItem result) {
        if (extensions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensions", "com/intellij/lang/ecmascript6/resolve/JSFileReferencesUtil", "findIndexFile"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/ecmascript6/resolve/JSFileReferencesUtil", "findIndexFile"));
        }
        VirtualFile virtualFile = result.getVirtualFile();
        if (virtualFile != null) {
            for (String ext : extensions) {
                VirtualFile child = virtualFile.findChild("index" + ext);
                if (child == null) continue;
                return result.getManager().findFile(child);
            }
        }
        return null;
    }

    @NotNull
    private static Collection<PsiElement> mergeWithAugmentations(PsiElement context, Collection<PsiElement> modules) {
        Collection<PsiElement> augmentations = TypeScriptAugmentationUtil.getAugmentations(context, modules);
        if (augmentations.isEmpty()) {
            Collection<PsiElement> collection = modules;
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/resolve/JSFileReferencesUtil", "mergeWithAugmentations"));
            }
            return collection;
        }
        ArrayList result = ContainerUtil.newArrayList(modules);
        result.addAll(augmentations);
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/resolve/JSFileReferencesUtil", "mergeWithAugmentations"));
        }
        return arrayList;
    }

    public static PsiReference[] calcImportExportFromClauseReferences(@NotNull PsiElement element, @Nullable PsiReferenceProvider provider) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/ecmascript6/resolve/JSFileReferencesUtil", "calcImportExportFromClauseReferences"));
        }
        Pair<String, PsiElement> pair = JSPsiImplUtils.getChildStringLiteralWithText(element);
        if (pair == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        PsiElement literalExpression = (PsiElement)pair.second;
        String quotedText = (String)pair.first;
        return JSFileReferencesUtil.createImportExportFromClauseReferences(element, literalExpression.getStartOffsetInParent() + 1, quotedText, provider);
    }

    @Nullable
    public static String getShortestPathInContexts(@Nullable VirtualFile dstVFile, @NotNull Collection<VirtualFile> contexts, boolean skipParent) {
        if (contexts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contexts", "com/intellij/lang/ecmascript6/resolve/JSFileReferencesUtil", "getShortestPathInContexts"));
        }
        if (dstVFile == null || contexts.size() == 0) {
            return null;
        }
        String path = null;
        String parentDirPath = null;
        for (VirtualFile contextFile : contexts) {
            if (!VfsUtilCore.isAncestor((VirtualFile)contextFile, (VirtualFile)dstVFile, (boolean)true)) continue;
            String candidate = VfsUtilCore.getRelativePath((VirtualFile)dstVFile, (VirtualFile)contextFile, (char)'/');
            if (skipParent && contextFile.equals(dstVFile.getParent())) {
                parentDirPath = candidate;
                continue;
            }
            path = path == null || path.length() > StringUtil.notNullize((String)candidate).length() && contextFile.equals(dstVFile.getParent()) ? candidate : path;
        }
        return path == null ? parentDirPath : path;
    }
}

