/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.extension.JsonSchemaFileProvider;
import com.jetbrains.jsonSchema.extension.JsonSchemaProviderFactory;
import com.jetbrains.jsonSchema.extension.SchemaType;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class EmbeddedJsonSchemaFileProvider
implements JsonSchemaFileProvider {
    private final VirtualFile mySchemaFile;
    private final String myFilename;
    @NotNull
    private final Set<String> myUserFilename;

    public EmbeddedJsonSchemaFileProvider(@NotNull String resourceName, @NotNull Class clazz, @NotNull String pathToFilename, String ... userFilename) {
        if (resourceName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceName", "com/intellij/lang/javascript/EmbeddedJsonSchemaFileProvider", "<init>"));
        }
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/lang/javascript/EmbeddedJsonSchemaFileProvider", "<init>"));
        }
        if (pathToFilename == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathToFilename", "com/intellij/lang/javascript/EmbeddedJsonSchemaFileProvider", "<init>"));
        }
        if (userFilename == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "userFilename", "com/intellij/lang/javascript/EmbeddedJsonSchemaFileProvider", "<init>"));
        }
        this.myFilename = resourceName;
        this.myUserFilename = userFilename.length == 0 ? Collections.singleton(resourceName) : ContainerUtil.set((Object[])userFilename);
        this.mySchemaFile = JsonSchemaProviderFactory.getResourceFile((Class)clazz, (String)(pathToFilename + this.myFilename));
    }

    public EmbeddedJsonSchemaFileProvider(@NotNull VirtualFile schemaFile, String ... userFilename) {
        if (schemaFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemaFile", "com/intellij/lang/javascript/EmbeddedJsonSchemaFileProvider", "<init>"));
        }
        if (userFilename == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "userFilename", "com/intellij/lang/javascript/EmbeddedJsonSchemaFileProvider", "<init>"));
        }
        this.mySchemaFile = schemaFile;
        this.myFilename = schemaFile.getName();
        this.myUserFilename = ContainerUtil.set((Object[])userFilename);
    }

    public boolean isAvailable(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/EmbeddedJsonSchemaFileProvider", "isAvailable"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/EmbeddedJsonSchemaFileProvider", "isAvailable"));
        }
        return this.myUserFilename.contains(file.getName());
    }

    @NotNull
    public String getName() {
        String string = this.myFilename;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/EmbeddedJsonSchemaFileProvider", "getName"));
        }
        return string;
    }

    public VirtualFile getSchemaFile() {
        return this.mySchemaFile;
    }

    public SchemaType getSchemaType() {
        return SchemaType.embeddedSchema;
    }
}

