/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.arrangement;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.arrangement.JSArrangementEntry;
import com.intellij.lang.javascript.arrangement.JSElementArrangementEntry;
import com.intellij.lang.javascript.arrangement.JSRearrangerBase;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.arrangement.ArrangementSettingsSerializer;
import com.intellij.psi.codeStyle.arrangement.DefaultArrangementSettingsSerializer;
import com.intellij.psi.codeStyle.arrangement.group.ArrangementGroupingRule;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementMatchRule;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementSettings;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokens;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6Rearranger
extends JSRearrangerBase {
    private final Set<ArrangementSettingsToken> SUPPORTED_TYPES = ContainerUtil.newLinkedHashSet((Object[])new ArrangementSettingsToken[]{StdArrangementTokens.EntryType.CONSTRUCTOR, StdArrangementTokens.EntryType.METHOD, StdArrangementTokens.EntryType.FIELD, StdArrangementTokens.EntryType.PROPERTY});
    private final Set<ArrangementSettingsToken> SUPPORTED_MODIFIERS;
    private final Set<ArrangementSettingsToken> myVisibilityModifiers;
    private final StdArrangementSettings DEFAULT_SETTINGS;
    private final DefaultArrangementSettingsSerializer SETTINGS_SERIALIZER;
    private final JSLanguageDialect dialect;

    public ES6Rearranger() {
        this(JavaScriptSupportLoader.ECMA_SCRIPT_6, ContainerUtil.newLinkedHashSet(), ContainerUtil.newLinkedHashSet((Object[])new ArrangementSettingsToken[]{StdArrangementTokens.Modifier.STATIC}));
    }

    public ES6Rearranger(JSLanguageDialect dialect, Set<ArrangementSettingsToken> visibilityModifiers, Set<ArrangementSettingsToken> additionalModifiers) {
        List<ArrangementGroupingRule> groupingRules = Collections.singletonList(new ArrangementGroupingRule(StdArrangementTokens.Grouping.GROUP_PROPERTY_FIELD_WITH_GETTER_SETTER));
        List<StdArrangementMatchRule> matchRules = ES6Rearranger.getDefaultMatchRules(visibilityModifiers);
        this.DEFAULT_SETTINGS = StdArrangementSettings.createByMatchRules(groupingRules, matchRules);
        this.SETTINGS_SERIALIZER = new DefaultArrangementSettingsSerializer(this.DEFAULT_SETTINGS);
        this.myVisibilityModifiers = visibilityModifiers;
        this.SUPPORTED_MODIFIERS = ContainerUtil.newLinkedHashSet(visibilityModifiers);
        this.SUPPORTED_MODIFIERS.addAll(additionalModifiers);
        this.dialect = dialect;
    }

    @Nullable
    public StdArrangementSettings getDefaultSettings() {
        return this.DEFAULT_SETTINGS;
    }

    @Override
    protected void postprocessClassMembers(@NotNull JSClass jsClass, @NotNull JSRearrangerBase.ClassArrangementInfo classArrangementInfo, @NotNull JSRearrangerBase.ArrangementInfo arrangementInfo) {
        if (jsClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsClass", "com/intellij/lang/javascript/arrangement/ES6Rearranger", "postprocessClassMembers"));
        }
        if (classArrangementInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classArrangementInfo", "com/intellij/lang/javascript/arrangement/ES6Rearranger", "postprocessClassMembers"));
        }
        if (arrangementInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arrangementInfo", "com/intellij/lang/javascript/arrangement/ES6Rearranger", "postprocessClassMembers"));
        }
        super.postprocessClassMembers(jsClass, classArrangementInfo, arrangementInfo);
        Map<JSVariable, JSElementArrangementEntry> fieldToEntry = classArrangementInfo.fieldToEntry;
        List fieldStatements = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)jsClass, JSVarStatement.class);
        ES6Rearranger.processDependantFields(fieldStatements, fieldToEntry, (Condition<JSField>)((Condition)field -> !ES6Rearranger.isStatic(field)), (Condition<JSExpression>)((Condition)qualifier -> qualifier instanceof JSThisExpression));
        ES6Rearranger.processDependantFields(fieldStatements, fieldToEntry, (Condition<JSField>)((Condition)ES6Rearranger::isStatic), (Condition<JSExpression>)((Condition)qualifier -> {
            if (jsClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsClass", "com/intellij/lang/javascript/arrangement/ES6Rearranger", "lambda$postprocessClassMembers$2"));
            }
            return qualifier instanceof JSThisExpression || qualifier instanceof JSReferenceExpression && JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceExpression)qualifier, jsClass.getName());
        }));
    }

    private static void processDependantFields(@NotNull List<JSVarStatement> fieldStatements, @NotNull Map<JSVariable, JSElementArrangementEntry> fieldToEntry, @NotNull Condition<JSField> fieldFilter, @NotNull Condition<JSExpression> isAcceptableQualifier) {
        if (fieldStatements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldStatements", "com/intellij/lang/javascript/arrangement/ES6Rearranger", "processDependantFields"));
        }
        if (fieldToEntry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldToEntry", "com/intellij/lang/javascript/arrangement/ES6Rearranger", "processDependantFields"));
        }
        if (fieldFilter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldFilter", "com/intellij/lang/javascript/arrangement/ES6Rearranger", "processDependantFields"));
        }
        if (isAcceptableQualifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isAcceptableQualifier", "com/intellij/lang/javascript/arrangement/ES6Rearranger", "processDependantFields"));
        }
        List filteredFields = ContainerUtil.mapNotNull(fieldStatements, fieldStatement -> {
            if (fieldFilter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldFilter", "com/intellij/lang/javascript/arrangement/ES6Rearranger", "lambda$processDependantFields$3"));
            }
            JSVariable variable = (JSVariable)ArrayUtil.getFirstElement((Object[])fieldStatement.getVariables());
            JSField field = variable instanceof JSField ? (JSField)variable : null;
            return field != null && fieldFilter.value((Object)field) ? variable : null;
        });
        Map fieldsByName = filteredFields.stream().collect(Collectors.toMap(NavigationItem::getName, Function.identity(), (var1, var2) -> var2));
        for (JSVariable field : fieldsByName.values()) {
            JSExpression initializer = JSUtils.unparenthesize(field.getInitializer());
            if (initializer == null || initializer instanceof JSFunction || initializer instanceof JSClass) continue;
            PsiTreeUtil.processElements((PsiElement)initializer, element -> {
                JSReferenceExpression referenceExpression;
                if (isAcceptableQualifier == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isAcceptableQualifier", "com/intellij/lang/javascript/arrangement/ES6Rearranger", "lambda$processDependantFields$5"));
                }
                if (fieldToEntry == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldToEntry", "com/intellij/lang/javascript/arrangement/ES6Rearranger", "lambda$processDependantFields$5"));
                }
                JSReferenceExpression jSReferenceExpression = referenceExpression = element instanceof JSReferenceExpression ? (JSReferenceExpression)element : null;
                if (referenceExpression != null && isAcceptableQualifier.value((Object)referenceExpression.getQualifier())) {
                    JSElementArrangementEntry dependencyEntry;
                    JSVariable accessedField = (JSVariable)fieldsByName.get(referenceExpression.getReferenceName());
                    JSElementArrangementEntry entry = (JSElementArrangementEntry)fieldToEntry.get(field);
                    if (field != accessedField && accessedField != null && entry != null && (dependencyEntry = (JSElementArrangementEntry)fieldToEntry.get(accessedField)) != null) {
                        entry.addDependency(dependencyEntry);
                    }
                }
                return true;
            });
        }
    }

    private static boolean isStatic(@NotNull JSField field) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/lang/javascript/arrangement/ES6Rearranger", "isStatic"));
        }
        return field.getAttributeList() != null && field.getAttributeList().hasModifier(JSAttributeList.ModifierType.STATIC);
    }

    @Override
    protected boolean isModifierEnabled(@NotNull ArrangementSettingsToken modifier, @NotNull ArrangementSettingsToken entryType, @NotNull Set<ArrangementSettingsToken> existingModifiers) {
        if (modifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifier", "com/intellij/lang/javascript/arrangement/ES6Rearranger", "isModifierEnabled"));
        }
        if (entryType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entryType", "com/intellij/lang/javascript/arrangement/ES6Rearranger", "isModifierEnabled"));
        }
        if (existingModifiers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "existingModifiers", "com/intellij/lang/javascript/arrangement/ES6Rearranger", "isModifierEnabled"));
        }
        return (entryType == StdArrangementTokens.EntryType.METHOD || entryType == StdArrangementTokens.EntryType.FIELD || entryType == StdArrangementTokens.EntryType.PROPERTY) && modifier == StdArrangementTokens.Modifier.STATIC;
    }

    public int getBlankLines(@NotNull CodeStyleSettings settings, @Nullable JSArrangementEntry parent, @Nullable JSArrangementEntry previous, @NotNull JSArrangementEntry target) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/javascript/arrangement/ES6Rearranger", "getBlankLines"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/lang/javascript/arrangement/ES6Rearranger", "getBlankLines"));
        }
        CommonCodeStyleSettings commonSettings = settings.getCommonSettings((Language)this.dialect);
        JSElementArrangementEntry targetElement = (JSElementArrangementEntry)ObjectUtils.tryCast((Object)target, JSElementArrangementEntry.class);
        JSElementArrangementEntry previousElement = (JSElementArrangementEntry)ObjectUtils.tryCast((Object)previous, JSElementArrangementEntry.class);
        JSElementArrangementEntry parentElement = (JSElementArrangementEntry)ObjectUtils.tryCast((Object)parent, JSElementArrangementEntry.class);
        if (targetElement != null && previousElement != null) {
            return Math.max(this.getBlankLines(commonSettings, targetElement.getType(), parentElement), this.getBlankLines(commonSettings, previousElement.getType(), parentElement));
        }
        return -1;
    }

    protected int getBlankLines(@NotNull CommonCodeStyleSettings commonSettings, @Nullable ArrangementSettingsToken type, @Nullable JSElementArrangementEntry parent) {
        if (commonSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commonSettings", "com/intellij/lang/javascript/arrangement/ES6Rearranger", "getBlankLines"));
        }
        return type == StdArrangementTokens.EntryType.FIELD ? commonSettings.BLANK_LINES_AROUND_FIELD : commonSettings.BLANK_LINES_AROUND_METHOD;
    }

    @NotNull
    public final ArrangementSettingsSerializer getSerializer() {
        DefaultArrangementSettingsSerializer defaultArrangementSettingsSerializer = this.SETTINGS_SERIALIZER;
        if (defaultArrangementSettingsSerializer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/arrangement/ES6Rearranger", "getSerializer"));
        }
        return defaultArrangementSettingsSerializer;
    }

    @Override
    @NotNull
    protected final Set<ArrangementSettingsToken> getSupportedTypes() {
        Set<ArrangementSettingsToken> set = this.SUPPORTED_TYPES;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/arrangement/ES6Rearranger", "getSupportedTypes"));
        }
        return set;
    }

    @Override
    @NotNull
    protected final Set<ArrangementSettingsToken> getVisibilityModifiers() {
        Set<ArrangementSettingsToken> set = this.myVisibilityModifiers;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/arrangement/ES6Rearranger", "getVisibilityModifiers"));
        }
        return set;
    }

    @Override
    @NotNull
    protected final Set<ArrangementSettingsToken> getSupportedModifiers() {
        Set<ArrangementSettingsToken> set = this.SUPPORTED_MODIFIERS;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/arrangement/ES6Rearranger", "getSupportedModifiers"));
        }
        return set;
    }

    @Override
    @NotNull
    protected Set<ArrangementSettingsToken> detectModifiers(@NotNull JSAttributeListOwner fieldOrMethod) {
        HashSet result;
        JSAttributeList attributes;
        block12: {
            block11: {
                if (fieldOrMethod == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldOrMethod", "com/intellij/lang/javascript/arrangement/ES6Rearranger", "detectModifiers"));
                }
                attributes = fieldOrMethod.getAttributeList();
                if (attributes == null) {
                    HashSet hashSet = ContainerUtil.newHashSet((Object[])new ArrangementSettingsToken[]{StdArrangementTokens.Modifier.PUBLIC});
                    if (hashSet == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/arrangement/ES6Rearranger", "detectModifiers"));
                    }
                    return hashSet;
                }
                result = ContainerUtil.newHashSet();
                JSAttributeList.AccessType accessType = attributes.getExplicitAccessType();
                if (accessType == null) break block11;
                switch (accessType) {
                    case PUBLIC: {
                        result.add(StdArrangementTokens.Modifier.PUBLIC);
                        break block12;
                    }
                    case PROTECTED: {
                        result.add(StdArrangementTokens.Modifier.PROTECTED);
                        break block12;
                    }
                    case PRIVATE: {
                        result.add(StdArrangementTokens.Modifier.PRIVATE);
                        break block12;
                    }
                    default: {
                        throw new RuntimeException("Unknown accessType " + accessType);
                    }
                }
            }
            result.add(StdArrangementTokens.Modifier.PUBLIC);
        }
        if (attributes.hasModifier(JSAttributeList.ModifierType.STATIC)) {
            result.add(StdArrangementTokens.Modifier.STATIC);
        }
        if (attributes.hasModifier(JSAttributeList.ModifierType.READONLY)) {
            result.add(StdArrangementTokens.Modifier.READONLY);
        }
        HashSet hashSet = result;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/arrangement/ES6Rearranger", "detectModifiers"));
        }
        return hashSet;
    }

    public List<StdArrangementMatchRule> getDefaultMatchRules() {
        return ES6Rearranger.getDefaultMatchRules(this.myVisibilityModifiers);
    }

    private static List<StdArrangementMatchRule> getDefaultMatchRules(Set<ArrangementSettingsToken> visibilityModifiers) {
        ArrayList matchRules = ContainerUtil.newArrayList();
        ES6Rearranger.addRules(matchRules, StdArrangementTokens.EntryType.FIELD, visibilityModifiers);
        ES6Rearranger.addRule(matchRules, StdArrangementTokens.EntryType.CONSTRUCTOR);
        ES6Rearranger.addRules(matchRules, StdArrangementTokens.EntryType.PROPERTY, visibilityModifiers);
        ES6Rearranger.addRules(matchRules, StdArrangementTokens.EntryType.METHOD, visibilityModifiers);
        return matchRules;
    }

    private static void addRules(@NotNull ArrayList<StdArrangementMatchRule> matchRules, @NotNull ArrangementSettingsToken type, @NotNull Set<ArrangementSettingsToken> visibilityModifiers) {
        if (matchRules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "matchRules", "com/intellij/lang/javascript/arrangement/ES6Rearranger", "addRules"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/arrangement/ES6Rearranger", "addRules"));
        }
        if (visibilityModifiers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visibilityModifiers", "com/intellij/lang/javascript/arrangement/ES6Rearranger", "addRules"));
        }
        if (visibilityModifiers.isEmpty()) {
            ES6Rearranger.addRule(matchRules, type, StdArrangementTokens.Modifier.STATIC);
            ES6Rearranger.addRule(matchRules, type);
        } else {
            for (ArrangementSettingsToken modifier : visibilityModifiers) {
                ES6Rearranger.addRule(matchRules, type, modifier, StdArrangementTokens.Modifier.STATIC);
            }
            for (ArrangementSettingsToken modifier : visibilityModifiers) {
                ES6Rearranger.addRule(matchRules, type, modifier);
            }
        }
    }
}

