/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.arrangement;

import com.intellij.lang.javascript.arrangement.JSArrangementEntry;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.codeStyle.arrangement.ArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.DefaultArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.ModifierAwareArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.NameAwareArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.TypeAwareArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSElementArrangementEntry
extends DefaultArrangementEntry
implements JSArrangementEntry,
TypeAwareArrangementEntry,
ModifierAwareArrangementEntry,
NameAwareArrangementEntry {
    private final String myName;
    private Set<ArrangementSettingsToken> myTypes;
    private Set<ArrangementSettingsToken> myModifiers;

    public JSElementArrangementEntry(@Nullable ArrangementEntry parent, @Nullable String name, @NotNull Set<ArrangementSettingsToken> types, @NotNull Set<ArrangementSettingsToken> modifiers, @NotNull TextRange range) {
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "com/intellij/lang/javascript/arrangement/JSElementArrangementEntry", "<init>"));
        }
        if (modifiers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifiers", "com/intellij/lang/javascript/arrangement/JSElementArrangementEntry", "<init>"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/lang/javascript/arrangement/JSElementArrangementEntry", "<init>"));
        }
        super(parent, range.getStartOffset(), range.getEndOffset(), true);
        this.myName = name;
        this.myTypes = types;
        this.myModifiers = modifiers;
    }

    @Nullable
    public String getName() {
        return this.myName;
    }

    public void setType(@NotNull ArrangementSettingsToken type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/arrangement/JSElementArrangementEntry", "setType"));
        }
        this.myTypes = ContainerUtil.newHashSet((Object[])new ArrangementSettingsToken[]{type});
    }

    @Nullable
    public ArrangementSettingsToken getType() {
        return (ArrangementSettingsToken)ContainerUtil.getFirstItem(this.myTypes);
    }

    @NotNull
    public Set<ArrangementSettingsToken> getTypes() {
        Set<ArrangementSettingsToken> set = this.myTypes;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/arrangement/JSElementArrangementEntry", "getTypes"));
        }
        return set;
    }

    public void setModifiers(@NotNull Set<ArrangementSettingsToken> modifiers) {
        if (modifiers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifiers", "com/intellij/lang/javascript/arrangement/JSElementArrangementEntry", "setModifiers"));
        }
        this.myModifiers = modifiers;
    }

    @NotNull
    public Set<ArrangementSettingsToken> getModifiers() {
        Set<ArrangementSettingsToken> set = this.myModifiers;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/arrangement/JSElementArrangementEntry", "getModifiers"));
        }
        return set;
    }

    public String toString() {
        return "JSArrangementEntry{myName='" + this.myName + '\'' + ", myType=" + this.myTypes + ", myModifiers=" + this.myModifiers + ", startOffset=" + this.getStartOffset() + ", endOffset=" + this.getEndOffset() + '}';
    }
}

