/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.arrangement;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.arrangement.ES6Rearranger;
import com.intellij.lang.javascript.arrangement.JSElementArrangementEntry;
import com.intellij.lang.javascript.arrangement.JSRearrangerBase;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokens;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptRearranger
extends ES6Rearranger {
    public TypeScriptRearranger() {
        super(JavaScriptSupportLoader.TYPESCRIPT, ContainerUtil.newHashSet((Object[])new ArrangementSettingsToken[]{StdArrangementTokens.Modifier.PUBLIC, StdArrangementTokens.Modifier.PROTECTED, StdArrangementTokens.Modifier.PRIVATE}), ContainerUtil.newLinkedHashSet((Object[])new ArrangementSettingsToken[]{StdArrangementTokens.Modifier.STATIC, StdArrangementTokens.Modifier.ABSTRACT, StdArrangementTokens.Modifier.READONLY}));
    }

    @Override
    @NotNull
    protected JSRearrangerBase.Visitor createVisitor(@NotNull JSRearrangerBase.ArrangementInfo arrangementInfo) {
        if (arrangementInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arrangementInfo", "com/intellij/lang/javascript/arrangement/TypeScriptRearranger", "createVisitor"));
        }
        MyVisitor myVisitor = new MyVisitor(arrangementInfo);
        if (myVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/arrangement/TypeScriptRearranger", "createVisitor"));
        }
        return myVisitor;
    }

    @Override
    protected boolean isModifierEnabled(@NotNull ArrangementSettingsToken modifier, @NotNull ArrangementSettingsToken entryType, @NotNull Set<ArrangementSettingsToken> existingModifiers) {
        if (modifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifier", "com/intellij/lang/javascript/arrangement/TypeScriptRearranger", "isModifierEnabled"));
        }
        if (entryType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entryType", "com/intellij/lang/javascript/arrangement/TypeScriptRearranger", "isModifierEnabled"));
        }
        if (existingModifiers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "existingModifiers", "com/intellij/lang/javascript/arrangement/TypeScriptRearranger", "isModifierEnabled"));
        }
        if (entryType == StdArrangementTokens.EntryType.CONSTRUCTOR) {
            return false;
        }
        if (modifier == StdArrangementTokens.Modifier.READONLY) {
            return entryType == StdArrangementTokens.EntryType.FIELD;
        }
        if (entryType == StdArrangementTokens.EntryType.METHOD || entryType == StdArrangementTokens.EntryType.FIELD || entryType == StdArrangementTokens.EntryType.PROPERTY) {
            return !(existingModifiers.contains(StdArrangementTokens.Modifier.STATIC) && modifier == StdArrangementTokens.Modifier.ABSTRACT || existingModifiers.contains(StdArrangementTokens.Modifier.ABSTRACT) && modifier == StdArrangementTokens.Modifier.STATIC || existingModifiers.contains(StdArrangementTokens.Modifier.PRIVATE) && modifier == StdArrangementTokens.Modifier.ABSTRACT) && (!existingModifiers.contains(StdArrangementTokens.Modifier.ABSTRACT) || modifier != StdArrangementTokens.Modifier.PRIVATE);
        }
        return false;
    }

    @Override
    protected int getBlankLines(@NotNull CommonCodeStyleSettings commonSettings, @Nullable ArrangementSettingsToken type, @Nullable JSElementArrangementEntry parent) {
        if (commonSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commonSettings", "com/intellij/lang/javascript/arrangement/TypeScriptRearranger", "getBlankLines"));
        }
        if (parent != null && parent.getType() == StdArrangementTokens.EntryType.INTERFACE) {
            return type == StdArrangementTokens.EntryType.FIELD ? commonSettings.BLANK_LINES_AROUND_FIELD_IN_INTERFACE : commonSettings.BLANK_LINES_AROUND_METHOD_IN_INTERFACE;
        }
        return super.getBlankLines(commonSettings, type, parent);
    }

    @NotNull
    private static PsiElement getEndElement(@NotNull JSElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/arrangement/TypeScriptRearranger", "getEndElement"));
        }
        ASTNode sibling = element.getNode().getTreeNext();
        if (sibling != null && (sibling.getElementType() == JSTokenTypes.COMMA || sibling.getElementType() == JSTokenTypes.SEMICOLON)) {
            PsiElement psiElement = sibling.getPsi();
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/arrangement/TypeScriptRearranger", "getEndElement"));
            }
            return psiElement;
        }
        JSElement jSElement = element;
        if (jSElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/arrangement/TypeScriptRearranger", "getEndElement"));
        }
        return jSElement;
    }

    private class MyVisitor
    extends JSRearrangerBase.Visitor {
        public MyVisitor(JSRearrangerBase.ArrangementInfo arrangementInfo) {
            super(arrangementInfo);
        }

        public void visitTypeScriptInterface(TypeScriptInterface typeScriptInterface) {
            JSElementArrangementEntry interfaceEntry = this.myArrangementInfo.addContainerEntry((PsiElement)typeScriptInterface, StdArrangementTokens.EntryType.INTERFACE);
            if (interfaceEntry == null) {
                return;
            }
            this.myArrangementInfo.processWithCurrentEntry(interfaceEntry, typeScriptInterface, anInterface -> {
                for (JSElement element : anInterface.getMembers()) {
                    ArrangementSettingsToken type;
                    PsiElement endElement = TypeScriptRearranger.getEndElement(element);
                    ArrangementSettingsToken arrangementSettingsToken = type = element instanceof TypeScriptPropertySignature ? StdArrangementTokens.EntryType.FIELD : StdArrangementTokens.EntryType.METHOD;
                    JSElementArrangementEntry entry = this.myArrangementInfo.addEntryFromRange((PsiElement)element, endElement, type, (Set<ArrangementSettingsToken>)ContainerUtil.newHashSet((Object[])new ArrangementSettingsToken[]{StdArrangementTokens.Modifier.PUBLIC}), element.getName());
                    if (entry == null) continue;
                    this.visitWithCurrentEntry(element, entry);
                }
            });
        }
    }
}

