/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.bower;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.json.psi.JsonFile;
import com.intellij.lang.javascript.bower.BowerCommandLineUtil;
import com.intellij.lang.javascript.bower.BowerPackageInfo;
import com.intellij.lang.javascript.bower.BowerSettings;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.webcore.util.JsonUtil;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BowerPackageUtil {
    private static final String BOWER_JSON = "bower.json";
    private static final Logger LOG = Logger.getInstance(BowerPackageUtil.class);

    @Nullable
    public static JsonFile getContainingBowerJsonFile(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/bower/BowerPackageUtil", "getContainingBowerJsonFile"));
        }
        PsiFile file = element.getContainingFile();
        if (file instanceof JsonFile && BOWER_JSON.equals(file.getName())) {
            return (JsonFile)file;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static BowerPackageInfo loadPackageInfo(@Nullable ProgressIndicator indicator, @NotNull BowerSettings settings, @NotNull String packageName) throws ExecutionException {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/javascript/bower/BowerPackageUtil", "loadPackageInfo"));
        }
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/intellij/lang/javascript/bower/BowerPackageUtil", "loadPackageInfo"));
        }
        ProcessOutput output = BowerCommandLineUtil.runBowerCommand(indicator, settings, "info", packageName, "--json");
        JsonReader reader = new JsonReader((Reader)new StringReader(output.getStdout()));
        reader.setLenient(false);
        JsonParser parser = new JsonParser();
        JsonElement rootElement = parser.parse(reader);
        if (!rootElement.isJsonObject()) {
            throw new RuntimeException("[loading bower package info] Top level element should be an object");
        }
        BowerPackageInfo bowerPackageInfo = BowerPackageUtil.parsePackageInfo(rootElement.getAsJsonObject());
        BowerPackageInfo bowerPackageInfo2 = bowerPackageInfo;
        if (bowerPackageInfo2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/bower/BowerPackageUtil", "loadPackageInfo"));
        }
        return bowerPackageInfo2;
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
            }
        }
    }

    private static BowerPackageInfo parsePackageInfo(@NotNull JsonObject root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/lang/javascript/bower/BowerPackageUtil", "parsePackageInfo"));
        }
        JsonArray versionsArray = JsonUtil.getChildAsArray((JsonObject)root, (String)"versions");
        List<String> versions = BowerPackageUtil.toVersions(versionsArray);
        JsonObject latestObject = JsonUtil.getChildAsObject((JsonObject)root, (String)"latest");
        return new BowerPackageInfo(versions, latestObject);
    }

    @NotNull
    private static List<String> toVersions(@Nullable JsonArray versionsArray) {
        if (versionsArray == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/bower/BowerPackageUtil", "toVersions"));
            }
            return list;
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (JsonElement element : versionsArray) {
            String version = JsonUtil.getString((JsonElement)element);
            if (version == null) continue;
            builder.add((Object)version);
        }
        ImmutableList immutableList = builder.build();
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/bower/BowerPackageUtil", "toVersions"));
        }
        return immutableList;
    }
}

