/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.bower.browsePackages;

import com.google.gson.stream.JsonWriter;
import com.intellij.lang.javascript.bower.BowerPackageBasicInfo;
import com.intellij.lang.javascript.bower.browsePackages.BowerPackageSearcher;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class BowerPopularPackagesGenerator {
    public static void main(String[] args) throws IOException {
        List<BowerPackageBasicInfo> infos = BowerPackageSearcher.doFindPackagesByPrefix(null, "", 30);
        File output = FileUtil.createTempFile((String)"bower-popular-packages-", (String)".json", (boolean)false);
        BowerPopularPackagesGenerator.writePackages(infos, output);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writePackages(@NotNull List<BowerPackageBasicInfo> names, @NotNull File outputFile) throws IOException {
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/intellij/lang/javascript/bower/browsePackages/BowerPopularPackagesGenerator", "writePackages"));
        }
        if (outputFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputFile", "com/intellij/lang/javascript/bower/browsePackages/BowerPopularPackagesGenerator", "writePackages"));
        }
        try (JsonWriter writer = new JsonWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), StandardCharsets.UTF_8));){
            writer.setIndent(" ");
            writer.beginArray();
            for (BowerPackageBasicInfo info : names) {
                writer.beginObject();
                writer.setIndent("");
                writer.name("name");
                writer.value(info.getName());
                if (info.getDescription() != null) {
                    writer.name("description");
                    writer.value(info.getDescription());
                }
                writer.endObject();
                writer.setIndent(" ");
            }
            writer.endArray();
        }
        System.out.println(names.size() + " packages are written to " + outputFile.getAbsolutePath());
    }
}

