/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.base;

import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.filters.UrlFilter;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.execution.ui.actions.CloseAction;
import com.intellij.javascript.nodejs.NodeConsoleAdditionalFilter;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskFetchException;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskListFetchFail;
import com.intellij.lang.javascript.buildTools.base.JsbtUtil;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsbtTaskListingFailUtil {
    private JsbtTaskListingFailUtil() {
    }

    public static void showError(@NotNull Project project, @NotNull JsbtTaskListFetchFail fetchFail) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/base/JsbtTaskListingFailUtil", "showError"));
        }
        if (fetchFail == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fetchFail", "com/intellij/lang/javascript/buildTools/base/JsbtTaskListingFailUtil", "showError"));
        }
        RunContentManager runContentManager = ExecutionManager.getInstance((Project)project).getContentManager();
        RunContentDescriptor descriptor2 = JsbtTaskListingFailUtil.findDescriptor(runContentManager, fetchFail);
        Executor executor = DefaultRunExecutor.getRunExecutorInstance();
        if (descriptor2 != null) {
            runContentManager.toFrontRunContent(executor, descriptor2);
        } else {
            descriptor2 = JsbtTaskListingFailUtil.createDescriptor(project, fetchFail, executor);
            runContentManager.showRunContent(executor, descriptor2);
            fetchFail.associateWith(descriptor2);
        }
    }

    public static void hideError(@NotNull Project project, @NotNull JsbtTaskFetchException e) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/base/JsbtTaskListingFailUtil", "hideError"));
        }
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/javascript/buildTools/base/JsbtTaskListingFailUtil", "hideError"));
        }
        JsbtTaskListFetchFail fetchFail = e.getFetchFail();
        if (fetchFail == null) {
            return;
        }
        RunContentManager runContentManager = ExecutionManager.getInstance((Project)project).getContentManager();
        RunContentDescriptor descriptor2 = JsbtTaskListingFailUtil.findDescriptor(runContentManager, fetchFail);
        Executor executor = DefaultRunExecutor.getRunExecutorInstance();
        if (descriptor2 != null) {
            runContentManager.removeRunContent(executor, descriptor2);
        }
    }

    @NotNull
    private static RunContentDescriptor createDescriptor(@NotNull Project project, @NotNull JsbtTaskListFetchFail fetchFail, @NotNull Executor executor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/base/JsbtTaskListingFailUtil", "createDescriptor"));
        }
        if (fetchFail == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fetchFail", "com/intellij/lang/javascript/buildTools/base/JsbtTaskListingFailUtil", "createDescriptor"));
        }
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/lang/javascript/buildTools/base/JsbtTaskListingFailUtil", "createDescriptor"));
        }
        ConsoleView consoleView = JsbtTaskListingFailUtil.createConsoleView(project);
        ProcessHandler processHandler = fetchFail.getProcessHandler();
        RunContentDescriptor descriptor2 = JsbtTaskListingFailUtil.createDescriptor(project, executor, consoleView, processHandler, fetchFail);
        if (processHandler != null && !processHandler.isProcessTerminated()) {
            consoleView.attachToProcess(processHandler);
            ProcessTerminatedListener.attach((ProcessHandler)processHandler);
        }
        JsbtTaskListingFailUtil.printFetchFail(project, consoleView, fetchFail);
        RunContentDescriptor runContentDescriptor = descriptor2;
        if (runContentDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/base/JsbtTaskListingFailUtil", "createDescriptor"));
        }
        return runContentDescriptor;
    }

    private static RunContentDescriptor createDescriptor(@NotNull Project project, @NotNull Executor executor, @NotNull ConsoleView consoleView, @Nullable ProcessHandler processHandler, @NotNull JsbtTaskListFetchFail fetchFail) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/base/JsbtTaskListingFailUtil", "createDescriptor"));
        }
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/lang/javascript/buildTools/base/JsbtTaskListingFailUtil", "createDescriptor"));
        }
        if (consoleView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consoleView", "com/intellij/lang/javascript/buildTools/base/JsbtTaskListingFailUtil", "createDescriptor"));
        }
        if (fetchFail == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fetchFail", "com/intellij/lang/javascript/buildTools/base/JsbtTaskListingFailUtil", "createDescriptor"));
        }
        DefaultActionGroup actions = new DefaultActionGroup();
        JPanel consoleComponent = JsbtTaskListingFailUtil.createConsoleComponent(consoleView, actions);
        AnAction stopAction = ActionManager.getInstance().getAction("Stop");
        if (stopAction != null) {
            actions.add(stopAction);
        }
        actions.addAll(consoleView.createConsoleActions());
        JsbtRunContentDescriptor descriptor2 = new JsbtRunContentDescriptor(consoleView, processHandler, consoleComponent, fetchFail);
        actions.add((AnAction)new CloseAction(executor, (RunContentDescriptor)descriptor2, project));
        return descriptor2;
    }

    @Nullable
    private static RunContentDescriptor findDescriptor(@NotNull RunContentManager runContentManager, @NotNull JsbtTaskListFetchFail fetchFail) {
        if (runContentManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runContentManager", "com/intellij/lang/javascript/buildTools/base/JsbtTaskListingFailUtil", "findDescriptor"));
        }
        if (fetchFail == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fetchFail", "com/intellij/lang/javascript/buildTools/base/JsbtTaskListingFailUtil", "findDescriptor"));
        }
        for (RunContentDescriptor descriptor2 : runContentManager.getAllDescriptors()) {
            if (!fetchFail.isAssociatedWith(descriptor2)) continue;
            return descriptor2;
        }
        return null;
    }

    private static void printFetchFail(@NotNull Project project, @NotNull ConsoleView view, @NotNull JsbtTaskListFetchFail fetchFail) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/base/JsbtTaskListingFailUtil", "printFetchFail"));
        }
        if (view == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/lang/javascript/buildTools/base/JsbtTaskListingFailUtil", "printFetchFail"));
        }
        if (fetchFail == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fetchFail", "com/intellij/lang/javascript/buildTools/base/JsbtTaskListingFailUtil", "printFetchFail"));
        }
        view.print("Failed to list " + fetchFail.getBuildToolName() + " tasks in ", ConsoleViewContentType.NORMAL_OUTPUT);
        VirtualFile file = fetchFail.getBuildfile();
        if (file.isValid()) {
            view.printHyperlink(JsbtUtil.getRelativePath(project, file), (HyperlinkInfo)new OpenFileHyperlinkInfo(project, file, -1, -1));
        } else {
            view.print(FileUtil.toSystemDependentName((String)fetchFail.getBuildfile().getPath()), ConsoleViewContentType.NORMAL_OUTPUT);
        }
        view.print(": ", ConsoleViewContentType.NORMAL_OUTPUT);
        view.print(fetchFail.getMessage() + "\n", ConsoleViewContentType.ERROR_OUTPUT);
        view.print(" * ", ConsoleViewContentType.NORMAL_OUTPUT);
        view.printHyperlink("Edit settings", JsbtTaskListingFailUtil.createEditSettingsHyperlink(fetchFail));
        view.print("\n\n", ConsoleViewContentType.ERROR_OUTPUT);
        String commandLine = fetchFail.getCommandLine().getCommandLineString();
        view.print("$ ", ConsoleViewContentType.SYSTEM_OUTPUT);
        int commandLineStartOffset = view.getContentSize();
        view.print(commandLine, ConsoleViewContentType.SYSTEM_OUTPUT);
        if (fetchFail.getCommandLineFoldedText() != null) {
            JsbtUtil.foldMatchingTextAtOffset(view, commandLineStartOffset, commandLine, fetchFail.getCommandLineFoldedText());
        }
        view.print("\n", ConsoleViewContentType.SYSTEM_OUTPUT);
        ProcessOutput output = fetchFail.getProcessOutput();
        if (output != null) {
            String stdout = output.getStdout();
            String stderr = output.getStderr();
            view.print(stdout, ConsoleViewContentType.NORMAL_OUTPUT);
            if (!(stdout.isEmpty() || stderr.isEmpty() || stdout.endsWith("\n"))) {
                view.print("\n", ConsoleViewContentType.NORMAL_OUTPUT);
            }
            view.print(stderr, ConsoleViewContentType.ERROR_OUTPUT);
            ProcessHandler processHandler = fetchFail.getProcessHandler();
            if (processHandler == null || processHandler.isProcessTerminated()) {
                view.print("\nProcess finished with exit code " + output.getExitCode() + "\n", ConsoleViewContentType.SYSTEM_OUTPUT);
            }
        }
    }

    @NotNull
    private static HyperlinkInfo createEditSettingsHyperlink(final @NotNull JsbtTaskListFetchFail fetchFail) {
        if (fetchFail == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fetchFail", "com/intellij/lang/javascript/buildTools/base/JsbtTaskListingFailUtil", "createEditSettingsHyperlink"));
        }
        HyperlinkInfo hyperlinkInfo = new HyperlinkInfo(){

            public void navigate(Project project) {
                fetchFail.getService().showTaskListingSettingsDialog(project, fetchFail.getBuildfile());
            }
        };
        if (hyperlinkInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/base/JsbtTaskListingFailUtil", "createEditSettingsHyperlink"));
        }
        return hyperlinkInfo;
    }

    @NotNull
    private static ConsoleView createConsoleView(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/base/JsbtTaskListingFailUtil", "createConsoleView"));
        }
        TextConsoleBuilder consoleBuilder = TextConsoleBuilderFactory.getInstance().createBuilder(project);
        consoleBuilder.filters(new Filter[]{new NodeConsoleAdditionalFilter(project, (String)null), new UrlFilter()});
        ConsoleView consoleView = consoleBuilder.getConsole();
        if (consoleView == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/base/JsbtTaskListingFailUtil", "createConsoleView"));
        }
        return consoleView;
    }

    @NotNull
    private static JPanel createConsoleComponent(@NotNull ConsoleView consoleView, @NotNull DefaultActionGroup actions) {
        if (consoleView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consoleView", "com/intellij/lang/javascript/buildTools/base/JsbtTaskListingFailUtil", "createConsoleComponent"));
        }
        if (actions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actions", "com/intellij/lang/javascript/buildTools/base/JsbtTaskListingFailUtil", "createConsoleComponent"));
        }
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)consoleView.getComponent(), "Center");
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("JsbtConsole", (ActionGroup)actions, false);
        panel.add((Component)actionToolbar.getComponent(), "West");
        JPanel jPanel = panel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/base/JsbtTaskListingFailUtil", "createConsoleComponent"));
        }
        return jPanel;
    }

    private static class JsbtRunContentDescriptor
    extends RunContentDescriptor {
        public JsbtRunContentDescriptor(@NotNull ConsoleView view, @Nullable ProcessHandler handler, @NotNull JPanel component, @NotNull JsbtTaskListFetchFail fetchFail) {
            if (view == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/lang/javascript/buildTools/base/JsbtTaskListingFailUtil$JsbtRunContentDescriptor", "<init>"));
            }
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/lang/javascript/buildTools/base/JsbtTaskListingFailUtil$JsbtRunContentDescriptor", "<init>"));
            }
            if (fetchFail == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fetchFail", "com/intellij/lang/javascript/buildTools/base/JsbtTaskListingFailUtil$JsbtRunContentDescriptor", "<init>"));
            }
            super((ExecutionConsole)view, handler, (JComponent)component, "Failed to list " + fetchFail.getBuildToolName() + " tasks", fetchFail.getIcon());
        }

        public boolean isContentReuseProhibited() {
            return true;
        }
    }
}

