/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.base.actions;

import com.intellij.lang.javascript.buildTools.base.JsbtTaskTreeView;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAware;
import icons.JavaScriptLanguageIcons;
import org.jetbrains.annotations.NotNull;

public class JsbtReloadTasksAction
extends AnAction
implements DumbAware {
    private final JsbtTaskTreeView myTaskTreeView;

    public JsbtReloadTasksAction(@NotNull JsbtTaskTreeView taskTreeView) {
        if (taskTreeView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskTreeView", "com/intellij/lang/javascript/buildTools/base/actions/JsbtReloadTasksAction", "<init>"));
        }
        super(JsbtReloadTasksAction.getText(taskTreeView), null, JavaScriptLanguageIcons.BuildTools.Refresh);
        this.getTemplatePresentation().setHoveredIcon(JavaScriptLanguageIcons.BuildTools.Refresh_hovered);
        this.setShortcutSet(KeymapUtil.getActiveKeymapShortcuts((String)"Synchronize"));
        this.myTaskTreeView = taskTreeView;
    }

    @NotNull
    private static String getText(@NotNull JsbtTaskTreeView taskTreeView) {
        if (taskTreeView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskTreeView", "com/intellij/lang/javascript/buildTools/base/actions/JsbtReloadTasksAction", "getText"));
        }
        String string = taskTreeView.getService().getReloadTasksActionName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/base/actions/JsbtReloadTasksAction", "getText"));
        }
        return string;
    }

    public void update(AnActionEvent e) {
        e.getPresentation().setEnabled(!this.myTaskTreeView.isReloading());
    }

    public void actionPerformed(AnActionEvent e) {
        if (!this.myTaskTreeView.isReloading()) {
            this.myTaskTreeView.reloadTasksForAllBuildfiles(false, false);
        }
    }
}

