/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.gulp;

import com.intellij.execution.configuration.EnvironmentVariablesComponent;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.javascript.nodejs.NodePackageVersion;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageDescriptor;
import com.intellij.lang.javascript.buildTools.gulp.rc.GulpRunSettings;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GulpUtil {
    public static final String DEFAULT_TASK_NAME = "default";
    private static final String GULP__PACKAGE_NAME = "gulp";
    private static final String GULP_CLI__PACKAGE_NAME = "gulp-cli";
    public static final NodePackageDescriptor GULP = new NodePackageDescriptor("gulp");
    private static final String STORAGE_GULP_PACKAGE_DIR_PATH = "js.buildTools.gulp.gulp_package_dir";
    private static final Logger LOG = Logger.getInstance(GulpUtil.class);
    private static final String TAG_NODE_INTERPRETER_REF = "node-interpreter";
    private static final String TAG_NODE_OPTIONS = "node-options";
    private static final String TAG_GULPFILE = "gulpfile";
    private static final String TAG_TASKS = "tasks";
    private static final String TAG_ARGUMENTS = "arguments";
    private static final String TAG_TASK = "task";
    private static final String TAG_PASS_PARENT_ENV_VARS = "pass-parent-envs";

    private GulpUtil() {
    }

    public static void writeToXml(@NotNull Element parent, @NotNull GulpRunSettings runSettings) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/lang/javascript/buildTools/gulp/GulpUtil", "writeToXml"));
        }
        if (runSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runSettings", "com/intellij/lang/javascript/buildTools/gulp/GulpUtil", "writeToXml"));
        }
        GulpUtil.addElement(parent, TAG_NODE_INTERPRETER_REF, runSettings.getInterpreterRef().getReferenceName());
        GulpUtil.addElement(parent, TAG_NODE_OPTIONS, runSettings.getNodeOptions());
        GulpUtil.addElement(parent, TAG_GULPFILE, runSettings.getGulpfileSystemIndependentPath());
        parent.addContent(GulpUtil.createTasksElement(runSettings.getTasks()));
        GulpUtil.addElement(parent, TAG_ARGUMENTS, runSettings.getArguments());
        EnvironmentVariablesData envData = runSettings.getEnvData();
        if (runSettings.isNewEnvFormat()) {
            envData.writeExternal(parent);
        } else {
            GulpUtil.addElement(parent, TAG_PASS_PARENT_ENV_VARS, Boolean.toString(envData.isPassParentEnvs()));
            EnvironmentVariablesComponent.writeExternal((Element)parent, (Map)envData.getEnvs());
        }
    }

    private static void addElement(@NotNull Element parent, @NotNull String tagName, @NotNull String textContent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/lang/javascript/buildTools/gulp/GulpUtil", "addElement"));
        }
        if (tagName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tagName", "com/intellij/lang/javascript/buildTools/gulp/GulpUtil", "addElement"));
        }
        if (textContent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textContent", "com/intellij/lang/javascript/buildTools/gulp/GulpUtil", "addElement"));
        }
        Element element = new Element(tagName);
        element.addContent(textContent);
        parent.addContent(element);
    }

    @NotNull
    private static Element createTasksElement(@NotNull List<String> tasks) {
        if (tasks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", TAG_TASKS, "com/intellij/lang/javascript/buildTools/gulp/GulpUtil", "createTasksElement"));
        }
        Element tasksElement = new Element(TAG_TASKS);
        for (String task : tasks) {
            Element taskElement = new Element(TAG_TASK);
            taskElement.addContent(task);
            tasksElement.addContent(taskElement);
        }
        Element element = tasksElement;
        if (element == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/GulpUtil", "createTasksElement"));
        }
        return element;
    }

    @NotNull
    public static GulpRunSettings.Builder readFromXml(@NotNull Element parent) {
        EnvironmentVariablesData envData;
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/lang/javascript/buildTools/gulp/GulpUtil", "readFromXml"));
        }
        GulpRunSettings.Builder builder = new GulpRunSettings.Builder();
        String interpreterRefName = GulpUtil.getTagValue(parent, TAG_NODE_INTERPRETER_REF);
        NodeJsInterpreterRef interpreterRef = NodeJsInterpreterRef.create(interpreterRefName);
        builder.setInterpreterRef(interpreterRef);
        builder.setNodeOptions(StringUtil.notNullize((String)GulpUtil.getTagValue(parent, TAG_NODE_OPTIONS)));
        builder.setGulpfilePath(FileUtil.toSystemDependentName((String)StringUtil.notNullize((String)GulpUtil.getTagValue(parent, TAG_GULPFILE))));
        builder.setTasks(GulpUtil.readTasks(parent.getChild(TAG_TASKS)));
        builder.setArguments(StringUtil.notNullize((String)GulpUtil.getTagValue(parent, TAG_ARGUMENTS)));
        String passParentEnvsStr = GulpUtil.getTagValue(parent, TAG_PASS_PARENT_ENV_VARS);
        if (passParentEnvsStr != null) {
            LinkedHashMap envVars = ContainerUtil.newLinkedHashMap();
            EnvironmentVariablesComponent.readExternal((Element)parent, (Map)envVars);
            envData = EnvironmentVariablesData.create((Map)envVars, (!Boolean.toString(false).equals(passParentEnvsStr) ? 1 : 0) != 0);
        } else {
            envData = EnvironmentVariablesData.readExternal((Element)parent);
        }
        builder.setNewEnvFormat(passParentEnvsStr == null);
        builder.setEnvData(envData);
        GulpRunSettings.Builder builder2 = builder;
        if (builder2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/GulpUtil", "readFromXml"));
        }
        return builder2;
    }

    @NotNull
    private static List<String> readTasks(@Nullable Element tasksElement) {
        if (tasksElement != null) {
            List children = tasksElement.getChildren(TAG_TASK);
            ArrayList tasks = ContainerUtil.newArrayList();
            for (Element child : children) {
                tasks.add(child.getText());
            }
            ArrayList arrayList = tasks;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/GulpUtil", "readTasks"));
            }
            return arrayList;
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/GulpUtil", "readTasks"));
        }
        return list;
    }

    @Nullable
    private static String getTagValue(@NotNull Element parent, @NotNull String tagName) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/lang/javascript/buildTools/gulp/GulpUtil", "getTagValue"));
        }
        if (tagName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tagName", "com/intellij/lang/javascript/buildTools/gulp/GulpUtil", "getTagValue"));
        }
        List children = parent.getChildren(tagName);
        if (children.size() == 0) {
            return null;
        }
        if (children.size() > 1) {
            LOG.warn("Ambiguous child: " + tagName);
        }
        Element first = (Element)children.get(0);
        return first.getText();
    }

    public static void checkConfiguration(@NotNull Project project, @NotNull NodePackage gulpPackage, @NotNull GulpRunSettings settings) throws RuntimeConfigurationError {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/gulp/GulpUtil", "checkConfiguration"));
        }
        if (gulpPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gulpPackage", "com/intellij/lang/javascript/buildTools/gulp/GulpUtil", "checkConfiguration"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/javascript/buildTools/gulp/GulpUtil", "checkConfiguration"));
        }
        GulpUtil.validateFile(settings.getGulpfilePath(), "Gulpfile is unspecified", "Gulpfile not found", null);
        NodeJsInterpreter interpreter = settings.getInterpreterRef().resolve(project);
        String interpreterErrorMessage = NodeJsLocalInterpreter.getErrorMessage(interpreter);
        if (interpreterErrorMessage != null) {
            throw new RuntimeConfigurationError(interpreterErrorMessage);
        }
        gulpPackage.validateForRunConfiguration(GULP.getPackageNames().get(0));
    }

    private static void validateFile(@NotNull String filePath, @NotNull String emptyPathMessage, @NotNull String fileNotFoundMessage, @Nullable String canNotExecuteFileMessage) throws RuntimeConfigurationError {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/lang/javascript/buildTools/gulp/GulpUtil", "validateFile"));
        }
        if (emptyPathMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "emptyPathMessage", "com/intellij/lang/javascript/buildTools/gulp/GulpUtil", "validateFile"));
        }
        if (fileNotFoundMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileNotFoundMessage", "com/intellij/lang/javascript/buildTools/gulp/GulpUtil", "validateFile"));
        }
        if (filePath.trim().isEmpty()) {
            throw new RuntimeConfigurationError(emptyPathMessage);
        }
        File file = new File(filePath);
        if (!file.isAbsolute() || !file.isFile()) {
            throw new RuntimeConfigurationError(fileNotFoundMessage);
        }
        if (canNotExecuteFileMessage != null && !file.canExecute()) {
            throw new RuntimeConfigurationError(canNotExecuteFileMessage);
        }
    }

    @Contract(value="null -> false", pure=true)
    public static boolean isGulpPackage(@Nullable NodePackageVersion nodePackageVersion) {
        return nodePackageVersion != null && GULP__PACKAGE_NAME.equals(nodePackageVersion.getPackageName());
    }

    @Contract(value="null -> false", pure=true)
    public static boolean isGulpCliPackage(@Nullable NodePackageVersion nodePackageVersion) {
        return nodePackageVersion != null && GULP_CLI__PACKAGE_NAME.equals(nodePackageVersion.getPackageName());
    }

    @NotNull
    public static NodePackage getGulpPackage(@NotNull Project project, @Nullable NodeJsInterpreter interpreter, @Nullable VirtualFile contextGruntfile) {
        NodePackage pkg;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/gulp/GulpUtil", "getGulpPackage"));
        }
        String packageDir = PropertiesComponent.getInstance((Project)project).getValue(STORAGE_GULP_PACKAGE_DIR_PATH);
        if (StringUtil.isEmpty((String)packageDir) && !(pkg = GULP.findPreferredPackage(project, interpreter, contextGruntfile)).isEmptyPath()) {
            GulpUtil.setGulpPackage(project, pkg);
            NodePackage nodePackage = pkg;
            if (nodePackage == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/GulpUtil", "getGulpPackage"));
            }
            return nodePackage;
        }
        NodePackage nodePackage = new NodePackage(StringUtil.notNullize((String)packageDir));
        if (nodePackage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/GulpUtil", "getGulpPackage"));
        }
        return nodePackage;
    }

    public static void setGulpPackage(@NotNull Project project, @NotNull NodePackage gulpPackage) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/gulp/GulpUtil", "setGulpPackage"));
        }
        if (gulpPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gulpPackage", "com/intellij/lang/javascript/buildTools/gulp/GulpUtil", "setGulpPackage"));
        }
        PropertiesComponent.getInstance((Project)project).setValue(STORAGE_GULP_PACKAGE_DIR_PATH, gulpPackage.getSystemIndependentPath());
    }

    @NotNull
    public static File getGulpBinFile(@NotNull NodePackage gulpPackage) {
        if (gulpPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gulpPackage", "com/intellij/lang/javascript/buildTools/gulp/GulpUtil", "getGulpBinFile"));
        }
        File file = new File(gulpPackage.getSystemDependentPath(), "bin" + File.separator + "gulp.js");
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/GulpUtil", "getGulpBinFile"));
        }
        return file;
    }
}

