/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.gulp.rc;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.TextConsoleBuilderImpl;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.javascript.nodejs.NodeCommandLineUtil;
import com.intellij.javascript.nodejs.NodeConsoleAdditionalFilter;
import com.intellij.javascript.nodejs.NodeStackTraceFilter;
import com.intellij.javascript.nodejs.debug.NodeLocalDebugRunProfileState;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.lang.javascript.buildTools.TypeScriptErrorConsoleFilter;
import com.intellij.lang.javascript.buildTools.base.JsbtUtil;
import com.intellij.lang.javascript.buildTools.gulp.GulpUtil;
import com.intellij.lang.javascript.buildTools.gulp.rc.GulpFilter;
import com.intellij.lang.javascript.buildTools.gulp.rc.GulpRunSettings;
import com.intellij.lang.javascript.buildTools.gulp.rc.GulpWatchTaskListener;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.webcore.util.CommandLineUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GulpRunProfileState
implements RunProfileState,
NodeLocalDebugRunProfileState {
    private final ExecutionEnvironment myEnvironment;
    private final GulpRunSettings myRunSettings;
    private final NodePackage myGulpPackage;

    public GulpRunProfileState(@NotNull ExecutionEnvironment environment, @NotNull GulpRunSettings runSettings, @NotNull NodePackage gulpPackage) {
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/intellij/lang/javascript/buildTools/gulp/rc/GulpRunProfileState", "<init>"));
        }
        if (runSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runSettings", "com/intellij/lang/javascript/buildTools/gulp/rc/GulpRunProfileState", "<init>"));
        }
        if (gulpPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gulpPackage", "com/intellij/lang/javascript/buildTools/gulp/rc/GulpRunProfileState", "<init>"));
        }
        this.myEnvironment = environment;
        this.myRunSettings = runSettings;
        this.myGulpPackage = gulpPackage;
    }

    @NotNull
    public GulpRunSettings getRunSettings() {
        GulpRunSettings gulpRunSettings = this.myRunSettings;
        if (gulpRunSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/rc/GulpRunProfileState", "getRunSettings"));
        }
        return gulpRunSettings;
    }

    @Override
    @NotNull
    public ExecutionResult execute(int debugPort) throws ExecutionException {
        ConsoleView console;
        NodeJsLocalInterpreter interpreter = this.myRunSettings.getInterpreterRef().resolveAsLocal(this.myEnvironment.getProject());
        GeneralCommandLine commandLine = this.createCommandLine(interpreter, debugPort);
        OSProcessHandler processHandler = NodeCommandLineUtil.createProcessHandler(commandLine, true);
        GulpRunProfileState.installWatchFsSynchronizer((ProcessHandler)processHandler);
        ProcessTerminatedListener.attach((ProcessHandler)processHandler);
        if (debugPort != -1) {
            console = null;
        } else {
            console = this.createConsole(commandLine.getWorkDirectory());
            console.attachToProcess((ProcessHandler)processHandler);
        }
        DefaultExecutionResult defaultExecutionResult = new DefaultExecutionResult((ExecutionConsole)console, (ProcessHandler)processHandler);
        if (defaultExecutionResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/rc/GulpRunProfileState", "execute"));
        }
        return defaultExecutionResult;
    }

    private static void installWatchFsSynchronizer(@NotNull ProcessHandler processHandler) {
        if (processHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processHandler", "com/intellij/lang/javascript/buildTools/gulp/rc/GulpRunProfileState", "installWatchFsSynchronizer"));
        }
        processHandler.addProcessListener((ProcessListener)new GulpWatchTaskListener());
    }

    @NotNull
    private ConsoleView createConsole(@Nullable File cwd) {
        TextConsoleBuilderImpl builder = new TextConsoleBuilderImpl(this.myEnvironment.getProject());
        builder.setUsePredefinedMessageFilter(false);
        builder.addFilter((Filter)new NodeStackTraceFilter(this.myEnvironment.getProject(), cwd));
        builder.addFilter((Filter)new NodeConsoleAdditionalFilter(this.myEnvironment.getProject(), cwd));
        builder.addFilter((Filter)new GulpFilter(this.myEnvironment.getProject()));
        builder.addFilter((Filter)new TypeScriptErrorConsoleFilter(this.myEnvironment.getProject(), cwd));
        ConsoleView consoleView = builder.getConsole();
        if (consoleView == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/rc/GulpRunProfileState", "createConsole"));
        }
        return consoleView;
    }

    @NotNull
    private GeneralCommandLine createCommandLine(@NotNull NodeJsLocalInterpreter interpreter, int debugPort) {
        if (interpreter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreter", "com/intellij/lang/javascript/buildTools/gulp/rc/GulpRunProfileState", "createCommandLine"));
        }
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.withCharset(CharsetToolkit.UTF8_CHARSET);
        this.myRunSettings.getEnvData().configureCommandLine(commandLine, true);
        CommandLineUtil.setWorkingDirectory((GeneralCommandLine)commandLine, (File)new File(this.myRunSettings.getGulpfilePath()).getParentFile(), (boolean)false);
        commandLine.setExePath(interpreter.getInterpreterSystemDependentPath());
        List nodeOptionList = ParametersListUtil.parse((String)this.myRunSettings.getNodeOptions().trim());
        NodeCommandLineUtil.addNodeOptionsForDebugging(commandLine, nodeOptionList, debugPort, true, interpreter, true);
        commandLine.addParameter(GulpUtil.getGulpBinFile(this.myGulpPackage).getAbsolutePath());
        commandLine.addParameter("--color");
        commandLine.addParameter("--gulpfile");
        commandLine.addParameter(this.myRunSettings.getGulpfilePath());
        commandLine.addParameters(this.myRunSettings.getTasks());
        String arguments = this.myRunSettings.getArguments().trim();
        if (StringUtil.isNotEmpty((String)arguments)) {
            commandLine.addParameters(ParametersList.parse((String)arguments));
        }
        GeneralCommandLine generalCommandLine = commandLine;
        if (generalCommandLine == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/rc/GulpRunProfileState", "createCommandLine"));
        }
        return generalCommandLine;
    }

    @Override
    public void foldCommandLine(@NotNull ConsoleView consoleView, @NotNull ProcessHandler processHandler) {
        if (consoleView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consoleView", "com/intellij/lang/javascript/buildTools/gulp/rc/GulpRunProfileState", "foldCommandLine"));
        }
        if (processHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processHandler", "com/intellij/lang/javascript/buildTools/gulp/rc/GulpRunProfileState", "foldCommandLine"));
        }
        BaseOSProcessHandler osProcessHandler = (BaseOSProcessHandler)ObjectUtils.tryCast((Object)processHandler, BaseOSProcessHandler.class);
        if (osProcessHandler != null) {
            ArrayList args = ContainerUtil.newArrayList((Object[])new String[]{"gulp"});
            args.addAll(this.myRunSettings.getTasks());
            String arguments = this.myRunSettings.getArguments().trim();
            if (StringUtil.isNotEmpty((String)arguments)) {
                args.addAll(ParametersListUtil.parse((String)arguments));
            }
            GulpRunProfileState.doFoldCommandLine(consoleView, osProcessHandler, ParametersListUtil.join((List)args));
        }
    }

    private static void doFoldCommandLine(final @NotNull ConsoleView consoleView, final @NotNull BaseOSProcessHandler processHandler, final @NotNull String foldedCommandLineText) {
        if (consoleView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consoleView", "com/intellij/lang/javascript/buildTools/gulp/rc/GulpRunProfileState", "doFoldCommandLine"));
        }
        if (processHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processHandler", "com/intellij/lang/javascript/buildTools/gulp/rc/GulpRunProfileState", "doFoldCommandLine"));
        }
        if (foldedCommandLineText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foldedCommandLineText", "com/intellij/lang/javascript/buildTools/gulp/rc/GulpRunProfileState", "doFoldCommandLine"));
        }
        final String commandLine = processHandler.getCommandLine();
        if (commandLine != null) {
            if (processHandler.isStartNotified()) {
                JsbtUtil.foldMatchingTextAtOffset(consoleView, 0, commandLine, foldedCommandLineText);
            } else {
                processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                    public void startNotified(ProcessEvent event) {
                        processHandler.removeProcessListener((ProcessListener)this);
                        JsbtUtil.foldMatchingTextAtOffset(consoleView, 0, commandLine, foldedCommandLineText);
                    }
                });
            }
        }
    }
}

