/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.npm.rc;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.javascript.nodejs.debug.NodeDebugRunConfiguration;
import com.intellij.lang.javascript.buildTools.npm.NpmScriptsService;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmCommand;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmRunConfigurationEditor;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmRunConfigurationUtil;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmRunProfileState;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmRunSettings;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.net.InetSocketAddress;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NpmRunConfiguration
extends LocatableConfigurationBase
implements NodeDebugRunConfiguration {
    private NpmRunSettings myRunSettings;

    public NpmRunConfiguration(@NotNull Project project, @NotNull ConfigurationFactory factory, @NotNull String name) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunConfiguration", "<init>"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunConfiguration", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunConfiguration", "<init>"));
        }
        super(project, factory, name);
        this.myRunSettings = NpmRunSettings.builder().build();
    }

    @NotNull
    public NpmRunSettings getRunSettings() {
        NpmRunSettings npmRunSettings = this.myRunSettings;
        if (npmRunSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunConfiguration", "getRunSettings"));
        }
        return npmRunSettings;
    }

    public void setRunSettings(@NotNull NpmRunSettings runSettings) {
        if (runSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runSettings", "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunConfiguration", "setRunSettings"));
        }
        this.myRunSettings = runSettings;
    }

    public void initializeFields() {
        List<VirtualFile> packageJsonFiles;
        NpmRunSettings runSettings = this.myRunSettings;
        if (runSettings.getPackageJsonSystemIndependentPath().isEmpty() && (packageJsonFiles = NpmScriptsService.getInstance().detectAllBuildfilesInContentRoots(this.getProject(), false)).size() == 1) {
            VirtualFile packageJson = packageJsonFiles.get(0);
            this.myRunSettings = runSettings.toBuilder().setPackageJsonPath(packageJson.getPath()).build();
        }
    }

    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        this.setRunSettings(NpmRunSettings.readExternal(element));
    }

    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        this.myRunSettings.writeExternal(element);
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        NpmRunConfigurationEditor npmRunConfigurationEditor = new NpmRunConfigurationEditor(this.getProject());
        if (npmRunConfigurationEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunConfiguration", "getConfigurationEditor"));
        }
        return npmRunConfigurationEditor;
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        NpmRunConfigurationUtil.check(this.getProject(), this.myRunSettings);
    }

    @Nullable
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) throws ExecutionException {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunConfiguration", "getState"));
        }
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunConfiguration", "getState"));
        }
        return new NpmRunProfileState(this.myRunSettings, environment);
    }

    @Nullable
    public String suggestedName() {
        NpmRunSettings runSettings = this.myRunSettings;
        StringBuilder builder = new StringBuilder();
        String args = runSettings.getArguments().trim();
        if (runSettings.getCommand() == NpmCommand.RUN_SCRIPT) {
            StringUtil.join(runSettings.getScriptNames(), (String)" ", (StringBuilder)builder);
            if (builder.length() == 0) {
                builder.append(runSettings.getCommand().getCliOption());
            }
        } else {
            builder.append(runSettings.getCommand().getCliOption());
        }
        if (!args.isEmpty()) {
            builder.append(" ").append(args);
        }
        return builder.toString();
    }

    @Override
    @Nullable
    public InetSocketAddress getDebugAddress() throws ExecutionException {
        return null;
    }
}

