/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.CompletionData;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.completion.JSInsertHandler;
import com.intellij.lang.javascript.completion.JSReferenceCompletionUtil;
import com.intellij.lang.javascript.completion.JSSmartCompletionVariantsHandler;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.typescript.completion.ES6ImportCompletionUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ProcessingContext;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JSReferenceCompletionProvider
extends CompletionProvider<CompletionParameters> {
    protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/lang/javascript/completion/JSReferenceCompletionProvider", "addCompletions"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/javascript/completion/JSReferenceCompletionProvider", "addCompletions"));
        }
        PsiElement parent = parameters.getPosition().getParent();
        assert (parent instanceof JSReferenceExpression);
        JSReferenceExpression referenceExpression = (JSReferenceExpression)parent;
        PsiFile containingFile = referenceExpression.getContainingFile();
        boolean ecma = containingFile.getLanguage() == JavaScriptSupportLoader.ECMA_SCRIPT_L4;
        Collection smartVariants = JSSmartCompletionVariantsHandler.getSmartVariants(referenceExpression);
        THashSet populatedSmartVariants = new THashSet();
        JSInsertHandler insertHandler = new JSInsertHandler();
        if (smartVariants != null) {
            for (Object variant : smartVariants) {
                LookupElement element = CompletionData.objectToLookupItem(variant);
                populatedSmartVariants.add(element.getLookupString());
                JSReferenceCompletionProvider.addVariant(insertHandler, element, result);
            }
            if (parameters.getCompletionType() == CompletionType.SMART) {
                return;
            }
        }
        Iterable variants = JSReferenceCompletionUtil.calcDefaultVariants(referenceExpression, containingFile, ecma, (Set<String>)populatedSmartVariants, result);
        JSReferenceCompletionProvider.addVariantsToImport(referenceExpression, variants, result);
    }

    private static void addVariantsToImport(@NotNull JSReferenceExpression referenceExpression, @NotNull Iterable<?> variants, @NotNull CompletionResultSet resultSet) {
        if (referenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceExpression", "com/intellij/lang/javascript/completion/JSReferenceCompletionProvider", "addVariantsToImport"));
        }
        if (variants == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variants", "com/intellij/lang/javascript/completion/JSReferenceCompletionProvider", "addVariantsToImport"));
        }
        if (resultSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultSet", "com/intellij/lang/javascript/completion/JSReferenceCompletionProvider", "addVariantsToImport"));
        }
        DialectOptionHolder holder = DialectDetector.dialectOfElement((PsiElement)referenceExpression);
        if (holder != null && holder.hasFeature(JSLanguageFeature.IMPORT_DECLARATIONS)) {
            PsiElement parent;
            JSExpression qualifier;
            JSExpression jSExpression = qualifier = referenceExpression instanceof JSReferenceExpressionImpl ? ((JSReferenceExpressionImpl)referenceExpression).getResolveQualifier() : referenceExpression.getQualifier();
            if (qualifier == null && !JSResolveUtil.isSelfReference(parent = referenceExpression.getParent(), (PsiElement)referenceExpression)) {
                ES6ImportCompletionUtil.addExportedVariants(referenceExpression, variants, resultSet);
            }
        }
    }

    public static void addVariant(JSInsertHandler<?> insertHandler, LookupElement element, CompletionResultSet result) {
        LookupItem lookupItem;
        if (element instanceof LookupItem && (lookupItem = (LookupItem)element).getInsertHandler() == null) {
            lookupItem.setInsertHandler(insertHandler);
            lookupItem.setTailType(TailType.UNKNOWN);
        }
        if (element != null) {
            result.addElement(element);
        }
    }
}

