/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ecmascript6;

import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.resolve.ES6QualifiedNameResolver;
import com.intellij.lang.javascript.psi.resolve.JSImportHandler;
import com.intellij.lang.javascript.psi.resolve.JSTypeResolveResult;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class ES6ImportHandlerImpl
extends JSImportHandler {
    private static final ES6ImportHandlerImpl INSTANCE = new ES6ImportHandlerImpl();

    protected ES6ImportHandlerImpl() {
    }

    public static ES6ImportHandlerImpl getInstance() {
        return INSTANCE;
    }

    @Override
    @NotNull
    public JSTypeResolveResult resolveName(@NotNull String type, @NotNull PsiElement context) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/ecmascript6/ES6ImportHandlerImpl", "resolveName"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/ecmascript6/ES6ImportHandlerImpl", "resolveName"));
        }
        if (!(context instanceof JSTypeDeclaration)) {
            JSTypeResolveResult jSTypeResolveResult = super.resolveName(type, context);
            if (jSTypeResolveResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/ES6ImportHandlerImpl", "resolveName"));
            }
            return jSTypeResolveResult;
        }
        Collection<PsiElement> elements = new ES6QualifiedNameResolver(context).resolveQualifiedName(type);
        if (elements.isEmpty()) {
            JSTypeResolveResult jSTypeResolveResult = super.resolveName(type, context);
            if (jSTypeResolveResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/ES6ImportHandlerImpl", "resolveName"));
            }
            return jSTypeResolveResult;
        }
        JSTypeResolveResult jSTypeResolveResult = new JSTypeResolveResult(elements);
        if (jSTypeResolveResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/ES6ImportHandlerImpl", "resolveName"));
        }
        return jSTypeResolveResult;
    }
}

