/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ecmascript6;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.ecmascript6.TypeScriptQualifiedNameResolver;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSImportHandler;
import com.intellij.lang.javascript.psi.resolve.JSTypeResolveResult;
import com.intellij.lang.javascript.psi.resolve.accessibility.TypeScriptModuleAccessibilityChecker;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class TypeScriptImportHandler
extends JSImportHandler {
    private static final TypeScriptImportHandler INSTANCE = new TypeScriptImportHandler();

    protected TypeScriptImportHandler() {
    }

    public static TypeScriptImportHandler getInstance() {
        return INSTANCE;
    }

    @Override
    public JSTypeResolveResult resolveMainElementName(@NotNull String type, @NotNull PsiElement context) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "resolveMainElementName"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "resolveMainElementName"));
        }
        return TypeScriptImportHandler.resolveNameImpl(type, context, true, false, (Set<Pair<JSQualifiedName, PsiElement>>)new THashSet());
    }

    @Override
    public JSTypeResolveResult resolveTypeName(@NotNull String type, @NotNull PsiElement context) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "resolveTypeName"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "resolveTypeName"));
        }
        return TypeScriptImportHandler.resolveNameImpl(type, context, true, true, (Set<Pair<JSQualifiedName, PsiElement>>)new THashSet());
    }

    @Override
    @NotNull
    public JSTypeResolveResult resolveName(@NotNull String type, @NotNull PsiElement source) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "resolveName"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "resolveName"));
        }
        JSTypeResolveResult jSTypeResolveResult = TypeScriptImportHandler.resolveNameImpl(type, source, false, true, (Set<Pair<JSQualifiedName, PsiElement>>)new THashSet());
        if (jSTypeResolveResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "resolveName"));
        }
        return jSTypeResolveResult;
    }

    @NotNull
    public static JSTypeResolveResult resolveNameImpl(@NotNull String type, @NotNull PsiElement sourceRaw, boolean typeContext, boolean includeAugmentations, @NotNull Set<Pair<JSQualifiedName, PsiElement>> visited) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "resolveNameImpl"));
        }
        if (sourceRaw == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceRaw", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "resolveNameImpl"));
        }
        if (visited == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visited", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "resolveNameImpl"));
        }
        PsiElement source = TypeScriptImportHandler.getSourceElement(sourceRaw);
        if (source == null) {
            source = sourceRaw;
        }
        if (!DialectDetector.isTypeScript(source)) {
            JSTypeResolveResult jSTypeResolveResult = new JSTypeResolveResult(type, null);
            if (jSTypeResolveResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "resolveNameImpl"));
            }
            return jSTypeResolveResult;
        }
        List elements = TypeScriptImportHandler.resolveTypeElements(type, source, visited, typeContext, includeAugmentations);
        PsiElement finalSource = source;
        if ((elements = ContainerUtil.filter(elements, element -> TypeScriptImportHandler.checkModulesAccess(finalSource, element) && TypeScriptConfigService.Provider.isAccessible(finalSource, element))).isEmpty()) {
            JSTypeResolveResult jSTypeResolveResult = new JSTypeResolveResult(type, null);
            if (jSTypeResolveResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "resolveNameImpl"));
            }
            return jSTypeResolveResult;
        }
        String qName = TypeScriptImportHandler.getQualifiedName(elements);
        JSTypeResolveResult jSTypeResolveResult = new JSTypeResolveResult(qName, elements);
        if (jSTypeResolveResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "resolveNameImpl"));
        }
        return jSTypeResolveResult;
    }

    @NotNull
    private static String getQualifiedName(@NotNull Collection<? extends PsiElement> elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "getQualifiedName"));
        }
        for (PsiElement psiElement : elements) {
            if (!(psiElement instanceof JSQualifiedNamedElement) || TypeScriptPsiUtil.isFromAugmentationModule(psiElement)) continue;
            String string = StringUtil.notNullize((String)((JSQualifiedNamedElement)psiElement).getQualifiedName());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "getQualifiedName"));
            }
            return string;
        }
        PsiElement element = (PsiElement)ContainerUtil.getFirstItem(elements);
        String string = element instanceof JSQualifiedNamedElement ? StringUtil.notNullize((String)((JSQualifiedNamedElement)element).getQualifiedName()) : "";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "getQualifiedName"));
        }
        return string;
    }

    private static PsiElement getSourceElement(@NotNull PsiElement sourceRaw) {
        if (sourceRaw == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceRaw", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "getSourceElement"));
        }
        PsiElement type = PsiTreeUtil.getContextOfType((PsiElement)sourceRaw, (boolean)false, (Class[])new Class[]{JSSourceElement.class});
        if (type instanceof TypeScriptType) {
            type = TypeScriptImportHandler.getSourceElement(sourceRaw.getParent());
        }
        if (type instanceof TypeScriptModule || type instanceof JSFile || type == null) {
            return type;
        }
        PsiElement parent = type.getContext();
        if (type instanceof JSBlockStatement) {
            if (parent instanceof JSFunction) {
                return parent;
            }
            return type;
        }
        if (parent != null && TypeScriptPsiUtil.isTopLevelContainer(parent)) {
            return parent;
        }
        return type;
    }

    @Override
    public String getQualifiedNameResolvedType(@NotNull String type, @NotNull PsiElement context) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "getQualifiedNameResolvedType"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "getQualifiedNameResolvedType"));
        }
        return new TypeScriptQualifiedNameResolver(context, true, true, (Set<Pair<JSQualifiedName, PsiElement>>)ContainerUtil.newTroveSet()).resolveName(type);
    }

    @NotNull
    private static Collection<PsiElement> resolveTypeElements(@NotNull String qName, @NotNull PsiElement source, @NotNull Set<Pair<JSQualifiedName, PsiElement>> visited, boolean typeContext, boolean includeAugmentations) {
        if (qName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qName", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "resolveTypeElements"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "resolveTypeElements"));
        }
        if (visited == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visited", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "resolveTypeElements"));
        }
        Collection<PsiElement> collection = new TypeScriptQualifiedNameResolver(source, typeContext, includeAugmentations, visited).resolveQualifiedName(qName);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "resolveTypeElements"));
        }
        return collection;
    }

    public static boolean checkModulesAccess(PsiElement source, PsiElement element) {
        return TypeScriptModuleAccessibilityChecker.INSTANCE.check(source, element) == null;
    }
}

