/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ecmascript6;

import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.ES6ImportedExportedDefaultBinding;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveProcessorBase;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptModuleDeclarationsProcessor
extends JSResolveProcessorBase {
    private final boolean myStrictTypeContext;
    private final boolean myAllowExport;
    private List<PsiElement> myResults;

    public TypeScriptModuleDeclarationsProcessor(@NotNull String name, boolean strictTypeContext, boolean allowExport) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/ecmascript6/TypeScriptModuleDeclarationsProcessor", "<init>"));
        }
        super(name);
        this.myStrictTypeContext = strictTypeContext;
        this.myAllowExport = allowExport;
    }

    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/ecmascript6/TypeScriptModuleDeclarationsProcessor", "execute"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/ecmascript6/TypeScriptModuleDeclarationsProcessor", "execute"));
        }
        if (!this.myName.equals(ResolveProcessor.getName(element))) {
            return true;
        }
        if (this.myStrictTypeContext && !(!(element instanceof ES6ImportExportSpecifier) ? TypeScriptPsiUtil.isNamedTypeContainerDefinition(element) : TypeScriptPsiUtil.referencesNamedTypeContainer((ES6ImportExportSpecifier)element))) {
            return true;
        }
        if (!ES6PsiUtil.isElementCanBeExported(element) && !TypeScriptModuleDeclarationsProcessor.isImportOrBinding(element, this.myAllowExport)) {
            return true;
        }
        if (this.myResults == null) {
            this.myResults = ContainerUtil.newSmartList();
        }
        this.myResults.add(element);
        return true;
    }

    private static boolean isImportOrBinding(PsiElement element, boolean allowExport) {
        if (allowExport) {
            return element instanceof ES6ImportExportSpecifierAlias || element instanceof ES6ImportExportSpecifier || element instanceof ES6ImportedExportedDefaultBinding;
        }
        return element instanceof ES6ImportSpecifierAlias || element instanceof ES6ImportSpecifier || element instanceof ES6ImportedBinding;
    }

    @Nullable
    public List<PsiElement> getResults() {
        return this.myResults;
    }
}

