/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ecmascript6;

import com.intellij.lang.ecmascript6.resolve.ES6ImportHandler;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.ecmascript6.TypeScriptImportHandler;
import com.intellij.lang.javascript.ecmascript6.TypeScriptImportHandlerContext;
import com.intellij.lang.javascript.ecmascript6.TypeScriptModuleDeclarationsProcessor;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptExportAssignment;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptGlobalModuleExportDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImplicitModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeMember;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.ES6QualifiedNameResolver;
import com.intellij.lang.javascript.psi.resolve.JSQualifiedNameResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.resolve.TypeScriptAugmentationUtil;
import com.intellij.lang.typescript.resolve.TypeScriptClassResolver;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptQualifiedNameResolver
extends JSQualifiedNameResolver {
    @NotNull
    private final PsiElement myContext;
    private final boolean myIsTypeContext;
    private final boolean myIncludeAugmentations;
    @NotNull
    private final Set<Pair<JSQualifiedName, PsiElement>> myVisited;

    public TypeScriptQualifiedNameResolver(@NotNull PsiElement context, boolean isTypeContext, boolean includeAugmentations, @NotNull Set<Pair<JSQualifiedName, PsiElement>> visited) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "<init>"));
        }
        if (visited == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visited", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "<init>"));
        }
        this.myContext = context;
        this.myIsTypeContext = isTypeContext;
        this.myIncludeAugmentations = includeAugmentations;
        this.myVisited = visited;
    }

    @Override
    @NotNull
    public Collection<PsiElement> resolveQualifiedName(@NotNull String qName) {
        if (qName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qName", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "resolveQualifiedName"));
        }
        JSQualifiedNameImpl qualifiedName = JSQualifiedNameImpl.fromQualifiedName(qName);
        final THashSet result = new THashSet();
        SubTypeVisitor visitor = new SubTypeVisitor();
        visitor.currentScope = this.myContext;
        visitor.parent = new TypeScriptHierarchyVisitor(){

            @Override
            public boolean accept(PsiElement qualifierResult) {
                result.add((Object)qualifierResult);
                return false;
            }

            @Override
            public boolean isDone() {
                return false;
            }
        };
        visitor.processQualifier(qualifiedName);
        THashSet tHashSet = result;
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "resolveQualifiedName"));
        }
        return tHashSet;
    }

    @Override
    @NotNull
    protected TypeScriptQualifiedNameResolver createNestedResolver(@NotNull PsiElement newContext) {
        if (newContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newContext", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "createNestedResolver"));
        }
        TypeScriptQualifiedNameResolver typeScriptQualifiedNameResolver = new TypeScriptQualifiedNameResolver(newContext, this.myIsTypeContext, this.myIncludeAugmentations, this.myVisited);
        if (typeScriptQualifiedNameResolver == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "createNestedResolver"));
        }
        return typeScriptQualifiedNameResolver;
    }

    public String resolveName(@NotNull String qName) {
        if (qName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qName", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "resolveName"));
        }
        final Ref resultValue = new Ref();
        SubTypeVisitor visitor = new SubTypeVisitor();
        visitor.currentScope = this.myContext;
        visitor.parent = new TypeScriptHierarchyVisitor(){

            @Override
            public boolean accept(PsiElement qualifierResult) {
                if (qualifierResult instanceof JSQualifiedNamedElement) {
                    resultValue.set((Object)((JSQualifiedNamedElement)qualifierResult));
                    return true;
                }
                return false;
            }

            @Override
            public boolean isDone() {
                return resultValue.get() != null;
            }
        };
        JSQualifiedNameImpl name = JSQualifiedNameImpl.fromQualifiedName(qName);
        visitor.processQualifier(name);
        return resultValue.get() == null ? "" : ((JSQualifiedNamedElement)resultValue.get()).getQualifiedName();
    }

    @NotNull
    private Collection<? extends PsiElement> getElements(@NotNull String name, @NotNull PsiElement source, @NotNull TypeScriptImportHandlerContext context) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "getElements"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "getElements"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "getElements"));
        }
        Collection<? extends PsiElement> collection = context.isLocalResolve() ? this.getLocalElements(name, source, context.getSource(), context.isQualifier()) : this.getGlobalElements(name, source, context);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "getElements"));
        }
        return collection;
    }

    @Override
    protected boolean isStrictTypeContext() {
        return this.myIsTypeContext;
    }

    @NotNull
    private Collection<? extends PsiElement> getGlobalElements(@NotNull String name, @NotNull PsiElement source, @NotNull TypeScriptImportHandlerContext context) {
        PsiElement parent;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "getGlobalElements"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "getGlobalElements"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "getGlobalElements"));
        }
        PsiElement moduleParent = ES6PsiUtil.getNonStrictExportScope(source);
        Collection<? extends PsiElement> localClasses = TypeScriptQualifiedNameResolver.getLocalClassesIfExists(name, source, context, moduleParent, parent = source.getParent());
        if (localClasses != null) {
            ArrayList elements = ContainerUtil.newArrayList(localClasses);
            this.addMergedAndGlobalElements(TypeScriptQualifiedNameResolver.getQualifiedNameForModule(name, moduleParent), source, context, elements, true);
            ArrayList arrayList = elements;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "getGlobalElements"));
            }
            return arrayList;
        }
        boolean isParentExternalFileModule = TypeScriptQualifiedNameResolver.isExternalFileModule(moduleParent);
        boolean isModule = moduleParent instanceof TypeScriptModule || isParentExternalFileModule;
        TypeScriptModuleDeclarationsProcessor processor = ES6QualifiedNameResolver.createProcessor(name, this.myIsTypeContext, false);
        PsiElement realPlace = TypeScriptQualifiedNameResolver.getRealSource(source, context);
        LinkedHashSet result = ContainerUtil.newLinkedHashSet();
        PsiElement module = moduleParent;
        while (module != null) {
            if (!(module instanceof JSElement)) {
                LinkedHashSet linkedHashSet = result;
                if (linkedHashSet == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "getGlobalElements"));
                }
                return linkedHashSet;
            }
            TypeScriptQualifiedNameResolver.processES6DeclarationsInScope((JSElement)module, processor, ResolveState.initial(), moduleParent, realPlace, !context.isQualifier());
            List<PsiElement> possibleResults = processor.getResults();
            if (possibleResults != null) {
                if (isParentExternalFileModule && !possibleResults.isEmpty()) {
                    TypeScriptQualifiedNameResolver.addMergedElementsFromAugmentations(module, possibleResults, realPlace, processor, !context.isQualifier());
                    ArrayList results = ContainerUtil.newArrayList(processor.getResults());
                    TypeScriptQualifiedNameResolver.addAugmentationsForModuleResults(source, results);
                    ArrayList arrayList = results;
                    if (arrayList == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "getGlobalElements"));
                    }
                    return arrayList;
                }
                Collection<PsiElement> localElements = TypeScriptQualifiedNameResolver.getLocalElements(module, possibleResults);
                if (!context.isQualifier() && isModule && !ContainerUtil.isEmpty(localElements)) {
                    Collection<PsiElement> collection = localElements;
                    if (collection == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "getGlobalElements"));
                    }
                    return collection;
                }
                result.addAll(possibleResults);
            }
            String qName = TypeScriptQualifiedNameResolver.getQualifiedNameForModule(name, module);
            this.addMergedAndGlobalElements(qName, source, context, result, false);
            if (!context.isQualifier() && !result.isEmpty()) break;
            module = ES6PsiUtil.getExportScope(module);
        }
        LinkedHashSet linkedHashSet = result;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "getGlobalElements"));
        }
        return linkedHashSet;
    }

    @Nullable
    private static Collection<PsiElement> getLocalElements(@NotNull PsiElement module, @NotNull List<? extends PsiElement> possibleResults) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "getLocalElements"));
        }
        if (possibleResults == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "possibleResults", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "getLocalElements"));
        }
        ArrayList notPublic = null;
        for (PsiElement psiElement : possibleResults) {
            JSAttributeList list;
            if (!(psiElement instanceof JSAttributeListOwner) || (list = ((JSAttributeListOwner)psiElement).getAttributeList()) == null || list.getAccessType() == JSAttributeList.AccessType.PUBLIC || TypeScriptQualifiedNameResolver.isRealModuleOfImplicitModule(module, psiElement)) continue;
            if (notPublic == null) {
                notPublic = ContainerUtil.newArrayList();
            }
            notPublic.add(psiElement);
        }
        return notPublic;
    }

    private static boolean isExternalFileModule(PsiElement module) {
        return module instanceof JSFile && ((JSFile)module).isCommonJSModule();
    }

    @NotNull
    private static PsiElement getRealSource(@NotNull PsiElement source, @NotNull TypeScriptImportHandlerContext context) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "getRealSource"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "getRealSource"));
        }
        PsiElement realPlace = context.getSource();
        if (realPlace == null) {
            realPlace = source;
        }
        PsiElement psiElement = realPlace;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "getRealSource"));
        }
        return psiElement;
    }

    @Nullable
    private static Collection<? extends PsiElement> getLocalClassesIfExists(@NotNull String name, @NotNull PsiElement source, @NotNull TypeScriptImportHandlerContext context, @Nullable PsiElement module, @Nullable PsiElement parent) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "getLocalClassesIfExists"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "getLocalClassesIfExists"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "getLocalClassesIfExists"));
        }
        if (module == parent || module == source || context.isQualifier()) {
            return null;
        }
        if (TypeScriptQualifiedNameResolver.isAmbientModule(module)) {
            return null;
        }
        ArrayList result = ContainerUtil.newArrayList();
        for (PsiElement currentParent = source; currentParent != module && currentParent != null && !TypeScriptPsiUtil.isTopLevelContainerMember(currentParent); currentParent = currentParent.getParent()) {
            if (currentParent instanceof JSClass && StringUtil.equals((CharSequence)((JSClass)currentParent).getName(), (CharSequence)name)) {
                result.add(currentParent);
            } else if (currentParent instanceof JSElement && TypeScriptQualifiedNameResolver.isClassScopeElement(currentParent)) {
                for (JSElement element : JSResolveUtil.findNamedElementsInScope(name, (JSElement)currentParent)) {
                    if (!(element instanceof JSClass)) continue;
                    result.add(element);
                }
            }
            if (result.isEmpty()) continue;
            return result;
        }
        return null;
    }

    private static boolean isAmbientModule(@Nullable PsiElement module) {
        VirtualFile file;
        if (module instanceof TypeScriptModule && TypeScriptPsiUtil.isAmbientDeclaration(module)) {
            return true;
        }
        return module instanceof JSFile && (file = PsiUtilCore.getVirtualFile((PsiElement)module)) != null && TypeScriptUtil.isDefinitionFile(file);
    }

    private static boolean isClassScopeElement(PsiElement currentParent) {
        return currentParent instanceof JSBlockStatement || currentParent instanceof TypeScriptModule || currentParent instanceof JSFile || currentParent instanceof TypeScriptFunction && !(currentParent instanceof TypeScriptTypeMember);
    }

    private void addMergedAndGlobalElements(@NotNull String qName, @NotNull PsiElement currentSource, @NotNull TypeScriptImportHandlerContext context, @NotNull Collection<PsiElement> result, boolean modulesOnly) {
        if (qName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qName", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "addMergedAndGlobalElements"));
        }
        if (currentSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentSource", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "addMergedAndGlobalElements"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "addMergedAndGlobalElements"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "addMergedAndGlobalElements"));
        }
        Collection<JSQualifiedNamedElement> elementsByQName = TypeScriptClassResolver.getInstance().findElementsByQNameAndPlace(qName, currentSource);
        Condition condition = element -> {
            if (currentSource == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentSource", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "lambda$addMergedAndGlobalElements$0"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "lambda$addMergedAndGlobalElements$0"));
            }
            if (result == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "lambda$addMergedAndGlobalElements$0"));
            }
            return TypeScriptQualifiedNameResolver.isAcceptableMergeSymbol(element, currentSource, context, result, modulesOnly);
        };
        List filteredElements = ContainerUtil.filter(elementsByQName, (Condition)condition);
        result.addAll(filteredElements);
        if (this.myIncludeAugmentations) {
            TypeScriptQualifiedNameResolver.addAugmentationsForModuleResults(currentSource, result);
        }
    }

    private static void addMergedElementsFromAugmentations(@NotNull PsiElement externalModule, @NotNull List<? extends PsiElement> possibleResults, @NotNull PsiElement realPlace, @NotNull PsiScopeProcessor processor, boolean isLastReference) {
        if (externalModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalModule", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "addMergedElementsFromAugmentations"));
        }
        if (possibleResults == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "possibleResults", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "addMergedElementsFromAugmentations"));
        }
        if (realPlace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "realPlace", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "addMergedElementsFromAugmentations"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "addMergedElementsFromAugmentations"));
        }
        boolean needAugmentations = false;
        for (PsiElement psiElement : possibleResults) {
            if (!ES6ImportHandler.isExported(psiElement)) continue;
            needAugmentations = true;
            break;
        }
        if (!needAugmentations) {
            return;
        }
        Collection<PsiElement> augmentations = TypeScriptAugmentationUtil.getAugmentations(realPlace, ContainerUtil.createMaybeSingletonList((Object)externalModule));
        for (PsiElement augmentation : augmentations) {
            TypeScriptQualifiedNameResolver.processES6DeclarationsInScope((JSElement)augmentation, processor, ResolveState.initial(), augmentation, realPlace, isLastReference);
        }
    }

    private static boolean isAcceptableMergeSymbol(@NotNull JSQualifiedNamedElement element, @NotNull PsiElement currentSource, @NotNull TypeScriptImportHandlerContext context, @NotNull Collection<PsiElement> result, boolean modulesOnly) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "isAcceptableMergeSymbol"));
        }
        if (currentSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentSource", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "isAcceptableMergeSymbol"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "isAcceptableMergeSymbol"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "isAcceptableMergeSymbol"));
        }
        if (result.contains(element)) {
            return false;
        }
        PsiElement source = TypeScriptQualifiedNameResolver.getRealSource(currentSource, context);
        if (element instanceof TypeScriptGlobalModuleExportDeclaration) {
            return TypeScriptConfigService.Provider.isAccessible(currentSource, (PsiElement)element);
        }
        if (modulesOnly && !(element instanceof TypeScriptModule)) {
            return false;
        }
        if (!ES6PsiUtil.isElementCanBeExported((PsiElement)element)) {
            return false;
        }
        if (element instanceof JSClass && !element.isNamespaceExplicitlyDeclared()) {
            return false;
        }
        PsiElement externalModule = ES6PsiUtil.findExternalModule((PsiElement)element);
        if (externalModule == null) {
            return TypeScriptImportHandler.checkModulesAccess(source, (PsiElement)element) && TypeScriptConfigService.Provider.isAccessible(source, (PsiElement)element);
        }
        PsiElement externalSourceModule = ES6PsiUtil.findExternalModule(currentSource);
        if (!(TypeScriptQualifiedNameResolver.externalModulesEqual(externalModule, externalSourceModule) || TypeScriptQualifiedNameResolver.checkAugmentationAccess((PsiElement)element, externalModule, source) || TypeScriptQualifiedNameResolver.checkGlobalAugmentation((PsiElement)element))) {
            return false;
        }
        return TypeScriptImportHandler.checkModulesAccess(source, (PsiElement)element) && TypeScriptConfigService.Provider.isAccessible(source, (PsiElement)element) && ES6ImportHandler.isExported((PsiElement)element);
    }

    private static boolean checkGlobalAugmentation(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "checkGlobalAugmentation"));
        }
        JSElement scope = ES6PsiUtil.getExportScope(element);
        while (scope instanceof TypeScriptModule && !((TypeScriptModule)scope).isGlobalScopeAugmentation()) {
            scope = ES6PsiUtil.getExportScope((PsiElement)scope);
        }
        return scope instanceof TypeScriptModule && ((TypeScriptModule)scope).isGlobalScopeAugmentation();
    }

    private static boolean externalModulesEqual(@Nullable PsiElement module, @Nullable PsiElement sourceModule) {
        if (module == sourceModule) {
            return true;
        }
        if (module == null) {
            return false;
        }
        if (module.isEquivalentTo(sourceModule)) {
            return true;
        }
        if (module instanceof TypeScriptModule && sourceModule instanceof TypeScriptModule) {
            String qName = ((TypeScriptModule)module).getQualifiedName();
            return qName != null && qName.equals(((TypeScriptModule)sourceModule).getQualifiedName());
        }
        return false;
    }

    private static void addAugmentationsForModuleResults(@NotNull PsiElement currentSource, @NotNull Collection<PsiElement> result) {
        Collection<PsiElement> externalModules;
        if (currentSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentSource", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "addAugmentationsForModuleResults"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "addAugmentationsForModuleResults"));
        }
        if (result.size() > 0 && !(externalModules = TypeScriptQualifiedNameResolver.getModulesForAugmentations(result)).isEmpty()) {
            result.addAll(TypeScriptAugmentationUtil.getAugmentations(currentSource, externalModules));
        }
    }

    private static Collection<PsiElement> getModulesForAugmentations(@NotNull Collection<PsiElement> result) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "getModulesForAugmentations"));
        }
        ArrayList modules = ContainerUtil.newArrayList();
        for (PsiElement element : result) {
            TypeScriptModule typeScriptModule;
            String refName;
            TypeScriptExportAssignment assignment;
            PsiElement module;
            if (ES6PsiUtil.isExternalModule(element)) {
                modules.add(element);
                continue;
            }
            if (!(element instanceof TypeScriptModule) || !((TypeScriptModule)element).isInternal() || (module = ES6PsiUtil.findExternalModule(element)) == null || (assignment = TypeScriptPsiUtil.findExportAssignment(module)) == null || !StringUtil.equals((CharSequence)(refName = assignment.getInitializerReference()), (CharSequence)TypeScriptQualifiedNameResolver.getQualifiedNameWithoutParentModule(typeScriptModule = (TypeScriptModule)element, module))) continue;
            modules.add(module);
        }
        return modules;
    }

    @Nullable
    private static String getQualifiedNameWithoutParentModule(@NotNull TypeScriptModule module, @NotNull PsiElement externalModule) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "getQualifiedNameWithoutParentModule"));
        }
        if (externalModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalModule", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "getQualifiedNameWithoutParentModule"));
        }
        String moduleQualifiedName = module.getQualifiedName();
        if (externalModule instanceof TypeScriptModule) {
            String name = ((TypeScriptModule)externalModule).getQualifiedName();
            if (moduleQualifiedName == null || name == null) {
                return moduleQualifiedName;
            }
            int indexOfExternalModule = moduleQualifiedName.indexOf(name);
            if (indexOfExternalModule != -1) {
                int position = indexOfExternalModule + name.length() + 1;
                return position < moduleQualifiedName.length() ? moduleQualifiedName.substring(position) : moduleQualifiedName;
            }
        }
        return moduleQualifiedName;
    }

    private static String getQualifiedNameForModule(@NotNull String name, PsiElement module) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "getQualifiedNameForModule"));
        }
        return module instanceof TypeScriptModule ? ((TypeScriptModule)module).getQualifiedName() + "." + name : name;
    }

    private static boolean isRealModuleOfImplicitModule(PsiElement module, PsiElement element) {
        return module instanceof TypeScriptImplicitModule && ((TypeScriptImplicitModule)module).getRealModule() == element;
    }

    public static boolean checkAugmentationAccess(@NotNull PsiElement element, @NotNull PsiElement module, @Nullable PsiElement source) {
        PsiElement sourceContainer;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "checkAugmentationAccess"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "checkAugmentationAccess"));
        }
        if (TypeScriptPsiUtil.isAugmentationModule(element)) {
            return true;
        }
        if (source instanceof TypeScriptModule) {
            sourceContainer = source;
        } else {
            JSElement jSElement = sourceContainer = source == null ? null : ES6PsiUtil.getExportScope(source);
        }
        return module.isEquivalentTo(sourceContainer) || module instanceof JSQualifiedNamedElement && sourceContainer instanceof JSQualifiedNamedElement && StringUtil.equals((CharSequence)((JSQualifiedNamedElement)module).getQualifiedName(), (CharSequence)((JSQualifiedNamedElement)sourceContainer).getQualifiedName()) || TypeScriptPsiUtil.isAugmentationModule(element) || TypeScriptPsiUtil.isAugmentationModule(element);
    }

    private void findReferencedElements(@NotNull String name, @NotNull PsiElement source, @NotNull TypeScriptElementVisitor visitor) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "findReferencedElements"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "findReferencedElements"));
        }
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "findReferencedElements"));
        }
        Collection<? extends PsiElement> localResults = this.getElements(name, source, visitor);
        for (PsiElement psiElement : localResults) {
            if (this.myIsTypeContext && !TypeScriptPsiUtil.isNamedTypeContainerDefinition(psiElement)) continue;
            Collection<PsiElement> elements = this.expandElement(psiElement);
            for (PsiElement psiElement2 : elements) {
                if (!visitor.accept(psiElement2)) continue;
                return;
            }
        }
    }

    public final class SubTypeVisitor
    implements TypeScriptHierarchyVisitor {
        private TypeScriptHierarchyVisitor parent;
        private PsiElement currentScope;
        private String name;
        private boolean isQualifier = false;

        private TypeScriptElementVisitor createSimpleExpressionVisitor(final boolean localResolve) {
            return new TypeScriptElementVisitor(){
                private THashSet<PsiElement> accepted;
                private final boolean isLocalResolve;
                {
                    this.isLocalResolve = localResolve;
                }

                @Override
                public boolean isLocalResolve() {
                    return this.isLocalResolve;
                }

                @Override
                public boolean accept(PsiElement element) {
                    if (this.accepted == null) {
                        this.accepted = new THashSet();
                    }
                    if (!this.accepted.add((Object)element)) {
                        return false;
                    }
                    return SubTypeVisitor.this.parent.accept(element);
                }

                @Override
                public PsiElement getSource() {
                    return SubTypeVisitor.this.currentScope;
                }

                @Override
                public boolean isQualifier() {
                    return SubTypeVisitor.this.isQualifier;
                }
            };
        }

        @Override
        public boolean accept(PsiElement qualifierResult) {
            if (qualifierResult instanceof TypeScriptModule || qualifierResult instanceof JSFile) {
                TypeScriptQualifiedNameResolver.this.findReferencedElements(this.name, qualifierResult, this.createSimpleExpressionVisitor(true));
            }
            return this.parent.isDone();
        }

        public SubTypeVisitor createSubVisitor() {
            SubTypeVisitor visitor = new SubTypeVisitor();
            visitor.parent = this;
            visitor.currentScope = this.currentScope;
            visitor.isQualifier = true;
            return visitor;
        }

        public void processQualifier(@NotNull JSQualifiedName qualifiedName) {
            if (qualifiedName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver$SubTypeVisitor", "processQualifier"));
            }
            if (!TypeScriptQualifiedNameResolver.this.myVisited.add(Pair.create((Object)qualifiedName, (Object)this.currentScope))) {
                return;
            }
            this.name = qualifiedName.getName();
            JSQualifiedName qualifier = qualifiedName.getParent();
            if (qualifier != null) {
                this.createSubVisitor().processQualifier(qualifier);
            } else {
                TypeScriptQualifiedNameResolver.this.findReferencedElements(this.name, this.currentScope, this.createSimpleExpressionVisitor(false));
            }
        }

        @Override
        public boolean isDone() {
            return this.parent.isDone();
        }
    }

    static interface TypeScriptElementVisitor
    extends TypeScriptImportHandlerContext {
        public boolean accept(PsiElement var1);
    }

    static interface TypeScriptHierarchyVisitor {
        public boolean accept(PsiElement var1);

        public boolean isDone();
    }
}

