/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ecmascript6;

import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.ecmascript6.resolve.ES6TypeEvaluator;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.ecmascript6.TypeScriptImportHandler;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeEvaluationResult;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.e4x.impl.JSXmlLiteralExpressionImpl;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCallSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCastExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptExportAssignment;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptGlobalModuleExportDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptIndexSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptNotNullExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSContextResolver;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.resolve.JSTypeProcessor;
import com.intellij.lang.javascript.psi.resolve.QualifiedItemProcessor;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyCallElement;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyContextElement;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyInstanceContextElement;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSArrayType;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSTupleTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.TypeScriptGenericThisTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.typescript.psi.TypeScriptEntityName;
import com.intellij.lang.typescript.psi.TypeScriptExternalModuleReference;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptTypeEvaluator
extends ES6TypeEvaluator {
    private static final Condition<PsiElement> HAS_DECLARATIONS = element -> TypeScriptTypeEvaluator.hasInnerDeclarations(element);

    public TypeScriptTypeEvaluator(JSEvaluateContext context, JSTypeProcessor processor) {
        super(context, processor);
    }

    @Override
    protected boolean addTypeFromDialectSpecificElements(PsiElement resolveResult) {
        if (resolveResult instanceof TypeScriptPropertySignature) {
            TypeScriptPropertySignature propertySignature = (TypeScriptPropertySignature)resolveResult;
            JSTypeDeclaration propertyType = propertySignature.getTypeDeclaration();
            if (propertyType instanceof JSFunction) {
                this.processFunction((JSFunction)propertyType);
            } else if (propertyType != null) {
                JSType jsType = propertySignature.getType();
                this.addType(jsType, resolveResult);
            }
            return true;
        }
        if (resolveResult instanceof TypeScriptModule) {
            this.addTypeFromModule((TypeScriptModule)resolveResult);
            return true;
        }
        if (resolveResult instanceof TypeScriptImportStatement) {
            this.addTypeFromImportStatement((TypeScriptImportStatement)resolveResult);
            return true;
        }
        if (resolveResult instanceof TypeScriptIndexSignature) {
            JSReferenceExpression expression = this.myContext.getProcessedExpression();
            if (expression != null) {
                JSType type = ((TypeScriptIndexSignature)resolveResult).getMemberType();
                this.addType(type, resolveResult);
                return true;
            }
        } else {
            if (resolveResult instanceof TypeScriptCallSignature) {
                JSApplyContextElement peek = this.myContext.peekJSElementToApply();
                TypeScriptCallSignature callSignature = (TypeScriptCallSignature)resolveResult;
                if (callSignature.hasNew() ? peek instanceof JSApplyInstanceContextElement && ((JSApplyInstanceContextElement)peek).getNewExpression() != null : peek instanceof JSApplyCallElement) {
                    this.myContext.processWithoutTopJSElementToApply(() -> this.addType(callSignature.getReturnType(), resolveResult));
                }
                return true;
            }
            if (resolveResult instanceof TypeScriptGlobalModuleExportDeclaration) {
                for (PsiElement element : ((TypeScriptGlobalModuleExportDeclaration)resolveResult).getModules()) {
                    this.addTypeFromExternalModuleReferenceResolveResult(element);
                }
                return true;
            }
        }
        return super.addTypeFromDialectSpecificElements(resolveResult);
    }

    private void addTypeFromModule(TypeScriptModule resolveResult) {
        boolean isJavaScriptContext;
        JSReferenceExpression expression = this.myContext.getProcessedExpression();
        if (expression == null) {
            return;
        }
        if (resolveResult.isShorthandAmbientModule()) {
            this.addType(JSAnyType.get((PsiElement)resolveResult, true), (PsiElement)resolveResult);
            return;
        }
        boolean hasType = false;
        String name = resolveResult.getName();
        if (name != null && this.myTypeProcessor instanceof PsiScopeProcessor) {
            Collection<? extends PsiElement> elements = TypeScriptImportHandler.getInstance().resolveName(name, (PsiElement)expression).getElements();
            for (PsiElement psiElement : elements) {
                if (psiElement.isEquivalentTo((PsiElement)resolveResult)) continue;
                if (TypeScriptTypeEvaluator.hasInnerDeclarations(psiElement)) {
                    hasType = true;
                    continue;
                }
                this.addTypeFromResolveResult(psiElement, false);
            }
        }
        if (this.shouldAddLocalModule(hasType, isJavaScriptContext = DialectDetector.isJavaScript((PsiElement)expression))) {
            this.addTypeFromLocalModule((JSQualifiedNamedElement)resolveResult, isJavaScriptContext);
        }
    }

    private boolean shouldAddLocalModule(boolean hasType, boolean isJavaScriptContext) {
        return !(this.myTypeProcessor instanceof PsiScopeProcessor) || isJavaScriptContext || hasType || this.myContext.isJSElementsToApplyEmpty();
    }

    private void addTypeFromLocalModule(@NotNull JSQualifiedNamedElement resolveResult, boolean isJavaScriptContext) {
        if (resolveResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveResult", "com/intellij/lang/javascript/ecmascript6/TypeScriptTypeEvaluator", "addTypeFromLocalModule"));
        }
        String name = resolveResult.getQualifiedName();
        if (!StringUtil.isEmpty((String)name)) {
            JSTypeSource source = JSTypeSourceFactory.createTypeSource(resolveResult.getParent(), true);
            JSType jsType = JSNamedType.createType(name, source, isJavaScriptContext ? JSContext.UNKNOWN : JSContext.STATIC);
            this.addType(jsType, (PsiElement)resolveResult);
        }
    }

    private void addTypeFromImportStatement(TypeScriptImportStatement resolveResult) {
        this.processItem(resolveResult, JSEvaluateContext.JSEvaluationPlace.DEFAULT, importStatement -> {
            TypeScriptEntityName internalModuleReference = importStatement.getInternalModuleReference();
            TypeScriptExternalModuleReference externalModuleReference = importStatement.getExternalModuleReference();
            if (internalModuleReference != null) {
                Collection<PsiElement> elements = JSResolveResult.toElements(internalModuleReference.multiResolve(false));
                this.addTypeFromInternalModules(elements);
            } else if (externalModuleReference != null) {
                Collection elements = externalModuleReference.multiResolve();
                for (PsiElement element : elements) {
                    this.addTypeFromExternalModuleReferenceResolveResult(element);
                }
            }
        });
    }

    private void addTypeFromInternalModules(Collection<PsiElement> elements) {
        boolean isJavaScriptContext;
        boolean hasType;
        if (elements.size() == 0) {
            return;
        }
        if (elements.size() == 1) {
            PsiElement item = (PsiElement)ContainerUtil.getFirstItem(elements);
            assert (item != null);
            this.addTypeFromResolveResult(item, false);
            return;
        }
        JSReferenceExpression expression = this.myContext.getProcessedExpression();
        if (expression == null) {
            return;
        }
        List modules = ContainerUtil.filter(elements, TypeScriptPsiUtil.IS_TS_MODULE);
        if (modules.size() > 0 && this.shouldAddLocalModule(hasType = ContainerUtil.filter(elements, HAS_DECLARATIONS).size() > 0, isJavaScriptContext = DialectDetector.isJavaScript((PsiElement)expression))) {
            JSQualifiedNamedElement module = (JSQualifiedNamedElement)ContainerUtil.getFirstItem((List)modules);
            assert (module != null);
            this.addTypeFromLocalModule(module, isJavaScriptContext);
        }
        for (PsiElement element : elements) {
            if (element instanceof TypeScriptModule) continue;
            this.addTypeFromResolveResult(element, false);
        }
    }

    @Override
    protected boolean qualifierTypeIsExplicitlyDeclared(@Nullable JSExpression qualifier) {
        if (qualifier == null || !DialectDetector.isTypeScript((PsiElement)qualifier)) {
            return true;
        }
        return TypeScriptUtil.qualifierTypeIsExplicitlyDeclared(qualifier);
    }

    @Override
    protected void addTypeFromVariableResolveResult(@NotNull JSVariable jsVariable) {
        if (jsVariable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsVariable", "com/intellij/lang/javascript/ecmascript6/TypeScriptTypeEvaluator", "addTypeFromVariableResolveResult"));
        }
        super.addTypeFromVariableResolveResult(jsVariable);
        if (this.shouldProcessVariableWithInitializer((PsiElement)jsVariable)) {
            this.processRequireCallInitializer(jsVariable);
        }
    }

    @Override
    protected void processThisQualifierExpression(@NotNull JSThisExpression rawqualifier, @NotNull JSClass jsClass, @NotNull JSContext staticOrInstance) {
        TypeScriptTypeParameter[] parametersForOwner;
        if (rawqualifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rawqualifier", "com/intellij/lang/javascript/ecmascript6/TypeScriptTypeEvaluator", "processThisQualifierExpression"));
        }
        if (jsClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsClass", "com/intellij/lang/javascript/ecmascript6/TypeScriptTypeEvaluator", "processThisQualifierExpression"));
        }
        if (staticOrInstance == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "staticOrInstance", "com/intellij/lang/javascript/ecmascript6/TypeScriptTypeEvaluator", "processThisQualifierExpression"));
        }
        String name = jsClass.getQualifiedName();
        if (name != null && (parametersForOwner = TypeScriptPsiUtil.getTypeParametersForOwner((PsiElement)jsClass)).length > 0 && staticOrInstance == JSContext.INSTANCE) {
            JSTypeSource source = JSTypeSourceFactory.createTypeSource((PsiElement)rawqualifier, true);
            JSTypeSource classNameSource = JSTypeSourceFactory.createTypeSource((PsiElement)jsClass, true);
            List<JSType> types = TypeScriptGenericTypesEvaluator.buildGenericParameters(parametersForOwner);
            this.addType(new JSGenericTypeImpl(source, JSNamedType.createType(name, classNameSource, JSContext.INSTANCE), types), (PsiElement)jsClass);
            return;
        }
        super.processThisQualifierExpression(rawqualifier, jsClass, staticOrInstance);
    }

    private void processRequireCallInitializer(@NotNull JSVariable jsVariable) {
        JSCallExpression callExpression;
        JSExpression methodExpression;
        if (jsVariable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsVariable", "com/intellij/lang/javascript/ecmascript6/TypeScriptTypeEvaluator", "processRequireCallInitializer"));
        }
        JSExpression initializer = jsVariable.getInitializerOrStub();
        if (initializer instanceof JSCallExpression && (methodExpression = (callExpression = (JSCallExpression)initializer).getMethodExpression()) instanceof JSReferenceExpression) {
            this.processRequireMethodCall((JSCallExpression)initializer, (JSReferenceExpression)methodExpression, DialectDetector.isTypeScript((PsiElement)jsVariable));
        }
    }

    private boolean shouldProcessVariableWithInitializer(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/ecmascript6/TypeScriptTypeEvaluator", "shouldProcessVariableWithInitializer"));
        }
        return this.isFromCurrentFile(context) && this.myTypeProcessor instanceof QualifiedItemProcessor && ((QualifiedItemProcessor)this.myTypeProcessor).resolved != QualifiedItemProcessor.TypeResolveState.Resolved;
    }

    @Override
    protected void addTypeFromExternalModuleReferenceResolveResult(@Nullable PsiElement resolve) {
        if (resolve != null && DialectDetector.isTypeScript(resolve)) {
            PsiFile file = resolve.getContainingFile();
            if (file == null) {
                return;
            }
            TypeScriptExportAssignment exportAssignment = TypeScriptPsiUtil.findExportAssignment(resolve);
            if (resolve instanceof JSFile) {
                if (exportAssignment == null) {
                    this.myTypeProcessor.processResolvedElement(resolve, this.myContext);
                }
            } else if (resolve instanceof TypeScriptModule && exportAssignment == null) {
                this.addTypeFromResolveResult(resolve, true);
            }
            if (exportAssignment != null) {
                this.evaluateExportAssignment((JSExportAssignment)exportAssignment);
            }
        } else {
            super.addTypeFromExternalModuleReferenceResolveResult(resolve);
        }
    }

    @Override
    protected void evaluateExportAssignment(JSExportAssignment assignment) {
        String reference;
        if (assignment instanceof TypeScriptExportAssignment && (reference = assignment.getInitializerReference()) != null) {
            List<PsiElement> elements = JSStubBasedPsiTreeUtil.resolveLocallyWithMergedResults(reference, (PsiElement)assignment);
            for (PsiElement element : elements) {
                this.addTypeFromResolveResult(element, false);
            }
            if (!elements.isEmpty()) {
                return;
            }
        }
        super.evaluateExportAssignment(assignment);
    }

    @Override
    protected boolean evaluateDialectSpecificTypes(JSExpression rawQualifier) {
        if (rawQualifier instanceof TypeScriptCastExpression) {
            TypeScriptType typeScriptType = ((TypeScriptCastExpression)rawQualifier).getType();
            if (typeScriptType != null) {
                JSType type = TypeScriptTypeParser.buildTypeFromTypeScript((JSTypeDeclaration)typeScriptType);
                this.addType(type, (PsiElement)rawQualifier);
                return true;
            }
        } else if (rawQualifier instanceof TypeScriptNotNullExpression) {
            this.evaluateTypes(((TypeScriptNotNullExpression)rawQualifier).getExpression());
            return true;
        }
        return super.evaluateDialectSpecificTypes(rawQualifier);
    }

    @Override
    protected void addTypeFromClassExpression(@NotNull JSClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/lang/javascript/ecmascript6/TypeScriptTypeEvaluator", "addTypeFromClassExpression"));
        }
        if (DialectDetector.isTypeScript((PsiElement)aClass)) {
            this.addTypeFromClass((PsiElement)aClass, null);
            return;
        }
        super.addTypeFromClassExpression(aClass);
    }

    @Override
    protected void addTypeFromClass(@NotNull PsiElement resolveResult, @Nullable PsiElement constructor) {
        if (resolveResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveResult", "com/intellij/lang/javascript/ecmascript6/TypeScriptTypeEvaluator", "addTypeFromClass"));
        }
        if (!DialectDetector.isTypeScript(resolveResult)) {
            super.addTypeFromClass(resolveResult, constructor);
            return;
        }
        JSReferenceExpression processedExpression = this.myContext.getProcessedExpression();
        if (resolveResult instanceof TypeScriptInterface && processedExpression != null) {
            this.processAllIdenticallyNamedElements((PsiElement)processedExpression, resolveResult);
        } else if (resolveResult instanceof JSClass) {
            JSRecordType type;
            JSClass jsClass = (JSClass)resolveResult;
            String qName = jsClass.getQualifiedName();
            JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource(resolveResult, true);
            if (qName == null) {
                type = TypeScriptTypeParser.buildTypeFromClass(jsClass, true);
            } else {
                JSContext staticOrInstance = this.isPrototypeOrNewExpression() ? JSContext.INSTANCE : JSContext.STATIC;
                type = JSNamedType.createType(qName, typeSource, staticOrInstance);
            }
            PsiElement source = this.getSourceForTypeContext(resolveResult, processedExpression);
            this.addType((JSType)type, source);
        } else if (resolveResult instanceof JSFunction) {
            JSType returnType;
            if (resolveResult.getParent() instanceof TypeScriptInterface && (returnType = ((JSFunction)resolveResult).getReturnType()) != null) {
                this.addType(returnType, resolveResult);
            } else {
                this.addTypeFromClass(resolveResult.getParent(), resolveResult);
            }
        }
    }

    private PsiElement getSourceForTypeContext(PsiElement resolveResult, JSReferenceExpression processedExpression) {
        return processedExpression != null && resolveResult.getContainingFile().isEquivalentTo((PsiElement)this.myContext.targetFile) ? processedExpression : resolveResult;
    }

    private void processAllIdenticallyNamedElements(@NotNull PsiElement expression, @NotNull PsiElement resolveResult) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/javascript/ecmascript6/TypeScriptTypeEvaluator", "processAllIdenticallyNamedElements"));
        }
        if (resolveResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveResult", "com/intellij/lang/javascript/ecmascript6/TypeScriptTypeEvaluator", "processAllIdenticallyNamedElements"));
        }
        if (!(this.myTypeProcessor instanceof PsiScopeProcessor)) {
            return;
        }
        if (this.myTypeProcessor instanceof ResolveProcessor) {
            ((ResolveProcessor)((Object)this.myTypeProcessor)).prefixResolved();
        }
        boolean result = true;
        if (!this.skipCallContextIfModule(resolveResult) && TypeScriptTypeEvaluator.hasInnerDeclarations(resolveResult)) {
            result = JSResolveUtil.processDeclarationsInScope((JSElement)((JSQualifiedNamedElement)resolveResult), (PsiScopeProcessor)this.myTypeProcessor, ResolveState.initial(), resolveResult, expression);
        }
        if (result && resolveResult.getContainingFile() == expression.getContainingFile()) {
            String name = ((JSQualifiedNamedElement)resolveResult).getQualifiedName();
            if (name == null) {
                return;
            }
            this.addIdenticalNameElements(expression, resolveResult, name);
        }
    }

    private void addIdenticalNameElements(@NotNull PsiElement expression, @Nullable PsiElement resolveResult, String name) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/javascript/ecmascript6/TypeScriptTypeEvaluator", "addIdenticalNameElements"));
        }
        Collection<? extends PsiElement> elements = TypeScriptImportHandler.getInstance().resolveName(name, expression).getElements();
        for (PsiElement psiElement : elements) {
            if (!(psiElement instanceof JSQualifiedNamedElement) || psiElement.equals(resolveResult) || this.skipCallContextIfModule(psiElement)) continue;
            if (!TypeScriptTypeEvaluator.hasInnerDeclarations(psiElement)) {
                this.addTypeFromResolveResult(psiElement, false);
                continue;
            }
            if (!(this.myTypeProcessor instanceof PsiScopeProcessor) || psiElement.processDeclarations((PsiScopeProcessor)this.myTypeProcessor, ResolveState.initial(), psiElement, expression)) continue;
            break;
        }
    }

    private static boolean hasInnerDeclarations(PsiElement element) {
        return !(element instanceof JSVariable) && !(element instanceof JSFunction);
    }

    private boolean skipCallContextIfModule(PsiElement resolveResult) {
        return resolveResult instanceof TypeScriptModule && !this.myContext.isJSElementsToApplyEmpty() && !(this.myContext.peekJSElementToApply() instanceof JSApplyInstanceContextElement);
    }

    @Override
    protected void addTypeFromResolvedImport(PsiElement referencedElement) {
        if (referencedElement instanceof TypeScriptModule) {
            this.addTypeFromLocalModule((JSQualifiedNamedElement)((TypeScriptModule)referencedElement), false);
        } else if (referencedElement instanceof ES6ExportDefaultAssignment) {
            JSElement element = ((ES6ExportDefaultAssignment)referencedElement).getStubSafeElement();
            if (element instanceof JSClass) {
                this.myTypeProcessor.processResolvedElement((PsiElement)element.getContainingFile(), this.myContext);
                this.addTypeFromResolveResult((PsiElement)element, false);
            } else {
                super.addTypeFromResolvedImport(referencedElement);
            }
        } else {
            super.addTypeFromResolvedImport(referencedElement);
        }
    }

    @Override
    @NotNull
    public List<JSType> getComponentTypeFromProcessor(@Nullable JSExpression rawqualifier, @Nullable JSType type) {
        if (type instanceof JSTypeImpl) {
            JSType typedef = ((JSTypeImpl)type).getTypedef(null, null);
            JSType jSType = type = typedef != null ? typedef : type;
        }
        if ((type = JSTypeUtils.getValuableType(type)) instanceof JSArrayType || type == null) {
            List<JSType> list = super.getComponentTypeFromProcessor(rawqualifier, type);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptTypeEvaluator", "getComponentTypeFromProcessor"));
            }
            return list;
        }
        if (!(rawqualifier instanceof JSIndexedPropertyAccessExpression)) {
            List<JSType> list = super.getComponentTypeFromProcessor(rawqualifier, type);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptTypeEvaluator", "getComponentTypeFromProcessor"));
            }
            return list;
        }
        JSRecordType recordType = type.asRecordType();
        if (recordType.getTypeMembers().isEmpty()) {
            List<JSType> list = super.getComponentTypeFromProcessor(rawqualifier, type);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptTypeEvaluator", "getComponentTypeFromProcessor"));
            }
            return list;
        }
        ArrayList indexSignatures = ContainerUtil.newArrayList();
        for (JSRecordType.TypeMember member : recordType.getTypeMembers()) {
            if (!(member instanceof JSRecordType.IndexSignature)) continue;
            indexSignatures.add((JSRecordType.IndexSignature)member);
        }
        JSAnyType result = null;
        if (indexSignatures.size() > 0) {
            JSType expressionTypeType;
            JSTypeEvaluationResult expressionTypeResult;
            JSExpression expression = ((JSIndexedPropertyAccessExpression)rawqualifier).getIndexExpression();
            JSTypeEvaluationResult jSTypeEvaluationResult = expressionTypeResult = expression != null ? JSTypeEvaluator.getExpressionType(expression) : null;
            if (expressionTypeResult != null && (expressionTypeType = expressionTypeResult.getType()) != null) {
                for (JSRecordType.IndexSignature signature : indexSignatures) {
                    if (!JSResolveUtil.isAssignableJSType(signature.getMemberParameterType(), expressionTypeType)) continue;
                    result = signature.getMemberType();
                    break;
                }
            }
        }
        if (result == null) {
            result = JSAnyType.get((PsiElement)rawqualifier, false);
        }
        List<Object> list = Collections.singletonList(result);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptTypeEvaluator", "getComponentTypeFromProcessor"));
        }
        return list;
    }

    @Override
    protected void addTypeFromLiteralExpression(@NotNull JSExpression rawqualifier) {
        if (rawqualifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rawqualifier", "com/intellij/lang/javascript/ecmascript6/TypeScriptTypeEvaluator", "addTypeFromLiteralExpression"));
        }
        if (DialectDetector.isTypeScript((PsiElement)rawqualifier) && rawqualifier instanceof JSXmlLiteralExpressionImpl) {
            this.addType(JSAnyType.get((PsiElement)rawqualifier, true), (PsiElement)rawqualifier);
            return;
        }
        super.addTypeFromLiteralExpression(rawqualifier);
    }

    @Override
    @NotNull
    protected ResolveResult[] getResolveResultsFromQualifier(@NotNull JSReferenceExpression qualifier) {
        if (qualifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "com/intellij/lang/javascript/ecmascript6/TypeScriptTypeEvaluator", "getResolveResultsFromQualifier"));
        }
        ResolveResult[] resolveResult = super.getResolveResultsFromQualifier(qualifier);
        boolean hasModules = false;
        for (ResolveResult result : resolveResult) {
            if (!(result.getElement() instanceof TypeScriptModule)) continue;
            hasModules = true;
            break;
        }
        if (!hasModules || resolveResult.length <= 1) {
            if (resolveResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptTypeEvaluator", "getResolveResultsFromQualifier"));
            }
            return resolveResult;
        }
        ArrayList newResults = ContainerUtil.newArrayListWithCapacity((int)resolveResult.length);
        HashSet visitedQualifiers = ContainerUtil.newHashSet();
        for (ResolveResult result : resolveResult) {
            PsiElement element = result.getElement();
            if (!(element instanceof TypeScriptModule)) {
                newResults.add(result);
                continue;
            }
            TypeScriptModule module = (TypeScriptModule)element;
            if (module.isAugmentation() || !visitedQualifiers.add(module.getQualifiedName())) continue;
            newResults.add(result);
        }
        ResolveResult[] resolveResultArray = newResults.size() == resolveResult.length ? resolveResult : (ResolveResult[])ContainerUtil.toArray((List)newResults, (Object[])new ResolveResult[newResults.size()]);
        if (resolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptTypeEvaluator", "getResolveResultsFromQualifier"));
        }
        return resolveResultArray;
    }

    @Override
    @NotNull
    protected JSType getArrayTypeFromExpressions(JSExpression rawQualifier, JSExpression[] expressions) {
        ArrayList types = ContainerUtil.newArrayList();
        DialectOptionHolder holder = DialectDetector.dialectOfElement((PsiElement)rawQualifier);
        for (JSExpression expression : expressions) {
            JSType expressionType = this.getExpressionTypeForArrayLiteral(rawQualifier, expression, holder);
            if (expressionType == null) {
                expressionType = this.createNullType(rawQualifier);
            }
            types.add(expressionType);
        }
        JSTupleTypeImpl jSTupleTypeImpl = new JSTupleTypeImpl(JSTypeSourceFactory.createTypeSource((PsiElement)rawQualifier, true), types, false);
        if (jSTupleTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptTypeEvaluator", "getArrayTypeFromExpressions"));
        }
        return jSTupleTypeImpl;
    }

    @Override
    protected boolean addTypeFromAmdModuleReference(@NotNull JSParameter parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/intellij/lang/javascript/ecmascript6/TypeScriptTypeEvaluator", "addTypeFromAmdModuleReference"));
        }
        return !DialectDetector.isTypeScript((PsiElement)parameter) && super.addTypeFromAmdModuleReference(parameter);
    }

    @Override
    protected void addModuleFromRequire(PsiElement module, JSCallExpression callExpression) {
        if (DialectDetector.isTypeScript((PsiElement)callExpression) && !DialectDetector.isTypeScript(module)) {
            return;
        }
        super.addModuleFromRequire(module, callExpression);
    }

    @Override
    protected void processThisQualifierInExecutionScope(@NotNull JSThisExpression thisQualifier, PsiElement thisScope) {
        if (thisQualifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thisQualifier", "com/intellij/lang/javascript/ecmascript6/TypeScriptTypeEvaluator", "processThisQualifierInExecutionScope"));
        }
        if (thisScope instanceof TypeScriptFunction) {
            JSType type;
            PsiElement context = thisScope;
            if (thisScope instanceof JSFunctionExpression) {
                context = JSContextResolver.findContextElement(thisQualifier);
            }
            if (context instanceof TypeScriptFunction && (type = ((TypeScriptFunction)context).getExplicitThisType()) != null) {
                this.addType(type, (PsiElement)thisQualifier);
                return;
            }
        }
        super.processThisQualifierInExecutionScope(thisQualifier, thisScope);
    }

    @Override
    @Nullable
    protected JSFunction getClassConstructor(@NotNull JSClass resolveResult) {
        ResolveResult[] results;
        if (resolveResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveResult", "com/intellij/lang/javascript/ecmascript6/TypeScriptTypeEvaluator", "getClassConstructor"));
        }
        JSReferenceExpression expression = this.myContext.getProcessedExpression();
        if (expression != null && (results = JSClassUtils.resolveES6Constructor(resolveResult, (JSExpression)expression)).length > 0) {
            for (ResolveResult result : results) {
                PsiElement element = result.getElement();
                if (!result.isValidResult() || element == null) continue;
                return element instanceof JSFunction ? (JSFunction)element : super.getClassConstructor(resolveResult);
            }
            ResolveResult result = results[0];
            PsiElement element = result.getElement();
            return element instanceof JSFunction ? (JSFunction)element : super.getClassConstructor(resolveResult);
        }
        return super.getClassConstructor(resolveResult);
    }

    @Override
    protected JSType substituteThisType(JSType type, JSVariable jsVariable) {
        JSType parentType;
        if (!JSTypeUtils.hasThisGenericType(type)) {
            return type;
        }
        JSClass context = JSResolveUtil.getClassOfContext((PsiElement)jsVariable);
        JSTypeSource source = type.getSource();
        if (context == null) {
            return type;
        }
        String name = context.getQualifiedName();
        JSType jSType = parentType = name == null ? null : JSNamedType.createType(name, source, JSContext.INSTANCE);
        if (parentType == null) {
            return type;
        }
        return type.transformTypeHierarchy(jsType -> {
            JSTypeSource currentSource;
            if (jsType instanceof TypeScriptGenericThisTypeImpl && (currentSource = jsType.getSource()).getSourceElement() != context) {
                JSTypeSource newSource = JSTypeSourceFactory.createTypeSource((PsiElement)context, currentSource.isExplicitlyDeclared());
                return new TypeScriptGenericThisTypeImpl(newSource, parentType);
            }
            return jsType;
        });
    }
}

