/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ImportOptimizer;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.flex.ImportUtils;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSImportStatement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.javascript.validation.ActionScriptUnusedImportsHelper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.util.XmlRefCountHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ECMAScriptImportOptimizer
implements ImportOptimizer {
    private static final Logger LOG = Logger.getInstance((String)ECMAScriptImportOptimizer.class.getName());

    public boolean supports(PsiFile file) {
        return file.getLanguage() == JavaScriptSupportLoader.ECMA_SCRIPT_L4 || JavaScriptSupportLoader.isFlexMxmFile(file);
    }

    @NotNull
    public Runnable processFile(PsiFile file) {
        VirtualFile vFile = file.getVirtualFile();
        if (vFile instanceof VirtualFileWindow) {
            vFile = ((VirtualFileWindow)vFile).getDelegate();
        }
        if (vFile == null || !ProjectRootManager.getInstance((Project)file.getProject()).getFileIndex().isInSourceContent(vFile)) {
            Runnable runnable = EmptyRunnable.INSTANCE;
            if (runnable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/ECMAScriptImportOptimizer", "processFile"));
            }
            return runnable;
        }
        Runnable runnable = () -> {
            List<FormatFixer> formatters = ECMAScriptImportOptimizer.executeNoFormat(file);
            for (FormatFixer formatter : formatters) {
                formatter.fixFormat();
            }
        };
        if (runnable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/ECMAScriptImportOptimizer", "processFile"));
        }
        return runnable;
    }

    public static List<FormatFixer> executeNoFormat(PsiFile file) {
        if (!CommonRefactoringUtil.checkReadOnlyStatus((PsiElement)file)) {
            return Collections.emptyList();
        }
        ActionScriptUnusedImportsHelper.Results unusedImportsResults = ActionScriptUnusedImportsHelper.getUnusedImports(file);
        Project project = file.getProject();
        try {
            ArrayList<FormatFixer> formatters = new ArrayList<FormatFixer>();
            for (Computable holderWrapper : unusedImportsResults.importsByHolder.keySet()) {
                PsiElement firstAdded;
                JSElement holder = (JSElement)holderWrapper.compute();
                Pair<PsiElement, Boolean> defaultInsertionPlace = ImportUtils.getImportInsertionPlace(holder);
                Collection fqnsToImport = unusedImportsResults.importsByHolder.get((Object)holderWrapper);
                String importBlock = ImportUtils.createImportBlock(file, fqnsToImport);
                PsiFile newImports = PsiFileFactory.getInstance((Project)project).createFileFromText("dummy." + JavaScriptSupportLoader.ECMA_SCRIPT_L4.getFileExtension(), importBlock);
                if (defaultInsertionPlace != null) {
                    boolean before = (Boolean)defaultInsertionPlace.second;
                    PsiElement insertionPlace = (PsiElement)defaultInsertionPlace.first;
                    JSImportStatement earlyImport = ImportUtils.findEarlyImport(before ? insertionPlace : insertionPlace.getNextSibling());
                    if (earlyImport != null) {
                        insertionPlace = earlyImport;
                        before = true;
                    }
                    firstAdded = before ? insertionPlace.getParent().addRangeBefore(newImports.getFirstChild(), newImports.getLastChild(), insertionPlace) : insertionPlace.getParent().addRangeAfter(newImports.getFirstChild(), newImports.getLastChild(), insertionPlace);
                } else {
                    firstAdded = holder.addRange(newImports.getFirstChild(), newImports.getLastChild());
                }
                PsiElement lastAdded = firstAdded.getNextSibling();
                int count = fqnsToImport.size();
                if (count > 1) {
                    while (!(lastAdded instanceof JSImportStatement) || --count != 1) {
                        lastAdded = lastAdded.getNextSibling();
                    }
                }
                formatters.add(FormatFixer.create(firstAdded, lastAdded, FormatFixer.Mode.Reformat));
            }
            for (JSImportStatement statement : unusedImportsResults.getAllImports()) {
                formatters.add(0, FormatFixer.create((PsiElement)statement, FormatFixer.Mode.FollowingWhitespace));
                statement.delete();
            }
            for (JSReferenceExpression reference : unusedImportsResults.fqnsToReplaceWithShortName) {
                String name = StringUtil.getShortName((String)reference.getReferencedName());
                reference.replace(JSChangeUtil.createExpressionFromText(project, name).getPsi());
            }
            if (file instanceof XmlFile && JavaScriptSupportLoader.isFlexMxmFile(file)) {
                formatters.addAll(ECMAScriptImportOptimizer.deleteUnusedNamespaces((XmlFile)file));
            } else if (file instanceof JSFile) {
                PsiFile containingFile;
                PsiElement context = file.getContext();
                PsiFile psiFile = containingFile = context == null ? null : context.getContainingFile();
                if (containingFile instanceof XmlFile && JavaScriptSupportLoader.isFlexMxmFile(containingFile)) {
                    formatters.addAll(ECMAScriptImportOptimizer.deleteUnusedNamespaces((XmlFile)containingFile));
                }
            }
            return FormatFixer.mergeSingleFile(formatters);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return Collections.emptyList();
        }
    }

    private static List<FormatFixer> deleteUnusedNamespaces(XmlFile file) {
        ArrayList<FormatFixer> formatters = new ArrayList<FormatFixer>();
        XmlTag rootTag = file.getRootTag();
        if (rootTag != null) {
            for (XmlAttribute attribute : rootTag.getAttributes()) {
                String declaredPrefix;
                XmlRefCountHolder refCountHolder;
                String namespace;
                if (!attribute.isNamespaceDeclaration() || JavaScriptSupportLoader.isLanguageNamespace(namespace = attribute.getValue()) || (refCountHolder = XmlRefCountHolder.getRefCountHolder((XmlFile)file)) == null) continue;
                String string = declaredPrefix = attribute.getName().contains(":") ? attribute.getLocalName() : "";
                if (namespace == null || refCountHolder.isInUse(declaredPrefix)) continue;
                if (ECMAScriptImportOptimizer.isFirstAttributeWithTagStartAtTheSameLine(attribute)) {
                    JSRefactoringUtil.deleteSiblingWhitespace((PsiElement)attribute, false, true);
                }
                if (ECMAScriptImportOptimizer.isLastAttributeWithTagEndAtTheSameLine(attribute)) {
                    JSRefactoringUtil.deleteSiblingWhitespace((PsiElement)attribute, true, true);
                }
                attribute.delete();
                ASTNode tagEndNode = XmlChildRole.START_TAG_END_FINDER.findChild(rootTag.getNode());
                if (tagEndNode != null) {
                    formatters.add(FormatFixer.create((PsiFile)file, TextRange.create((int)rootTag.getTextRange().getStartOffset(), (int)tagEndNode.getTextRange().getEndOffset()), FormatFixer.Mode.Reformat));
                    continue;
                }
                formatters.add(FormatFixer.create((PsiElement)rootTag, FormatFixer.Mode.Reformat));
            }
        }
        return formatters;
    }

    private static boolean isLastAttributeWithTagEndAtTheSameLine(XmlAttribute attribute) {
        XmlAttribute sibling = attribute;
        while ((sibling = sibling.getNextSibling()) != null) {
            if (sibling instanceof XmlToken && (((XmlToken)sibling).getTokenType() == XmlTokenType.XML_TAG_END || ((XmlToken)sibling).getTokenType() == XmlTokenType.XML_EMPTY_ELEMENT_END)) {
                return true;
            }
            if (!(sibling instanceof PsiWhiteSpace)) {
                return false;
            }
            if (sibling.getText().indexOf(10) < 0) continue;
            return false;
        }
        return false;
    }

    private static boolean isFirstAttributeWithTagStartAtTheSameLine(XmlAttribute attribute) {
        XmlAttribute sibling = attribute;
        while ((sibling = sibling.getPrevSibling()) != null) {
            if (sibling instanceof XmlToken && ((XmlToken)sibling).getTokenType() == XmlTokenType.XML_NAME) {
                PsiElement prevSibling = sibling.getPrevSibling();
                return prevSibling instanceof XmlToken && ((XmlToken)prevSibling).getTokenType() == XmlTokenType.XML_START_TAG_START;
            }
            if (!(sibling instanceof PsiWhiteSpace)) {
                return false;
            }
            if (sibling.getText().indexOf(10) < 0) continue;
            return false;
        }
        return false;
    }
}

