/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flow;

import com.intellij.lang.javascript.dialects.JSLanguageLevel;
import com.intellij.lang.javascript.flow.FlowJSSettings;
import com.intellij.lang.javascript.settings.JSRootConfiguration;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Text;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="JsFlowSettings", storages={@Storage(value="$WORKSPACE_FILE$")})
public class FlowJSSettingsManager
implements PersistentStateComponent<Element> {
    private static final String ENABLED = "service-enabled";
    private static final String EXE_PATH = "exe-path";
    private static final String OTHER_SERVICES_ENABLED = "other-services-enabled";
    private static final String RESOLVE_ENABLE = "annotation-enable";
    private static final String AUTO_SAVE = "auto-save";
    private volatile FlowJSSettings myFlowSettings = FlowJSSettings.DEFAULT;

    @Nullable
    public Element getState() {
        FlowJSSettings settings = this.myFlowSettings;
        Element root = new Element("js-flow-settings");
        Element enabledElement = new Element(ENABLED);
        enabledElement.addContent((Content)new Text(Boolean.toString(settings.isTypeCheckingEnabled())));
        root.addContent(enabledElement);
        Element exePathElement = new Element(EXE_PATH);
        exePathElement.addContent((Content)new Text(settings.getFlowExecutablePath()));
        root.addContent(exePathElement);
        Element resolveEnableElement = new Element(RESOLVE_ENABLE);
        resolveEnableElement.addContent((Content)new Text(Boolean.toString(settings.isResolveByServerEnabled())));
        root.addContent(resolveEnableElement);
        Element otherServicesEnabled = new Element(OTHER_SERVICES_ENABLED);
        otherServicesEnabled.addContent((Content)new Text(Boolean.toString(settings.isOtherServicesEnabled())));
        root.addContent(otherServicesEnabled);
        Element autoSave = new Element(AUTO_SAVE);
        autoSave.addContent((Content)new Text(Boolean.toString(settings.isAutoSaveEnabled())));
        root.addContent(autoSave);
        return root;
    }

    public void loadState(Element state) {
        if (state != null) {
            Element autoSave;
            Element resolveEnable;
            Element otherServicesEnabled;
            Element enabledChild;
            String exePathText;
            FlowJSSettings.Builder builder = this.myFlowSettings.toBuilder();
            Element exePathElement = state.getChild(EXE_PATH);
            String string = exePathText = exePathElement != null ? exePathElement.getText() : null;
            if (exePathText != null) {
                builder.setFlowExecutablePath(exePathText);
            }
            if ((enabledChild = state.getChild(ENABLED)) != null) {
                builder.setTypeCheckingEnabled(Boolean.valueOf(enabledChild.getText()));
            }
            if ((otherServicesEnabled = state.getChild(OTHER_SERVICES_ENABLED)) != null) {
                builder.setOtherServicesEnabled(Boolean.valueOf(otherServicesEnabled.getText()));
            }
            if ((resolveEnable = state.getChild(RESOLVE_ENABLE)) != null) {
                builder.setFlowResolveEnable(Boolean.valueOf(resolveEnable.getText()));
            }
            if ((autoSave = state.getChild(AUTO_SAVE)) != null) {
                builder.setAutoSaveEnabled(Boolean.valueOf(autoSave.getText()));
            }
            this.myFlowSettings = builder.build();
        }
    }

    @NotNull
    public FlowJSSettings getRawSettings() {
        FlowJSSettings flowJSSettings = this.myFlowSettings;
        if (flowJSSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flow/FlowJSSettingsManager", "getRawSettings"));
        }
        return flowJSSettings;
    }

    public void setRawSettings(@NotNull FlowJSSettings flowSettings) {
        if (flowSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "flowSettings", "com/intellij/lang/javascript/flow/FlowJSSettingsManager", "setRawSettings"));
        }
        this.myFlowSettings = flowSettings;
    }

    public static boolean isTypeCheckingEnabled(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/flow/FlowJSSettingsManager", "isTypeCheckingEnabled"));
        }
        if (JSRootConfiguration.getInstance(project).getLanguageLevel() != JSLanguageLevel.FLOW) {
            return false;
        }
        FlowJSSettings settings = FlowJSSettingsManager.getInstance(project).getRawSettings();
        return !StringUtil.isEmpty((String)settings.getFlowExecutablePath()) && settings.isTypeCheckingEnabled();
    }

    @Nullable
    public static String getFlowExecutablePath(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/flow/FlowJSSettingsManager", "getFlowExecutablePath"));
        }
        if (!FlowJSSettingsManager.isTypeCheckingEnabled(project)) {
            return null;
        }
        return FlowJSSettingsManager.getInstance(project).getRawSettings().getFlowExecutablePath();
    }

    public static boolean areOtherServicesEnabled(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/flow/FlowJSSettingsManager", "areOtherServicesEnabled"));
        }
        return FlowJSSettingsManager.isTypeCheckingEnabled(project) && FlowJSSettingsManager.getInstance(project).getRawSettings().isOtherServicesEnabled();
    }

    public static boolean isResolveEnabled(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/flow/FlowJSSettingsManager", "isResolveEnabled"));
        }
        return FlowJSSettingsManager.isTypeCheckingEnabled(project) && FlowJSSettingsManager.getInstance(project).getRawSettings().isResolveByServerEnabled();
    }

    public static boolean isAutoSaveEnabled(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/flow/FlowJSSettingsManager", "isAutoSaveEnabled"));
        }
        return FlowJSSettingsManager.getInstance(project).getRawSettings().isAutoSaveEnabled();
    }

    public static FlowJSSettingsManager getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/flow/FlowJSSettingsManager", "getInstance"));
        }
        return (FlowJSSettingsManager)ServiceManager.getService((Project)project, FlowJSSettingsManager.class);
    }
}

