/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flow;

import com.intellij.execution.process.ProcessHandler;
import com.intellij.icons.AllIcons;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.flow.FlowJSServerManager;
import com.intellij.lang.javascript.flow.FlowJSServerService;
import com.intellij.lang.javascript.flow.ResendingOSProcessHandler;
import com.intellij.lang.javascript.integration.JSAnnotationError;
import com.intellij.lang.javascript.service.ui.JSLanguageServiceToolWindowManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import icons.JavaScriptLanguageIcons;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlowJSToolWindowProvider {
    @NotNull
    private final JSLanguageServiceToolWindowManager myToolWindow;

    @Nullable
    public static JSLanguageServiceToolWindowManager getToolWindow(Project project) {
        if (project == null || project.isDefault() || project.isDisposed()) {
            return null;
        }
        FlowJSToolWindowProvider provider = (FlowJSToolWindowProvider)ServiceManager.getService((Project)project, FlowJSToolWindowProvider.class);
        return provider == null ? null : provider.getToolWindow();
    }

    public FlowJSToolWindowProvider(final @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/flow/FlowJSToolWindowProvider", "<init>"));
        }
        AnAction restartAllServersAction = new AnAction(JSBundle.message((String)"js.flow.all.servers.action.restart", (Object[])new Object[0]), JSBundle.message((String)"js.flow.all.servers.action.restart", (Object[])new Object[0]), AllIcons.Javaee.UpdateRunningApplication){

            public void actionPerformed(AnActionEvent e) {
                FlowJSToolWindowProvider.this.getToolWindow().resetToolWindow();
                Collection<FlowJSServerService> servers = FlowJSServerManager.getInstance(project).getAllServers();
                for (FlowJSServerService server : servers) {
                    server.terminateStartedProcess(true);
                }
            }
        };
        AnAction checkAllFiles = new AnAction(JSBundle.message((String)"javascript.flow.error.panel.all.errors", (Object[])new Object[0]), JSBundle.message((String)"javascript.flow.error.panel.all.errors", (Object[])new Object[0]), JavaScriptLanguageIcons.Typescript.CompileCurrentFile1){

            public void actionPerformed(AnActionEvent e) {
                ApplicationManager.getApplication().executeOnPooledThread(() -> {
                    if (project == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/flow/FlowJSToolWindowProvider$2", "lambda$actionPerformed$3"));
                    }
                    FlowJSServerManager serverManager = FlowJSServerManager.getInstance(project);
                    if (serverManager != null) {
                        List results;
                        Collection<FlowJSServerService> servers = serverManager.getAllServers();
                        if (servers.size() == 1) {
                            results = ((FlowJSServerService)ContainerUtil.getFirstItem(servers)).getAllErrors();
                        } else {
                            List errorFutures = ContainerUtil.map(servers, server -> ApplicationManager.getApplication().executeOnPooledThread(() -> server.getAllErrors()));
                            results = ContainerUtil.newSmartList();
                            for (Future errorFuture : errorFutures) {
                                List errorsFromFuture = Collections.emptyList();
                                try {
                                    errorsFromFuture = (List)errorFuture.get();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                results.addAll(errorsFromFuture);
                            }
                        }
                        ApplicationManager.getApplication().invokeLater(() -> FlowJSToolWindowProvider.this.myToolWindow.logProjectErrors((ImmutableList<JSAnnotationError>)ContainerUtil.immutableList((List)results), true));
                    }
                });
            }
        };
        this.myToolWindow = new JSLanguageServiceToolWindowManager(project, "Flow", "reference.tool.windows.flow", JavaScriptLanguageIcons.Flowjs.Flow13, new AnAction[]{checkAllFiles, restartAllServersAction}){

            @Override
            public synchronized void connectToProcessHandler(@NotNull String serviceId, @NotNull ProcessHandler handler) {
                if (serviceId == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serviceId", "com/intellij/lang/javascript/flow/FlowJSToolWindowProvider$3", "connectToProcessHandler"));
                }
                if (handler == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/lang/javascript/flow/FlowJSToolWindowProvider$3", "connectToProcessHandler"));
                }
                ((ResendingOSProcessHandler)handler).stopAfterNextListenerAdded();
                super.connectToProcessHandler(serviceId, handler);
            }
        };
        Disposer.register((Disposable)project, (Disposable)this.myToolWindow);
    }

    @NotNull
    public JSLanguageServiceToolWindowManager getToolWindow() {
        JSLanguageServiceToolWindowManager jSLanguageServiceToolWindowManager = this.myToolWindow;
        if (jSLanguageServiceToolWindowManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flow/FlowJSToolWindowProvider", "getToolWindow"));
        }
        return jSLanguageServiceToolWindowManager;
    }
}

