/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flow;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ResendingOSProcessHandler
extends OSProcessHandler {
    private final List<Pair<ProcessEvent, Key>> myEventsToResend;
    private final ProcessListener myCapturingListener;
    private final ThreadLocal<Boolean> myStopAfterNextListenerAdded;

    public ResendingOSProcessHandler(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/intellij/lang/javascript/flow/ResendingOSProcessHandler", "<init>"));
        }
        super(commandLine);
        this.myEventsToResend = new ArrayList<Pair<ProcessEvent, Key>>();
        this.myStopAfterNextListenerAdded = new ThreadLocal();
        this.myCapturingListener = new ProcessAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onTextAvailable(ProcessEvent event, Key outputType) {
                List list = ResendingOSProcessHandler.this.myEventsToResend;
                synchronized (list) {
                    ResendingOSProcessHandler.this.myEventsToResend.add(Pair.create((Object)event, (Object)outputType));
                }
            }
        };
        this.addProcessListener(this.myCapturingListener);
    }

    public void stopAfterNextListenerAdded() {
        this.myStopAfterNextListenerAdded.set(Boolean.TRUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProcessListener(ProcessListener listener) {
        super.addProcessListener(listener);
        List<Pair<ProcessEvent, Key>> list = this.myEventsToResend;
        synchronized (list) {
            for (Pair<ProcessEvent, Key> pair : this.myEventsToResend) {
                listener.onTextAvailable((ProcessEvent)pair.first, (Key)pair.second);
            }
        }
        if (Boolean.TRUE.equals(this.myStopAfterNextListenerAdded.get())) {
            this.removeProcessListener(this.myCapturingListener);
            this.myEventsToResend.clear();
        }
    }
}

