/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flow.protocol;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.lang.javascript.flow.FlowJSSettingsManager;
import com.intellij.lang.javascript.flow.ResendingOSProcessHandler;
import com.intellij.lang.javascript.flow.flowconfig.FlowJSConfig;
import com.intellij.lang.javascript.flow.protocol.commands.FlowJSCommandWithArgument;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceAnswer;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceAnswerConsumer;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceCommand;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceObject;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceProtocol;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlowJSStandardOutputProtocol
implements JSLanguageServiceProtocol {
    private static final Logger LOGGER = Logger.getInstance((String)"#com.intellij.lang.javascript.flow.protocol.FlowJSStandardOutputProtocol");
    private static final String SERVER_IS_READY = "Server is READY";
    @NotNull
    protected final Project myProject;
    @NotNull
    private final FlowJSConfig myConfig;

    public FlowJSStandardOutputProtocol(@NotNull Project project, @NotNull FlowJSConfig config2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/flow/protocol/FlowJSStandardOutputProtocol", "<init>"));
        }
        if (config2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/intellij/lang/javascript/flow/protocol/FlowJSStandardOutputProtocol", "<init>"));
        }
        this.myProject = project;
        this.myConfig = config2;
    }

    @Override
    @Nullable
    public ProcessHandler connect() throws Exception {
        GeneralCommandLine line = new GeneralCommandLine().withWorkDirectory(this.myProject.getBasePath());
        String path = this.getServicePath();
        if (StringUtil.isEmpty((String)path)) {
            return null;
        }
        line.setExePath(path);
        line.addParameter("server");
        line.addParameter(this.myConfig.getConfigDirectory().getPath());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("OUT: " + line.toString());
        }
        ResendingOSProcessHandler handler = new ResendingOSProcessHandler(line);
        handler.startNotify();
        return handler;
    }

    @Override
    public boolean awaitReadyNotification(final @NotNull ProcessHandler processHandler) throws Exception {
        if (processHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processHandler", "com/intellij/lang/javascript/flow/protocol/FlowJSStandardOutputProtocol", "awaitReadyNotification"));
        }
        final CountDownLatch latch = new CountDownLatch(1);
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void onTextAvailable(ProcessEvent event, Key outputType) {
                String text = event.getText();
                if (text != null && text.contains(FlowJSStandardOutputProtocol.SERVER_IS_READY)) {
                    LOGGER.debug("IN: awaitReady received");
                    latch.countDown();
                    processHandler.removeProcessListener((ProcessListener)this);
                }
            }
        });
        return latch.await(3L, TimeUnit.MINUTES);
    }

    @Override
    public Object sendCommand(@NotNull JSLanguageServiceCommand command, @NotNull JSLanguageServiceObject data, @Nullable JSLanguageServiceAnswerConsumer resultConsumer) throws Exception {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/lang/javascript/flow/protocol/FlowJSStandardOutputProtocol", "sendCommand"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/lang/javascript/flow/protocol/FlowJSStandardOutputProtocol", "sendCommand"));
        }
        FlowJSCommandWithArgument commandWithArgument = (FlowJSCommandWithArgument)command;
        OSProcessHandler handler = this.write(commandWithArgument, resultConsumer);
        if (commandWithArgument.getInputStreamData() != null) {
            handler.getProcessInput().write(commandWithArgument.getInputStreamData().getBytes(CharsetToolkit.UTF8_CHARSET));
            handler.getProcessInput().close();
        }
        handler.startNotify();
        return handler;
    }

    @Override
    public void cancelCommand(@Nullable Object cancellationToken) {
        if (cancellationToken != null) {
            this.killProcess(cancellationToken);
        }
    }

    protected void killProcess(@NotNull Object handler) {
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/lang/javascript/flow/protocol/FlowJSStandardOutputProtocol", "killProcess"));
        }
        OSProcessHandler myHandler = (OSProcessHandler)handler;
        myHandler.destroyProcess();
    }

    @Override
    @Nullable
    public String getInitializeError() {
        return null;
    }

    public void dispose() {
        String path = this.getServicePath();
        if (StringUtil.isEmpty((String)path)) {
            return;
        }
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.setExePath(path);
        commandLine.withWorkDirectory(this.myProject.getBasePath());
        commandLine.addParameter("stop");
        try {
            commandLine.createProcess();
        }
        catch (ExecutionException e) {
            LOGGER.debug(e.getMessage(), (Throwable)e);
        }
    }

    private OSProcessHandler write(final @NotNull FlowJSCommandWithArgument commandWithArgument, final @Nullable JSLanguageServiceAnswerConsumer resultConsumer) throws Exception {
        if (commandWithArgument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandWithArgument", "com/intellij/lang/javascript/flow/protocol/FlowJSStandardOutputProtocol", "write"));
        }
        String path = this.getServicePath();
        if (StringUtil.isEmpty((String)path)) {
            return null;
        }
        GeneralCommandLine line = new GeneralCommandLine();
        line.setExePath(path);
        line.setWorkDirectory(commandWithArgument.getWorkingDirectory());
        line.addParameter(commandWithArgument.getCommand());
        commandWithArgument.getArguments().forEach(arg_0 -> ((GeneralCommandLine)line).addParameter(arg_0));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("OUT: " + line.toString());
        }
        OSProcessHandler handler = new OSProcessHandler(line);
        final StringBuilder resultJson = new StringBuilder();
        handler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void onTextAvailable(ProcessEvent event, Key outputType) {
                if (outputType == ProcessOutputTypes.STDOUT) {
                    JsonElement element;
                    String text = event.getText();
                    resultJson.append(text);
                    if (resultConsumer != null && (element = FlowJSStandardOutputProtocol.parseJsonSafe(resultJson.toString())) != null) {
                        resultConsumer.consume(new JSLanguageServiceAnswer(element));
                    }
                } else if (outputType == ProcessOutputTypes.STDERR) {
                    int end;
                    int start;
                    String text = event.getText();
                    for (start = 0; start < text.length() && Character.isWhitespace(text.charAt(start)); ++start) {
                    }
                    for (end = text.length(); end > 0 && Character.isWhitespace(end - 1); --end) {
                    }
                    if (start < end) {
                        LOGGER.warn("Error output from " + commandWithArgument.getCommand() + ": " + text.substring(start, end));
                    }
                }
            }
        });
        return handler;
    }

    @Nullable
    public static JsonElement parseJsonSafe(@NotNull String string) {
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "com/intellij/lang/javascript/flow/protocol/FlowJSStandardOutputProtocol", "parseJsonSafe"));
        }
        try {
            return new JsonParser().parse(string);
        }
        catch (JsonSyntaxException e) {
            return null;
        }
    }

    @NotNull
    private String getServicePath() {
        String string = FlowJSSettingsManager.getInstance(this.myProject).getRawSettings().getFlowExecutablePath();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flow/protocol/FlowJSStandardOutputProtocol", "getServicePath"));
        }
        return string;
    }
}

