/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.formatter;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.FormattingMode;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.formatter.FormattableInjectedBlockInJS;
import com.intellij.lang.javascript.formatter.JSBinaryExpressionBlock;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.formatter.JSFormatterUtil;
import com.intellij.lang.javascript.formatter.blocks.JSBlock;
import com.intellij.lang.javascript.formatter.blocks.JSBlockEx;
import com.intellij.lang.javascript.formatter.blocks.JSParameterBlock;
import com.intellij.lang.javascript.formatter.blocks.JSParameterListBlock;
import com.intellij.lang.javascript.formatter.blocks.SubBlockVisitor;
import com.intellij.lang.javascript.formatter.blocks.alignment.ASTNodeBasedAlignmentFactory;
import com.intellij.lang.javascript.inject.JSFormattableInjectionUtil;
import com.intellij.lang.javascript.psi.e4x.impl.JSXmlLiteralExpressionImpl;
import com.intellij.lang.typescript.formatter.blocks.TypedJSBlock;
import com.intellij.lang.typescript.formatter.blocks.TypedJSParameterBlock;
import com.intellij.lang.typescript.formatter.blocks.TypedJSParameterListBlock;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.formatter.xml.XmlFormattingPolicy;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.webcore.formatter.chainedMethods.CallChainDotBlock;
import com.intellij.xml.template.formatter.TemplateFormatUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSBlockContext {
    private final CommonCodeStyleSettings myCommonSettings;
    private CodeStyleSettings myTopSettings;
    private Language myDialect;
    @Nullable
    private XmlFormattingPolicy myPolicy;
    private JSCodeStyleSettings myDialectSettings;
    @NotNull
    private final FormattingMode myFormattingMode;

    public JSBlockContext(@NotNull CodeStyleSettings topSettings, @NotNull Language dialect, @Nullable JSCodeStyleSettings explicitSettings, @NotNull FormattingMode formattingMode) {
        if (topSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topSettings", "com/intellij/lang/javascript/formatter/JSBlockContext", "<init>"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/lang/javascript/formatter/JSBlockContext", "<init>"));
        }
        if (formattingMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formattingMode", "com/intellij/lang/javascript/formatter/JSBlockContext", "<init>"));
        }
        this.myTopSettings = topSettings;
        this.myFormattingMode = formattingMode;
        this.myDialectSettings = explicitSettings != null ? explicitSettings : (JSCodeStyleSettings)topSettings.getCustomSettings(JSCodeStyleSettings.getSettingsClass(dialect));
        this.myCommonSettings = topSettings.getCommonSettings(dialect);
        this.myDialect = dialect;
    }

    public void setXmlFormattingPolicy(XmlFormattingPolicy xmlFormattingPolicy) {
        this.myPolicy = xmlFormattingPolicy;
    }

    @NotNull
    public static JSBlockContext createDefault(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/javascript/formatter/JSBlockContext", "createDefault"));
        }
        JSBlockContext jSBlockContext = new JSBlockContext(settings, (Language)JavascriptLanguage.INSTANCE, null, FormattingMode.REFORMAT);
        if (jSBlockContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/formatter/JSBlockContext", "createDefault"));
        }
        return jSBlockContext;
    }

    @NotNull
    public FormattingMode getFormattingMode() {
        FormattingMode formattingMode = this.myFormattingMode;
        if (formattingMode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/formatter/JSBlockContext", "getFormattingMode"));
        }
        return formattingMode;
    }

    public CodeStyleSettings getTopSettings() {
        return this.myTopSettings;
    }

    public Language getDialect() {
        return this.myDialect;
    }

    public JSCodeStyleSettings getDialectSettings() {
        return this.myDialectSettings;
    }

    public CommonCodeStyleSettings getCommonSettings() {
        return this.myCommonSettings;
    }

    @NotNull
    public Block createBlock(@NotNull ASTNode child, @Nullable Wrap wrap, @Nullable Alignment childAlignment, @Nullable Indent childIndent, @Nullable ASTNodeBasedAlignmentFactory alignmentFactory, @Nullable JSBlock parentBlock) {
        Object block;
        Wrap childWrap;
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/lang/javascript/formatter/JSBlockContext", "createBlock"));
        }
        Wrap wrap2 = childWrap = parentBlock != null ? parentBlock.createChildWrap(child) : null;
        if (child instanceof JSXmlLiteralExpressionImpl && this.myPolicy != null) {
            block = new SubBlockVisitor.JSXmlTagBlock(child, wrap, childAlignment, this.myPolicy, childIndent, parentBlock);
        } else if (child.getElementType() == JSStubElementTypes.STRING_TEMPLATE_EXPRESSION && parentBlock != null && parentBlock.processInjections() && JSFormattableInjectionUtil.hostContainsFormattableInjection(child.getPsi())) {
            block = new FormattableInjectedBlockInJS(child, childAlignment, childIndent, wrap, this.myTopSettings);
        } else {
            Block outerLangBlock;
            Block block2 = outerLangBlock = child.getPsi() instanceof OuterLanguageElement ? TemplateFormatUtil.buildTemplateLanguageBlock((OuterLanguageElement)((OuterLanguageElement)child.getPsi()), (CodeStyleSettings)this.myTopSettings, (Indent)childIndent) : null;
            if (outerLangBlock != null) {
                block = outerLangBlock;
            } else {
                JSBlock childBlock = this.createSubBlock(child, childAlignment, childIndent, wrap, alignmentFactory);
                childBlock.setChildWrap(childWrap);
                block = childBlock;
            }
        }
        SubBlockVisitor.JSXmlTagBlock jSXmlTagBlock = block;
        if (jSXmlTagBlock == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/formatter/JSBlockContext", "createBlock"));
        }
        return jSXmlTagBlock;
    }

    @NotNull
    protected JSBlock createSubBlock(@NotNull ASTNode child, Alignment childAlignment, Indent childIndent, Wrap wrap, ASTNodeBasedAlignmentFactory sharedAlignmentFactory) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/lang/javascript/formatter/JSBlockContext", "createSubBlock"));
        }
        IElementType childType = child.getElementType();
        if (childType == JSElementTypes.BINARY_EXPRESSION && JSBlockContext.indentBinaryAsBlock(child)) {
            JSBinaryExpressionBlock jSBinaryExpressionBlock = new JSBinaryExpressionBlock(child, childAlignment, wrap, sharedAlignmentFactory, this);
            if (jSBinaryExpressionBlock == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/formatter/JSBlockContext", "createSubBlock"));
            }
            return jSBinaryExpressionBlock;
        }
        if (childType == JSElementTypes.ARGUMENT_LIST) {
            JSBlock jSBlock = this.createParameterListBLock(child, childAlignment, childIndent, wrap, sharedAlignmentFactory);
            if (jSBlock == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/formatter/JSBlockContext", "createSubBlock"));
            }
            return jSBlock;
        }
        ASTNode parent = child.getTreeParent();
        if (parent != null) {
            IElementType parentType = parent.getElementType();
            if (parentType == JSElementTypes.ARGUMENT_LIST) {
                if (childType != JSTokenTypes.LPAR && (childType != JSTokenTypes.RPAR || JSFormatterUtil.isEnterAtNewArgument(this.myFormattingMode, child)) && childType != JSTokenTypes.COMMA) {
                    JSBlock jSBlock = this.createParameterBlock(child, childAlignment, childIndent, wrap, sharedAlignmentFactory);
                    if (jSBlock == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/formatter/JSBlockContext", "createSubBlock"));
                    }
                    return jSBlock;
                }
            } else if (parentType == JSElementTypes.REFERENCE_EXPRESSION && childType == JSTokenTypes.DOT) {
                JSDotBlock jSDotBlock = new JSDotBlock(child, childAlignment, childIndent, wrap, sharedAlignmentFactory, this);
                if (jSDotBlock == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/formatter/JSBlockContext", "createSubBlock"));
                }
                return jSDotBlock;
            }
        }
        JSBlock jSBlock = this.createJSSubBlock(child, childAlignment, childIndent, wrap, sharedAlignmentFactory);
        if (jSBlock == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/formatter/JSBlockContext", "createSubBlock"));
        }
        return jSBlock;
    }

    private static boolean indentBinaryAsBlock(@NotNull ASTNode child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/lang/javascript/formatter/JSBlockContext", "indentBinaryAsBlock"));
        }
        ASTNode parent = child.getTreeParent();
        if (parent == null) {
            return false;
        }
        IElementType parentElementType = parent.getElementType();
        return parentElementType == JSStubElementTypes.RETURN_STATEMENT || parentElementType == JSElementTypes.ARGUMENT_LIST || parentElementType == JSElementTypes.PARENTHESIZED_EXPRESSION && !SubBlockVisitor.shouldIndentParenthesized(parent) || parentElementType == JSStubElementTypes.ASSIGNMENT_EXPRESSION || JSElementTypes.FUNCTION_EXPRESSIONS.contains(parentElementType) || JSElementTypes.BODY_VARIABLES.contains(parentElementType) || parentElementType == JSElementTypes.CONDITIONAL_EXPRESSION && child != parent.getFirstChildNode();
    }

    @NotNull
    private JSBlock createParameterListBLock(@NotNull ASTNode child, Alignment childAlignment, Indent childIndent, Wrap wrap, @Nullable ASTNodeBasedAlignmentFactory sharedAlignmentFactory) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/lang/javascript/formatter/JSBlockContext", "createParameterListBLock"));
        }
        if (JSBlockContext.isTypedJSDialect(this.myDialect)) {
            TypedJSParameterListBlock typedJSParameterListBlock = new TypedJSParameterListBlock(child, childAlignment, childIndent, wrap, sharedAlignmentFactory, this);
            if (typedJSParameterListBlock == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/formatter/JSBlockContext", "createParameterListBLock"));
            }
            return typedJSParameterListBlock;
        }
        JSParameterListBlock jSParameterListBlock = new JSParameterListBlock(child, childAlignment, childIndent, wrap, sharedAlignmentFactory, this);
        if (jSParameterListBlock == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/formatter/JSBlockContext", "createParameterListBLock"));
        }
        return jSParameterListBlock;
    }

    @NotNull
    private JSBlock createParameterBlock(@NotNull ASTNode child, Alignment childAlignment, Indent childIndent, Wrap wrap, @Nullable ASTNodeBasedAlignmentFactory sharedAlignmentFactory) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/lang/javascript/formatter/JSBlockContext", "createParameterBlock"));
        }
        if (JSBlockContext.isTypedJSDialect(this.myDialect)) {
            TypedJSParameterBlock typedJSParameterBlock = new TypedJSParameterBlock(child, childAlignment, childIndent, wrap, sharedAlignmentFactory, this);
            if (typedJSParameterBlock == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/formatter/JSBlockContext", "createParameterBlock"));
            }
            return typedJSParameterBlock;
        }
        JSParameterBlock jSParameterBlock = new JSParameterBlock(child, childAlignment, childIndent, wrap, sharedAlignmentFactory, this);
        if (jSParameterBlock == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/formatter/JSBlockContext", "createParameterBlock"));
        }
        return jSParameterBlock;
    }

    @NotNull
    private JSBlock createJSSubBlock(@NotNull ASTNode child, Alignment childAlignment, Indent childIndent, Wrap wrap, @Nullable ASTNodeBasedAlignmentFactory sharedAlignmentFactory) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/lang/javascript/formatter/JSBlockContext", "createJSSubBlock"));
        }
        if (JSBlockContext.isTypedJSDialect(this.myDialect)) {
            TypedJSBlock typedJSBlock = new TypedJSBlock(child, childAlignment, childIndent, wrap, sharedAlignmentFactory, this);
            if (typedJSBlock == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/formatter/JSBlockContext", "createJSSubBlock"));
            }
            return typedJSBlock;
        }
        JSBlockEx jSBlockEx = new JSBlockEx(child, childAlignment, childIndent, wrap, sharedAlignmentFactory, this);
        if (jSBlockEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/formatter/JSBlockContext", "createJSSubBlock"));
        }
        return jSBlockEx;
    }

    private static boolean isTypedJSDialect(@NotNull Language dialect) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/lang/javascript/formatter/JSBlockContext", "isTypedJSDialect"));
        }
        return dialect == JavaScriptSupportLoader.FLOW_JS || dialect.isKindOf((Language)JavaScriptSupportLoader.TYPESCRIPT);
    }

    private static class JSDotBlock
    extends JSBlockEx
    implements CallChainDotBlock {
        public JSDotBlock(@NotNull ASTNode node, @Nullable Alignment alignment, @Nullable Indent indent, @Nullable Wrap wrap, @Nullable ASTNodeBasedAlignmentFactory sharedAlignmentFactory, @NotNull JSBlockContext jsBlockContext) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/formatter/JSBlockContext$JSDotBlock", "<init>"));
            }
            if (jsBlockContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsBlockContext", "com/intellij/lang/javascript/formatter/JSBlockContext$JSDotBlock", "<init>"));
            }
            super(node, alignment, indent, wrap, sharedAlignmentFactory, jsBlockContext);
        }
    }
}

