/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.formatter;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.formatter.JSCodeStyleConfigurable;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.openapi.options.Configurable;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsProvider;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.codeStyle.DisplayPriority;
import com.intellij.util.PlatformUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSCodeStyleSettingsProvider
extends CodeStyleSettingsProvider {
    public CustomCodeStyleSettings createCustomSettings(CodeStyleSettings settings) {
        return new JSCodeStyleSettings(settings);
    }

    @NotNull
    public Configurable createSettingsPage(CodeStyleSettings settings, CodeStyleSettings originalSettings) {
        JSCodeStyleConfigurable jSCodeStyleConfigurable = new JSCodeStyleConfigurable(settings, originalSettings);
        if (jSCodeStyleConfigurable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/formatter/JSCodeStyleSettingsProvider", "createSettingsPage"));
        }
        return jSCodeStyleConfigurable;
    }

    @Nullable
    public Language getLanguage() {
        return JavascriptLanguage.INSTANCE;
    }

    public DisplayPriority getPriority() {
        return PlatformUtils.isWebStorm() ? DisplayPriority.KEY_LANGUAGE_SETTINGS : DisplayPriority.LANGUAGE_SETTINGS;
    }
}

