/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.formatter;

import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.application.options.codeStyle.arrangement.ArrangementSettingsPanel;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JavaScriptFileType;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.formatter.ES6CodeStyleImportsPanel;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.formatter.JSDerivedLanguageCodeStyleMainPanel;
import com.intellij.lang.javascript.formatter.JSGeneratedCodeStylePanel;
import com.intellij.lang.javascript.formatter.punctuation.JSCodeStylePunctuationPanel;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaScriptCodeStyleMainPanel
extends JSDerivedLanguageCodeStyleMainPanel {
    protected JavaScriptCodeStyleMainPanel(CodeStyleSettings currentSettings, CodeStyleSettings settings) {
        super((Language)JavascriptLanguage.INSTANCE, currentSettings, settings);
    }

    protected void initTabs(CodeStyleSettings settings) {
        super.initTabs(settings);
        JavascriptLanguage dialect = JavascriptLanguage.INSTANCE;
        final JavaScriptFileType fileType = JavaScriptFileType.INSTANCE;
        this.addTab(new JSCodeStylePunctuationPanel((Language)dialect, settings, true){

            @Override
            @NotNull
            protected FileType getFileType() {
                JavaScriptFileType javaScriptFileType = fileType;
                if (javaScriptFileType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/formatter/JavaScriptCodeStyleMainPanel$1", "getFileType"));
                }
                return javaScriptFileType;
            }
        });
        this.addTab(new JSGeneratedCodeStylePanel((Language)dialect, settings, false){

            @Override
            @NotNull
            protected FileType getFileType() {
                JavaScriptFileType javaScriptFileType = fileType;
                if (javaScriptFileType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/formatter/JavaScriptCodeStyleMainPanel$2", "getFileType"));
                }
                return javaScriptFileType;
            }
        });
        ES6CodeStyleImportsPanel panel = new ES6CodeStyleImportsPanel(JSCodeStyleSettings.class);
        this.addTab(ES6CodeStyleImportsPanel.getImportsCodeStylePanel(settings, (FileType)fileType, panel));
        this.addTab((CodeStyleAbstractPanel)new ArrangementSettingsPanel(settings, (Language)dialect){

            protected int getRightMargin() {
                return 80;
            }

            @NotNull
            protected FileType getFileType() {
                JavaScriptFileType javaScriptFileType = fileType;
                if (javaScriptFileType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/formatter/JavaScriptCodeStyleMainPanel$3", "getFileType"));
                }
                return javaScriptFileType;
            }

            @Nullable
            protected String getPreviewText() {
                return null;
            }
        });
    }
}

