/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.gcl;

import com.intellij.lang.javascript.frameworks.gcl.JSGclModulesIndex;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElementStructure;
import com.intellij.psi.stubs.IndexSink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSGclIndexingHandler
extends FrameworkIndexingHandler {
    private static final String GCL_MODULE_USER_STRING = "gcl";

    public static String getGclModuleUserString() {
        return GCL_MODULE_USER_STRING;
    }

    @Override
    public boolean indexImplicitElement(@NotNull JSImplicitElementStructure element, @Nullable IndexSink sink) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/frameworks/gcl/JSGclIndexingHandler", "indexImplicitElement"));
        }
        if (sink == null) {
            return false;
        }
        String qualifiedName = element.getQualifiedName();
        if (GCL_MODULE_USER_STRING.equals(element.getUserString()) && qualifiedName != null) {
            sink.occurrence(JSGclModulesIndex.KEY, (Object)qualifiedName);
        }
        return false;
    }

    static {
        JSImplicitElement.ourUserStringsRegistry.registerUserString(GCL_MODULE_USER_STRING);
    }
}

