/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.gcl;

import com.intellij.lang.javascript.frameworks.gcl.JSGclModuleReference;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.impl.JSReferenceSet;
import com.intellij.lang.javascript.psi.impl.JSReferenceSetElement;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSGclReferenceContributor
extends PsiReferenceContributor {
    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/lang/javascript/frameworks/gcl/JSGclReferenceContributor", "registerReferenceProviders"));
        }
        registrar.registerReferenceProvider((ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement(JSLiteralExpression.class).withParent(JSArgumentList.class)).withSuperParent(2, (ElementPattern)PlatformPatterns.psiElement(JSCallExpression.class).with((PatternCondition)new PatternCondition<JSCallExpression>("goog.require"){

            public boolean accepts(@NotNull JSCallExpression expression, ProcessingContext context) {
                if (expression == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/javascript/frameworks/gcl/JSGclReferenceContributor$2", "accepts"));
                }
                return JSGclReferenceContributor.isGoogRequireCall(expression.getMethodExpression());
            }
        })), new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/frameworks/gcl/JSGclReferenceContributor$1", "getReferencesByElement"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/frameworks/gcl/JSGclReferenceContributor$1", "getReferencesByElement"));
                }
                JSReferenceSet set = new JSReferenceSet(element){

                    @Override
                    protected JSReferenceSetElement createTextReference(String s, int offset, boolean methodRef) {
                        boolean isLast = this.myReferenceText.indexOf(46, offset) == -1;
                        return isLast ? new JSGclModuleReference((JSReferenceSet)this, s, offset) : super.createTextReference(s, offset, false);
                    }
                };
                set.update(element.getText(), 0);
                PsiReference[] psiReferenceArray = set.getReferences();
                if (psiReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/gcl/JSGclReferenceContributor$1", "getReferencesByElement"));
                }
                return psiReferenceArray;
            }
        });
    }

    public static boolean isGoogRequireCall(@Nullable JSExpression methodExpression) {
        return JSSymbolUtil.isAccurateReferenceExpressionName(methodExpression, "goog", "require") || JSSymbolUtil.isAccurateReferenceExpressionName(methodExpression, "goog", "module", "get");
    }
}

