/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.modules;

import com.intellij.javascript.JSFileReference;
import com.intellij.javascript.nodejs.CompletionModuleInfo;
import com.intellij.javascript.nodejs.ModuleType;
import com.intellij.javascript.nodejs.reference.NodeFileModulePsiReferenceBase;
import com.intellij.lang.javascript.completion.JSCompletionUtil;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PsiFileSystemItemUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class JSModuleReferenceBase
extends JSFileReference {
    public JSModuleReferenceBase(String text, int offset, TextRange textRange, @NotNull FileReferenceSet fileReferenceSet) {
        if (fileReferenceSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileReferenceSet", "com/intellij/lang/javascript/frameworks/modules/JSModuleReferenceBase", "<init>"));
        }
        super(text, offset, textRange, fileReferenceSet);
    }

    public JSModuleReferenceBase(String text, int offset, TextRange textRange, @NotNull FileReferenceSet fileReferenceSet, String[] implicitExtensions) {
        if (fileReferenceSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileReferenceSet", "com/intellij/lang/javascript/frameworks/modules/JSModuleReferenceBase", "<init>"));
        }
        super(text, offset, textRange, fileReferenceSet, implicitExtensions);
    }

    protected Object createLookupItem(PsiElement candidate) {
        PsiDirectory directory;
        PsiDirectory parentDirectory;
        if (candidate instanceof PsiDirectory && (parentDirectory = (directory = (PsiDirectory)candidate).getParent()) != null && "node_modules".equals(parentDirectory.getName())) {
            VirtualFile context = PsiUtilCore.getVirtualFile((PsiElement)this.getElement());
            CompletionModuleInfo module = new CompletionModuleInfo(directory.getName(), directory.getVirtualFile(), ModuleType.NODE_MODULES_DIR);
            return NodeFileModulePsiReferenceBase.createLookupElement(context, module);
        }
        return JSCompletionUtil.createLookupElementForJSModule(candidate);
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/frameworks/modules/JSModuleReferenceBase", "bindToElement"));
        }
        PsiElement psiElement = this.processBindFromExtendedCompletion(element);
        if (psiElement != null) {
            return psiElement;
        }
        return super.bindToElement(element);
    }

    protected PsiElement processBindFromExtendedCompletion(@NotNull PsiElement element) {
        PsiFile contextFile;
        String path;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/frameworks/modules/JSModuleReferenceBase", "processBindFromExtendedCompletion"));
        }
        if (!this.isExtendedCompletion(element)) {
            return null;
        }
        PsiElement context = this.getElement();
        if (JSCodeStyleSettings.isUseAbsolutePath(context)) {
            String path2 = JSModuleReferenceBase.getPathFromDefaultContext(this.getFileReferenceSet(), element, false);
            if (path2 != null) {
                return this.trimPathExtension(path2);
            }
        } else if (element instanceof PsiFile && (path = PsiFileSystemItemUtil.getRelativePath((PsiFileSystemItem)(contextFile = context.getContainingFile()), (PsiFileSystemItem)((PsiFile)element))) != null) {
            return this.trimPathExtension(path.startsWith(".") ? path : "./" + path);
        }
        return null;
    }

    private PsiElement trimPathExtension(String path) {
        String[] extensions = this.getSortedByLengthImplicitExtensions();
        String extension = JSFileReference.findExtension(path, extensions);
        return this.rename(extension == null ? path : path.substring(0, path.length() - extension.length()));
    }

    private boolean isExtendedCompletion(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/frameworks/modules/JSModuleReferenceBase", "isExtendedCompletion"));
        }
        if (!(element instanceof PsiFile)) {
            return false;
        }
        PsiFile psiFile = (PsiFile)element;
        FileReferenceSet referenceSet = this.getFileReferenceSet();
        String pathString = referenceSet.getPathString();
        if (!StringUtil.equals((CharSequence)pathString, (CharSequence)psiFile.getName())) {
            return false;
        }
        Object[] types = referenceSet.getSuitableFileTypes();
        return types == FileType.EMPTY_ARRAY || ArrayUtil.contains((Object)psiFile.getFileType(), (Object[])types);
    }
}

