/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.react;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.frameworks.react.ReactXmlElementDescriptor;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.resolve.ES6QualifiedNameResolver;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveType;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSXPropTypesUtil {
    public static final String PROPS_IS_REQUIRED_NAME = "isRequired";

    @NotNull
    public static JSRecordType convertFlowRecordType(@NotNull JSRecordType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/frameworks/react/JSXPropTypesUtil", "convertFlowRecordType"));
        }
        PsiElement element = type.getSource().getSourceElement();
        DialectOptionHolder holder = DialectDetector.dialectOfElement(element);
        if (holder == null || !holder.isFlow) {
            JSRecordType jSRecordType = type;
            if (jSRecordType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/react/JSXPropTypesUtil", "convertFlowRecordType"));
            }
            return jSRecordType;
        }
        List members = type.getTypeMembers();
        List<JSRecordType.TypeMember> newMembers = members.stream().map(member -> {
            if (!(member instanceof JSRecordType.PropertySignature)) {
                return member;
            }
            return JSXPropTypesUtil.convertSignature((JSRecordType.PropertySignature)member);
        }).collect(Collectors.toList());
        JSRecordTypeImpl jSRecordTypeImpl = new JSRecordTypeImpl(type.getSource(), newMembers);
        if (jSRecordTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/react/JSXPropTypesUtil", "convertFlowRecordType"));
        }
        return jSRecordTypeImpl;
    }

    @NotNull
    private static JSRecordType.PropertySignature convertSignature(@NotNull JSRecordType.PropertySignature member) {
        String typeName;
        String parsedType;
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/lang/javascript/frameworks/react/JSXPropTypesUtil", "convertSignature"));
        }
        if (member.getSource() instanceof JSImplicitElementImpl) {
            JSRecordType.PropertySignature propertySignature = member;
            if (propertySignature == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/react/JSXPropTypesUtil", "convertSignature"));
            }
            return propertySignature;
        }
        JSType type = member.getType();
        if (type instanceof JSPrimitiveType) {
            JSRecordType.PropertySignature propertySignature = member;
            if (propertySignature == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/react/JSXPropTypesUtil", "convertSignature"));
            }
            return propertySignature;
        }
        if (!(type instanceof JSNamedType)) {
            JSRecordTypeImpl.PropertySignatureImpl propertySignatureImpl = JSXPropTypesUtil.wrapAsOptional(member, type);
            if (propertySignatureImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/react/JSXPropTypesUtil", "convertSignature"));
            }
            return propertySignatureImpl;
        }
        boolean isOptional = true;
        JSType newReturnType = type;
        Object source = member.getSource();
        String text = type.getTypeText();
        List elements = StringUtil.split((String)text, (String)".");
        if (elements.size() == 1) {
            JSRecordType.PropertySignature propertySignature = member;
            if (propertySignature == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/react/JSXPropTypesUtil", "convertSignature"));
            }
            return propertySignature;
        }
        String lastItem = (String)ContainerUtil.getLastItem((List)elements);
        if (PROPS_IS_REQUIRED_NAME.equals(lastItem)) {
            isOptional = false;
            elements = elements.subList(0, elements.size() - 1);
        }
        if ((parsedType = JSXPropTypesUtil.parseType(typeName = (String)ContainerUtil.getLastItem((List)elements))) != null) {
            newReturnType = JSNamedType.createType(parsedType, type.getSource(), ((JSNamedType)type).getTypeContext());
            PsiElement provider = source != null ? source : type.getSource().getSourceElement();
            JSImplicitElementImpl.Builder propsBuilder = new JSImplicitElementImpl.Builder(member.getMemberName(), provider).setTypeString(parsedType).setType(JSImplicitElement.Type.Property);
            if (!isOptional) {
                propsBuilder = propsBuilder.setUserString("r");
            }
            source = propsBuilder.toImplicitElement();
        }
        JSRecordTypeImpl.PropertySignatureImpl propertySignatureImpl = new JSRecordTypeImpl.PropertySignatureImpl(member.getMemberName(), newReturnType, isOptional, (PsiElement)source);
        if (propertySignatureImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/react/JSXPropTypesUtil", "convertSignature"));
        }
        return propertySignatureImpl;
    }

    @NotNull
    private static JSRecordTypeImpl.PropertySignatureImpl wrapAsOptional(@NotNull JSRecordType.PropertySignature member, JSType type) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/lang/javascript/frameworks/react/JSXPropTypesUtil", "wrapAsOptional"));
        }
        JSRecordTypeImpl.PropertySignatureImpl propertySignatureImpl = new JSRecordTypeImpl.PropertySignatureImpl(member.getMemberName(), type, true);
        if (propertySignatureImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/react/JSXPropTypesUtil", "wrapAsOptional"));
        }
        return propertySignatureImpl;
    }

    @NotNull
    public static Stream<JSPsiElementBase> resolveNamespacePropTypes(@NotNull ReactXmlElementDescriptor.NamespaceInfo namespaceInfo, @NotNull GlobalSearchScope scope) {
        if (namespaceInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespaceInfo", "com/intellij/lang/javascript/frameworks/react/JSXPropTypesUtil", "resolveNamespacePropTypes"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/javascript/frameworks/react/JSXPropTypesUtil", "resolveNamespacePropTypes"));
        }
        String namespace = namespaceInfo.getNamespace().replace(".props", ".propTypes");
        Collection<JSPsiElementBase> elements = JSClassResolver.getInstance().findElementsByQNameIncludingImplicit(namespace, scope);
        for (JSPsiElementBase element : elements) {
            String reference;
            if (!(element instanceof JSDefinitionExpression)) continue;
            PsiElement meaningfulElement = JSStubBasedPsiTreeUtil.calculateMeaningfulElement((PsiElement)element);
            if (meaningfulElement instanceof JSDefinitionExpression && !StringUtil.isEmptyOrSpaces((String)(reference = ((JSDefinitionExpression)meaningfulElement).getInitializerReference()))) {
                Collection<PsiElement> resolvedElements = new ES6QualifiedNameResolver(meaningfulElement).resolveQualifiedName(reference);
                meaningfulElement = (PsiElement)ContainerUtil.getFirstItem(resolvedElements);
            }
            if (meaningfulElement instanceof JSVariable) {
                meaningfulElement = ((JSVariable)meaningfulElement).getInitializerOrStub();
            }
            if (!(meaningfulElement instanceof JSObjectLiteralExpression)) continue;
            Stream<JSPsiElementBase> stream = JSXPropTypesUtil.convertObjectLiteralToPropsType((JSObjectLiteralExpression)meaningfulElement);
            if (stream == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/react/JSXPropTypesUtil", "resolveNamespacePropTypes"));
            }
            return stream;
        }
        Stream<JSPsiElementBase> stream = Stream.empty();
        if (stream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/react/JSXPropTypesUtil", "resolveNamespacePropTypes"));
        }
        return stream;
    }

    @NotNull
    private static Stream<JSPsiElementBase> convertObjectLiteralToPropsType(@NotNull JSObjectLiteralExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/javascript/frameworks/react/JSXPropTypesUtil", "convertObjectLiteralToPropsType"));
        }
        JSProperty[] properties = expression.getProperties();
        if (properties.length == 0) {
            Stream<JSPsiElementBase> stream = Stream.empty();
            if (stream == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/react/JSXPropTypesUtil", "convertObjectLiteralToPropsType"));
            }
            return stream;
        }
        Stream<JSPsiElementBase> stream = Arrays.stream(properties).filter(el -> el.getName() != null).map(property -> {
            Collection elements;
            JSElementIndexingData data = property.getIndexingData();
            if (data != null && (elements = data.getImplicitElements()) != null) {
                for (JSImplicitElement element : elements) {
                    if (!element.getQualifiedName().endsWith("props." + element.getName())) continue;
                    return element;
                }
            }
            String name = property.getName();
            assert (name != null);
            return JSXPropTypesUtil.createSimpleImplicitElement(property, JSQualifiedNameImpl.fromQualifiedName(name)).toImplicitElement();
        });
        if (stream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/react/JSXPropTypesUtil", "convertObjectLiteralToPropsType"));
        }
        return stream;
    }

    @NotNull
    public static JSImplicitElementImpl createImplicitReactPropsElement(@NotNull JSProperty property, @NotNull JSQualifiedNameImpl prop) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/lang/javascript/frameworks/react/JSXPropTypesUtil", "createImplicitReactPropsElement"));
        }
        if (prop == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prop", "com/intellij/lang/javascript/frameworks/react/JSXPropTypesUtil", "createImplicitReactPropsElement"));
        }
        JSImplicitElementImpl.Builder propBuilder = JSXPropTypesUtil.createSimpleImplicitElement(property, prop).setTypeString(JSXPropTypesUtil.computeType(property.getValue()));
        if (JSXPropTypesUtil.isRequired(property.getValue())) {
            propBuilder.setUserString("r");
        }
        JSImplicitElementImpl jSImplicitElementImpl = propBuilder.toImplicitElement();
        if (jSImplicitElementImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/react/JSXPropTypesUtil", "createImplicitReactPropsElement"));
        }
        return jSImplicitElementImpl;
    }

    private static JSImplicitElementImpl.Builder createSimpleImplicitElement(@NotNull JSProperty property, @NotNull JSQualifiedNameImpl prop) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/lang/javascript/frameworks/react/JSXPropTypesUtil", "createSimpleImplicitElement"));
        }
        if (prop == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prop", "com/intellij/lang/javascript/frameworks/react/JSXPropTypesUtil", "createSimpleImplicitElement"));
        }
        return new JSImplicitElementImpl.Builder(prop, (PsiElement)property).setContext(JSContext.INSTANCE).setType(JSImplicitElement.Type.Property).setNamespaceExplicitlyDeclared(true);
    }

    private static boolean isRequired(@Nullable JSExpression value) {
        return value instanceof JSReferenceExpression && PROPS_IS_REQUIRED_NAME.equals(((JSReferenceExpression)value).getReferenceName());
    }

    @Nullable
    private static String computeType(@Nullable JSExpression value) {
        if (value instanceof JSReferenceExpression) {
            String name = ((JSReferenceExpression)value).getReferenceName();
            String resultType = JSXPropTypesUtil.parseType(name);
            if (resultType != null) {
                return resultType;
            }
            if (PROPS_IS_REQUIRED_NAME.equals(name)) {
                return JSXPropTypesUtil.computeType(((JSReferenceExpression)value).getQualifier());
            }
        }
        return null;
    }

    @Nullable
    public static String parseType(@Nullable String name) {
        if ("string".equals(name) || "object".equals(name) || "number".equals(name)) {
            return StringUtil.capitalize((String)name);
        }
        if ("bool".equals(name)) {
            return "Boolean";
        }
        if ("fn".equals(name) || "fun".equals(name)) {
            return "Function";
        }
        return null;
    }
}

