/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.react;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.LegacyCompletionContributor;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.XmlTagInsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.ecmascript6.psi.impl.ES6CreateImportUtil;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.frameworks.react.ReactXmlExtension;
import com.intellij.lang.javascript.frameworks.react.tsx.TypeScriptReactComponentUtil;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.stubs.JSExportedMembersIndex;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.typescript.completion.ES6ImportCompletionUtil;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.xml.TagNameReference;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import icons.JavaScriptLanguageIcons;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReactComponentCompletionContributor
extends CompletionContributor {
    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        boolean needComponents;
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/lang/javascript/frameworks/react/ReactComponentCompletionContributor", "fillCompletionVariants"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/javascript/frameworks/react/ReactComponentCompletionContributor", "fillCompletionVariants"));
        }
        String prefix = result.getPrefixMatcher().getPrefix();
        boolean bl = needComponents = StringUtil.isEmpty((String)prefix) || ReactXmlExtension.isComponentName(prefix);
        if (!needComponents) {
            return;
        }
        LegacyCompletionContributor.processReferences((CompletionParameters)parameters, (CompletionResultSet)result, (reference, set) -> {
            if (result == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/javascript/frameworks/react/ReactComponentCompletionContributor", "lambda$fillCompletionVariants$0"));
            }
            if (!(reference instanceof TagNameReference)) {
                return;
            }
            TagNameReference tagNameReference = (TagNameReference)reference;
            PsiElement element = tagNameReference.getElement();
            if (element instanceof XmlTag && tagNameReference.isStartTagFlag() && !ReactXmlExtension.nonJsxTag((XmlTag)element)) {
                HashSet<String> collectedNames = new HashSet<String>();
                XmlTag tag = (XmlTag)element;
                boolean isTypeScript = DialectDetector.isTypeScript(element);
                ReactComponentCompletionContributor.addLocalVariants(result, tag, collectedNames, isTypeScript);
                ReactComponentCompletionContributor.addExportedComponents(result, tag, collectedNames, isTypeScript);
            }
        });
    }

    private static void addExportedComponents(@NotNull CompletionResultSet result, @NotNull XmlTag tag, @NotNull Set<String> names, boolean isTypeScript) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/javascript/frameworks/react/ReactComponentCompletionContributor", "addExportedComponents"));
        }
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/lang/javascript/frameworks/react/ReactComponentCompletionContributor", "addExportedComponents"));
        }
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/intellij/lang/javascript/frameworks/react/ReactComponentCompletionContributor", "addExportedComponents"));
        }
        Project project = tag.getProject();
        GlobalSearchScope scope = ReactComponentCompletionContributor.createScope((PsiElement)tag, project);
        HashSet classesToHierarchyCheck = ContainerUtil.newHashSet();
        PrefixMatcher prefixMatcher = result.getPrefixMatcher();
        Processor processor = element -> {
            if (names == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/intellij/lang/javascript/frameworks/react/ReactComponentCompletionContributor", "lambda$addExportedComponents$1"));
            }
            if (result == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/javascript/frameworks/react/ReactComponentCompletionContributor", "lambda$addExportedComponents$1"));
            }
            if (tag == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/lang/javascript/frameworks/react/ReactComponentCompletionContributor", "lambda$addExportedComponents$1"));
            }
            String name = ES6ImportPsiUtil.getExportedElementName(element);
            if (!ReactXmlExtension.isComponentName(name) || !prefixMatcher.prefixMatches(name) || names.contains(name)) {
                return true;
            }
            if (element instanceof JSClass) {
                JSClass jsClass = (JSClass)element;
                ThreeState state = ReactXmlExtension.isAcceptableClassComponent(jsClass);
                switch (state) {
                    case YES: {
                        ReactComponentCompletionContributor.addComponentWithImportInsertHandler(result, tag, isTypeScript, (PsiElement)jsClass);
                        return true;
                    }
                    case NO: {
                        return true;
                    }
                }
                classesToHierarchyCheck.add(jsClass);
                return true;
            }
            if (!DialectDetector.isJSX((PsiElement)element)) {
                return true;
            }
            if (element instanceof JSVariable) {
                JSFunctionExpression expression = ((JSVariable)element).tryGetFunctionExpressionInitializer();
                if (expression != null && ReactXmlExtension.isAcceptableFunctionComponent((JSFunction)expression)) {
                    ReactComponentCompletionContributor.addComponentWithImportInsertHandler(result, tag, isTypeScript, (PsiElement)element);
                }
                return true;
            }
            if (element instanceof JSFunction) {
                if (ReactXmlExtension.isAcceptableFunctionComponent((JSFunction)element)) {
                    ReactComponentCompletionContributor.addComponentWithImportInsertHandler(result, tag, isTypeScript, (PsiElement)element);
                }
                return true;
            }
            return true;
        };
        ReactComponentCompletionContributor.processExportedElementsForKey(project, "exp", scope, (Processor<JSElement>)processor);
        ReactComponentCompletionContributor.processExportedElementsForKey(project, "def", scope, (Processor<JSElement>)processor);
        ReactComponentCompletionContributor.addClassesWithCheckHierarchy(result, tag, classesToHierarchyCheck, isTypeScript);
    }

    private static void addClassesWithCheckHierarchy(@NotNull CompletionResultSet result, @NotNull XmlTag tag, Collection<JSClass> classesToHierarchyCheck, boolean isTypeScript) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/javascript/frameworks/react/ReactComponentCompletionContributor", "addClassesWithCheckHierarchy"));
        }
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/lang/javascript/frameworks/react/ReactComponentCompletionContributor", "addClassesWithCheckHierarchy"));
        }
        if (classesToHierarchyCheck.isEmpty()) {
            return;
        }
        JSClass reactComponentClass = isTypeScript ? TypeScriptReactComponentUtil.findReactClass((PsiElement)tag) : null;
        for (JSClass jsClass : classesToHierarchyCheck) {
            TypeScriptUtil.JSClassHierarchyProcessor processor = (aClass, typeSubstitutor, fromImplements) -> {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/javascript/frameworks/react/ReactComponentCompletionContributor", "lambda$addClassesWithCheckHierarchy$2"));
                }
                if (tag == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/lang/javascript/frameworks/react/ReactComponentCompletionContributor", "lambda$addClassesWithCheckHierarchy$2"));
                }
                if (aClass == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/lang/javascript/frameworks/react/ReactComponentCompletionContributor", "lambda$addClassesWithCheckHierarchy$2"));
                }
                if (typeSubstitutor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeSubstitutor", "com/intellij/lang/javascript/frameworks/react/ReactComponentCompletionContributor", "lambda$addClassesWithCheckHierarchy$2"));
                }
                String name = aClass.getName();
                if ("Component".equals(name) && (reactComponentClass == null || reactComponentClass.isEquivalentTo((PsiElement)aClass))) {
                    ReactComponentCompletionContributor.addComponentWithImportInsertHandler(result, tag, isTypeScript, (PsiElement)jsClass);
                    return false;
                }
                return true;
            };
            JSClassUtils.processClassesInHierarchy(jsClass, false, processor);
        }
    }

    @NotNull
    public static GlobalSearchScope createScope(@NotNull PsiElement element, final Project project) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/frameworks/react/ReactComponentCompletionContributor", "createScope"));
        }
        DelegatingGlobalSearchScope delegatingGlobalSearchScope = new DelegatingGlobalSearchScope(ES6CreateImportUtil.createSymbolToImportSearchScope(project, (PsiElement)element.getContainingFile())){

            public boolean contains(@NotNull VirtualFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/frameworks/react/ReactComponentCompletionContributor$1", "contains"));
                }
                if (!super.contains(file)) {
                    return false;
                }
                JSLanguageDialect dialect = DialectDetector.getLanguageDialect(file, project);
                if (dialect == null) {
                    return false;
                }
                DialectOptionHolder holder = dialect.getOptionHolder();
                if (holder.isJSX) {
                    return true;
                }
                return holder.isTypeScript && TypeScriptUtil.isDefinitionFile(file);
            }
        };
        if (delegatingGlobalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/react/ReactComponentCompletionContributor", "createScope"));
        }
        return delegatingGlobalSearchScope;
    }

    private static void processExportedElementsForKey(Project project, String key, GlobalSearchScope scope, Processor<JSElement> processor) {
        StubIndex.getInstance().processElements(JSExportedMembersIndex.KEY, (Object)key, project, scope, JSElement.class, processor);
    }

    private static void addLocalVariants(final @NotNull CompletionResultSet result, @NotNull XmlTag tag, final Set<String> collectedNames, final boolean isStrict) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/javascript/frameworks/react/ReactComponentCompletionContributor", "addLocalVariants"));
        }
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/lang/javascript/frameworks/react/ReactComponentCompletionContributor", "addLocalVariants"));
        }
        JSReferenceExpressionImpl.doProcessLocalDeclarations((PsiElement)tag, null, new ResolveProcessor(null, (PsiElement)tag){

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/frameworks/react/ReactComponentCompletionContributor$2", "execute"));
                }
                if (state == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/frameworks/react/ReactComponentCompletionContributor$2", "execute"));
                }
                Collection<PsiElement> elementsByImport = ReactXmlExtension.getElementsByImport(element);
                for (PsiElement candidate : elementsByImport) {
                    boolean isComponent;
                    String name = ReactXmlExtension.getEffectiveName(element, candidate);
                    if (name == null || !ReactXmlExtension.isComponentName(name) || collectedNames.contains(name)) continue;
                    if (isStrict) {
                        isComponent = ReactXmlExtension.isReactComponent(candidate);
                        if (!isComponent && ReactXmlExtension.isPossibleReactComponent(candidate)) {
                            collectedNames.add(name);
                        }
                    } else {
                        isComponent = ReactXmlExtension.isPossibleReactComponent(candidate);
                    }
                    if (!isComponent) continue;
                    ReactComponentCompletionContributor.addLookupElement(candidate, name, result);
                    collectedNames.add(name);
                    break;
                }
                return true;
            }
        }, false, true, null);
    }

    private static void addLookupElement(PsiElement candidate, String name, CompletionResultSet result) {
        LookupElementBuilder lookup = ReactComponentCompletionContributor.createLookup(name, candidate);
        result.addElement((LookupElement)lookup);
    }

    private static void addComponentWithImportInsertHandler(@NotNull CompletionResultSet result, @NotNull XmlTag tag, boolean isTypeScript, @NotNull PsiElement el) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/javascript/frameworks/react/ReactComponentCompletionContributor", "addComponentWithImportInsertHandler"));
        }
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/lang/javascript/frameworks/react/ReactComponentCompletionContributor", "addComponentWithImportInsertHandler"));
        }
        if (el == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "el", "com/intellij/lang/javascript/frameworks/react/ReactComponentCompletionContributor", "addComponentWithImportInsertHandler"));
        }
        boolean isCandidateTypeScript = DialectDetector.isTypeScript(el);
        if (isTypeScript && !isCandidateTypeScript) {
            return;
        }
        JSQualifiedNamedElement element = (JSQualifiedNamedElement)el;
        String qualifiedName = element.getQualifiedName();
        if (qualifiedName == null) {
            return;
        }
        String name = element.getName();
        ReactComponentCompletionContributor.addLookupItemWithImportInsertHandler(result, (PsiElement)element, name, tag);
    }

    private static void addLookupItemWithImportInsertHandler(@NotNull CompletionResultSet result, @NotNull PsiElement candidate, String name, XmlTag tag) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/javascript/frameworks/react/ReactComponentCompletionContributor", "addLookupItemWithImportInsertHandler"));
        }
        if (candidate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "com/intellij/lang/javascript/frameworks/react/ReactComponentCompletionContributor", "addLookupItemWithImportInsertHandler"));
        }
        if (!ES6CreateImportUtil.isAvailableForImport(candidate, (PsiElement)tag)) {
            return;
        }
        LookupElementBuilder lookup = ReactComponentCompletionContributor.createLookup(name, null);
        lookup = lookup.withInsertHandler((InsertHandler)new InsertHandler<LookupElement>(){

            public void handleInsert(InsertionContext context, LookupElement item) {
                PsiFile originalFile = context.getFile();
                PsiElement originalElement = originalFile.findElementAt(context.getStartOffset());
                if (originalElement != null) {
                    ES6ImportCompletionUtil.insertLookupItem(context, item, (Consumer<JSElement>)((Consumer)el -> {
                        if (el != null) {
                            PsiDocumentManager.getInstance((Project)context.getProject()).commitDocument(context.getDocument());
                            PsiDocumentManager.getInstance((Project)context.getProject()).doPostponedOperationsAndUnblockDocument(context.getDocument());
                            XmlTagInsertHandler.INSTANCE.handleInsert(context, item);
                        }
                    }));
                }
            }
        });
        result.addElement((LookupElement)lookup);
    }

    private static LookupElementBuilder createLookup(@NotNull String name, @Nullable PsiElement candidate) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/frameworks/react/ReactComponentCompletionContributor", "createLookup"));
        }
        ItemPresentation presentation = candidate instanceof JSNamedElement ? ((JSNamedElement)candidate).getPresentation() : null;
        LookupElementBuilder lookup = (candidate == null ? LookupElementBuilder.create((String)name) : LookupElementBuilder.create((Object)candidate, (String)name)).withTypeText(presentation != null ? presentation.getLocationString() : null, true).withIcon(JavaScriptLanguageIcons.Logos.Jsx_16);
        lookup = lookup.withInsertHandler((InsertHandler)XmlTagInsertHandler.INSTANCE);
        return lookup;
    }
}

