/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.react;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.frameworks.react.JSXPropTypesUtil;
import com.intellij.lang.javascript.frameworks.react.ReactAttributeDescriptor;
import com.intellij.lang.javascript.frameworks.react.ReactXmlElementNSDescriptor;
import com.intellij.lang.javascript.frameworks.react.ReactXmlExtension;
import com.intellij.lang.javascript.frameworks.react.tsx.TypeScriptReactComponentUtil;
import com.intellij.lang.javascript.frameworks.react.tsx.TypeScriptReactTagUtil;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlElementsGroup;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.impl.schema.AnyXmlAttributeDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReactXmlElementDescriptor
implements XmlElementDescriptor {
    private static final Collection<String> IGNORED_ATTRIBUTES = ContainerUtil.immutableSet((Object[])new String[]{"class", "for"});
    @NotNull
    private final String myName;
    @NotNull
    private final PsiElement myContext;
    private final boolean myStrict;
    @Nullable
    private final ReactXmlElementNSDescriptor myDescriptor;
    @Nullable
    private final XmlNSDescriptor myParentNSDescriptor;

    public ReactXmlElementDescriptor(@NotNull String name, @NotNull PsiElement context, @Nullable XmlNSDescriptor parentNSDescriptor, boolean isStrict) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/frameworks/react/ReactXmlElementDescriptor", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/frameworks/react/ReactXmlElementDescriptor", "<init>"));
        }
        this.myName = name;
        this.myContext = context;
        this.myParentNSDescriptor = parentNSDescriptor;
        this.myStrict = isStrict;
        this.myDescriptor = new ReactXmlElementNSDescriptor(parentNSDescriptor, this.myContext, isStrict);
    }

    public String getQualifiedName() {
        return this.myName;
    }

    public String getDefaultName() {
        return this.myName;
    }

    public XmlElementDescriptor[] getElementsDescriptors(XmlTag context) {
        XmlNSDescriptor descriptor2 = this.getNSDescriptor();
        if (descriptor2 == null) {
            return XmlElementDescriptor.EMPTY_ARRAY;
        }
        return descriptor2.getRootElementsDescriptors(null);
    }

    public XmlElementDescriptor getElementDescriptor(XmlTag childTag, XmlTag contextTag) {
        XmlNSDescriptor descriptor2 = this.getNSDescriptor();
        return descriptor2 == null ? null : descriptor2.getElementDescriptor(childTag);
    }

    public XmlAttributeDescriptor[] getAttributesDescriptors(@Nullable XmlTag context) {
        if (context == null) {
            return XmlAttributeDescriptor.EMPTY;
        }
        if (ReactXmlExtension.isComponentName(context.getName())) {
            return ReactXmlElementDescriptor.getComponentProps(context);
        }
        return this.resolveTagAttributes(context);
    }

    @Nullable
    public XmlAttributeDescriptor getAttributeDescriptor(@NonNls String attributeName, @Nullable XmlTag context) {
        if (context == null) {
            return new AnyXmlAttributeDescriptor(attributeName);
        }
        if (ReactXmlExtension.isComponentName(context.getName())) {
            return ReactXmlElementDescriptor.findComponentProp(attributeName, context);
        }
        return this.resolveTagAttribute(context, attributeName);
    }

    @Nullable
    private static XmlAttributeDescriptor findComponentProp(@NonNls String attributeName, @NotNull XmlTag context) {
        XmlAttributeDescriptor descriptor2;
        XmlAttributeDescriptor descriptor3;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/frameworks/react/ReactXmlElementDescriptor", "findComponentProp"));
        }
        if (DialectDetector.isTypeScript((PsiElement)context) && (descriptor3 = TypeScriptReactTagUtil.getXmlAttributeDescriptor(attributeName, TypeScriptReactComponentUtil.getGenericPropType(context))) != null) {
            return descriptor3;
        }
        Ref declaration = Ref.create();
        NamespaceInfo namespaceInfo = ReactXmlElementDescriptor.getPropsNamespace(context);
        JSType type = namespaceInfo.myType;
        if (type != null && (descriptor2 = TypeScriptReactTagUtil.getXmlAttributeDescriptor(attributeName, type)) != null) {
            return descriptor2;
        }
        boolean useRestrictedByFileScope = ReactXmlElementDescriptor.useRestrictedByFilePropsNamespaceScope(namespaceInfo);
        GlobalSearchScope scope = useRestrictedByFileScope ? ReactXmlElementDescriptor.getRestrictedByFilePropsNamespaceScope(context, namespaceInfo) : JSResolveUtil.getResolveScope((PsiElement)context);
        Processor processor = base -> {
            if (attributeName.equals(base.getName())) {
                declaration.set(base);
            }
            return declaration.isNull();
        };
        String namespace = namespaceInfo.myNamespace;
        JSClassResolver.getInstance().processNamespaceMembers(namespace, scope, (Processor<JSPsiElementBase>)processor);
        if (declaration.isNull() && useRestrictedByFileScope) {
            JSClassResolver.getInstance().processNamespaceMembers(namespace, JSResolveUtil.getResolveScope((PsiElement)context), (Processor<JSPsiElementBase>)processor);
        }
        if (!declaration.isNull()) {
            return ReactAttributeDescriptor.create(attributeName, (PsiElement)declaration.get(), namespaceInfo.myIsWeakResolve);
        }
        Optional<JSPsiElementBase> resolvedElementFromNamespace = JSXPropTypesUtil.resolveNamespacePropTypes(namespaceInfo, scope).filter(el -> attributeName.equals(el.getName())).findAny();
        return resolvedElementFromNamespace.map(base -> ReactAttributeDescriptor.create(attributeName, (PsiElement)base, namespaceInfo.myIsWeakResolve)).orElseGet(() -> new AnyXmlAttributeDescriptor(attributeName));
    }

    private static XmlAttributeDescriptor[] getComponentProps(@NotNull XmlTag context) {
        XmlAttributeDescriptor[] descriptors;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/frameworks/react/ReactXmlElementDescriptor", "getComponentProps"));
        }
        if (DialectDetector.isTypeScript((PsiElement)context)) {
            JSType type = TypeScriptReactComponentUtil.getGenericPropType(context);
            return TypeScriptReactTagUtil.getXmlAttributeDescriptors(type);
        }
        NamespaceInfo namespaceInfo = ReactXmlElementDescriptor.getPropsNamespace(context);
        JSType flowType = namespaceInfo.myType;
        if (flowType != null && (descriptors = TypeScriptReactTagUtil.getXmlAttributeDescriptors(flowType)).length > 0) {
            return descriptors;
        }
        GlobalSearchScope scope = ReactXmlElementDescriptor.getPropsNamespaceScope(context, namespaceInfo);
        Collection<JSPsiElementBase> members = JSClassResolver.getInstance().findNamespaceMembers(namespaceInfo.myNamespace, scope);
        List result = ContainerUtil.newSmartList();
        HashSet added = ContainerUtil.newHashSet();
        Stream<JSPsiElementBase> membersStream = Stream.concat(members.stream(), JSXPropTypesUtil.resolveNamespacePropTypes(namespaceInfo, scope));
        result.addAll(membersStream.filter(el -> added.add(el.getName())).map(el -> ReactAttributeDescriptor.create(el.getName(), (PsiElement)el, namespaceInfo.myIsWeakResolve)).collect(Collectors.toList()));
        return result.isEmpty() ? XmlAttributeDescriptor.EMPTY : result.toArray(XmlAttributeDescriptor.EMPTY);
    }

    private static GlobalSearchScope getPropsNamespaceScope(@NotNull XmlTag context, @NotNull NamespaceInfo namespace) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/frameworks/react/ReactXmlElementDescriptor", "getPropsNamespaceScope"));
        }
        if (namespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/lang/javascript/frameworks/react/ReactXmlElementDescriptor", "getPropsNamespaceScope"));
        }
        if (namespace.myIsResolvedComponent && ReactXmlElementDescriptor.useRestrictedByFilePropsNamespaceScope(namespace)) {
            return ReactXmlElementDescriptor.getRestrictedByFilePropsNamespaceScope(context, namespace);
        }
        return JSResolveUtil.getResolveScope((PsiElement)context);
    }

    @NotNull
    private static GlobalSearchScope getRestrictedByFilePropsNamespaceScope(final @NotNull XmlTag context, @NotNull NamespaceInfo info) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/frameworks/react/ReactXmlElementDescriptor", "getRestrictedByFilePropsNamespaceScope"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/lang/javascript/frameworks/react/ReactXmlElementDescriptor", "getRestrictedByFilePropsNamespaceScope"));
        }
        GlobalSearchScope defaultScope = JSResolveUtil.getResolveScope((PsiElement)context);
        final VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)info.myComponent);
        if (file == null) {
            GlobalSearchScope globalSearchScope = defaultScope;
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/react/ReactXmlElementDescriptor", "getRestrictedByFilePropsNamespaceScope"));
            }
            return globalSearchScope;
        }
        DelegatingGlobalSearchScope delegatingGlobalSearchScope = new DelegatingGlobalSearchScope(defaultScope){

            public boolean contains(@NotNull VirtualFile candidate) {
                if (candidate == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "com/intellij/lang/javascript/frameworks/react/ReactXmlElementDescriptor$1", "contains"));
                }
                if (!super.contains(candidate)) {
                    return false;
                }
                PsiFile psiFile = context.getManager().findFile(candidate);
                if (!(psiFile instanceof JSFile)) {
                    return false;
                }
                JSFile jsCandidateFile = (JSFile)psiFile;
                return !jsCandidateFile.isCommonJSModule() || candidate.equals(file);
            }
        };
        if (delegatingGlobalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/react/ReactXmlElementDescriptor", "getRestrictedByFilePropsNamespaceScope"));
        }
        return delegatingGlobalSearchScope;
    }

    private static boolean useRestrictedByFilePropsNamespaceScope(@NotNull NamespaceInfo namespace) {
        if (namespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/lang/javascript/frameworks/react/ReactXmlElementDescriptor", "useRestrictedByFilePropsNamespaceScope"));
        }
        PsiElement resolvedElement = namespace.myComponent;
        if (resolvedElement == null) {
            return false;
        }
        PsiFile psiFile = resolvedElement.getContainingFile();
        if (!(psiFile instanceof JSFile)) {
            return false;
        }
        JSFile jsFile = (JSFile)psiFile;
        return jsFile.isCommonJSModule();
    }

    @NotNull
    private static NamespaceInfo getPropsNamespace(@NotNull XmlTag context) {
        String name;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/frameworks/react/ReactXmlElementDescriptor", "getPropsNamespace"));
        }
        PsiReference reference = context.getReference();
        PsiNamedElement component = null;
        boolean isWeakResolve = false;
        boolean isResolvedComponent = true;
        if (reference != null) {
            PsiElement resolve = reference.resolve();
            Collection<PsiElement> elements = ReactXmlExtension.getElementsByImport(resolve, false);
            PsiElement item = (PsiElement)ContainerUtil.getFirstItem(elements);
            if (item instanceof JSCallExpression) {
                isWeakResolve = true;
                item = (PsiElement)ContainerUtil.getFirstItem(ReactXmlExtension.resolveCallExpression((JSCallExpression)item));
            }
            if (ReactXmlElementDescriptor.isRequireCall(item)) {
                isResolvedComponent = false;
                isWeakResolve = true;
            }
            component = (PsiNamedElement)ObjectUtils.tryCast((Object)item, JSQualifiedNamedElement.class);
        }
        if (component != null && component.getName() != null) {
            name = component.getName();
        } else {
            name = context.getName();
            isResolvedComponent = false;
            isWeakResolve = true;
        }
        String namespace = name + ".props";
        JSType type = null;
        if (component instanceof JSClass) {
            JSField props;
            JSClass jsClass = (JSClass)component;
            JSField propsTypes = jsClass.findFieldByName("propTypes");
            JSField jSField = props = propsTypes != null ? propsTypes : jsClass.findFieldByName("props");
            if (props != null && (type = props.getType()) instanceof JSNamedType) {
                namespace = type.getTypeText();
            }
        }
        NamespaceInfo namespaceInfo = new NamespaceInfo((PsiElement)component, type, namespace, isWeakResolve, isResolvedComponent);
        if (namespaceInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/react/ReactXmlElementDescriptor", "getPropsNamespace"));
        }
        return namespaceInfo;
    }

    private static boolean isRequireCall(@Nullable PsiElement item) {
        if (!(item instanceof JSVariable)) {
            return false;
        }
        JSExpression initializer = ((JSVariable)item).getInitializerOrStub();
        return initializer instanceof JSCallExpression && ((JSCallExpression)initializer).isRequireCall();
    }

    @NotNull
    private XmlAttributeDescriptor[] resolveTagAttributes(XmlTag context) {
        XmlAttributeDescriptor[] typeScriptProperties = ReactXmlElementDescriptor.getPropertyAttributes(context);
        XmlElementDescriptor elementDescriptor = this.getXmlElementDescriptorFormParent(context);
        if (elementDescriptor != null && !(elementDescriptor instanceof ReactXmlElementDescriptor)) {
            XmlAttributeDescriptor[] xmlAttributeDescriptorArray = this.mergeAttributes(typeScriptProperties, elementDescriptor.getAttributesDescriptors(context));
            if (xmlAttributeDescriptorArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/react/ReactXmlElementDescriptor", "resolveTagAttributes"));
            }
            return xmlAttributeDescriptorArray;
        }
        if (typeScriptProperties == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/react/ReactXmlElementDescriptor", "resolveTagAttributes"));
        }
        return typeScriptProperties;
    }

    private static XmlAttributeDescriptor[] getPropertyAttributes(XmlTag context) {
        TypeScriptPropertySignature property = TypeScriptReactTagUtil.resolveTag(context);
        XmlAttributeDescriptor[] typeScriptProperties = XmlAttributeDescriptor.EMPTY;
        if (property != null) {
            typeScriptProperties = TypeScriptReactTagUtil.getXmlAttributeDescriptors(property);
        }
        return typeScriptProperties;
    }

    protected XmlAttributeDescriptor[] mergeAttributes(@NotNull XmlAttributeDescriptor[] typeScriptProperties, @NotNull XmlAttributeDescriptor[] parentDescriptors) {
        if (typeScriptProperties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeScriptProperties", "com/intellij/lang/javascript/frameworks/react/ReactXmlElementDescriptor", "mergeAttributes"));
        }
        if (parentDescriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDescriptors", "com/intellij/lang/javascript/frameworks/react/ReactXmlElementDescriptor", "mergeAttributes"));
        }
        if (parentDescriptors.length == 0) {
            return typeScriptProperties;
        }
        if (typeScriptProperties.length == 0) {
            return parentDescriptors;
        }
        ArrayList result = ContainerUtil.newArrayList((Object[])typeScriptProperties);
        Set names = Arrays.stream(typeScriptProperties).map(el -> StringUtil.toLowerCase((String)el.getName())).collect(Collectors.toSet());
        for (XmlAttributeDescriptor descriptor2 : parentDescriptors) {
            String name = descriptor2.getName();
            if (IGNORED_ATTRIBUTES.contains(name) || names.contains(ReactXmlElementDescriptor.normalizeAttributeName(name))) continue;
            result.add(descriptor2);
        }
        return result.toArray(XmlAttributeDescriptor.EMPTY);
    }

    private XmlAttributeDescriptor resolveTagAttribute(XmlTag context, @NonNls String attributeName) {
        XmlElementDescriptor elementDescriptor;
        boolean hasTypeScriptDeclarations;
        TypeScriptPropertySignature property = TypeScriptReactTagUtil.resolveTag(context);
        boolean bl = hasTypeScriptDeclarations = property != null;
        if (hasTypeScriptDeclarations) {
            Ref resultRef = Ref.create();
            HashSet lowCaseNames = ContainerUtil.newHashSet();
            TypeScriptReactTagUtil.processAttributes(property, (Processor<JSRecordType.PropertySignature>)((Processor)el -> {
                String name = el.getMemberName();
                if (name.equals(attributeName)) {
                    resultRef.set((Object)TypeScriptReactTagUtil.createAttributeDescriptor(el, false));
                    return false;
                }
                lowCaseNames.add(StringUtil.toLowerCase((String)name));
                return true;
            }));
            if (!resultRef.isNull() || lowCaseNames.contains(ReactXmlElementDescriptor.normalizeAttributeName(StringUtil.toLowerCase((String)attributeName))) || IGNORED_ATTRIBUTES.contains(attributeName)) {
                return resultRef.isNull() ? null : (XmlAttributeDescriptor)resultRef.get();
            }
        }
        if ((elementDescriptor = this.getXmlElementDescriptorFormParent(context)) != null) {
            if (!(elementDescriptor instanceof ReactXmlElementDescriptor)) {
                XmlAttributeDescriptor attributeDescriptor = elementDescriptor.getAttributeDescriptor(attributeName, context);
                return attributeDescriptor != null ? attributeDescriptor : ReactXmlElementDescriptor.getEmptyAttributeValue(attributeName, hasTypeScriptDeclarations);
            }
            return ReactXmlElementDescriptor.getEmptyAttributeValue(attributeName, hasTypeScriptDeclarations);
        }
        return ReactXmlElementDescriptor.getEmptyAttributeValue(attributeName, hasTypeScriptDeclarations);
    }

    private static String normalizeAttributeName(@NotNull String attributeName) {
        if (attributeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributeName", "com/intellij/lang/javascript/frameworks/react/ReactXmlElementDescriptor", "normalizeAttributeName"));
        }
        return attributeName.replace("-", "");
    }

    @Nullable
    private static XmlAttributeDescriptor getEmptyAttributeValue(@NotNull String attributeName, boolean strict) {
        if (attributeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributeName", "com/intellij/lang/javascript/frameworks/react/ReactXmlElementDescriptor", "getEmptyAttributeValue"));
        }
        return strict ? null : new AnyXmlAttributeDescriptor(attributeName);
    }

    @Nullable
    public XmlAttributeDescriptor getAttributeDescriptor(XmlAttribute attribute) {
        return this.getAttributeDescriptor(attribute.getName(), attribute.getParent());
    }

    public XmlNSDescriptor getNSDescriptor() {
        return this.myDescriptor;
    }

    @Nullable
    public XmlElementsGroup getTopGroup() {
        return null;
    }

    public int getContentType() {
        return ReactXmlExtension.isComponentName(this.myName) ? 0 : 1;
    }

    @Nullable
    public String getDefaultValue() {
        return null;
    }

    @Nullable
    public PsiElement getDeclaration() {
        PsiElement declaration;
        XmlElementDescriptor descriptor2;
        if (!this.myStrict && this.myContext instanceof XmlTag && !ReactXmlExtension.isComponentName(this.myName) && (descriptor2 = this.getXmlElementDescriptorFormParent((XmlTag)this.myContext)) != null && !(descriptor2 instanceof ReactXmlElementDescriptor) && (declaration = descriptor2.getDeclaration()) != null) {
            return declaration;
        }
        return this.myContext;
    }

    public String getName(PsiElement context) {
        return this.getName();
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/react/ReactXmlElementDescriptor", "getName"));
        }
        return string;
    }

    public void init(PsiElement element) {
    }

    private XmlElementDescriptor getXmlElementDescriptorFormParent(@Nullable XmlTag context) {
        if (context == null || this.myParentNSDescriptor == null) {
            return null;
        }
        return this.myParentNSDescriptor.getElementDescriptor(context);
    }

    @NotNull
    public Object[] getDependences() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/react/ReactXmlElementDescriptor", "getDependences"));
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public static class NamespaceInfo {
        @Nullable
        private JSType myType;
        @NotNull
        private final String myNamespace;
        @Nullable
        private final PsiElement myComponent;
        private final boolean myIsWeakResolve;
        private final boolean myIsResolvedComponent;

        @NotNull
        public String getNamespace() {
            String string = this.myNamespace;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/react/ReactXmlElementDescriptor$NamespaceInfo", "getNamespace"));
            }
            return string;
        }

        public NamespaceInfo(@Nullable PsiElement component, @Nullable JSType type, @NotNull String namespace, boolean isWeakResolve, boolean isResolvedComponent) {
            if (namespace == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/lang/javascript/frameworks/react/ReactXmlElementDescriptor$NamespaceInfo", "<init>"));
            }
            this.myComponent = component;
            this.myType = type;
            this.myNamespace = namespace;
            this.myIsWeakResolve = isWeakResolve;
            this.myIsResolvedComponent = isResolvedComponent;
        }
    }
}

