/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.react;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclarationPart;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.dialects.JSLanguageLevel;
import com.intellij.lang.javascript.dialects.JSXHarmonyLanguageDialect;
import com.intellij.lang.javascript.frameworks.react.ReactXmlElementDescriptor;
import com.intellij.lang.javascript.frameworks.react.tsx.TypeScriptReactComponentUtil;
import com.intellij.lang.javascript.frameworks.react.tsx.TypeScriptReactTagUtil;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSPsiNamedElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.e4x.impl.JSXmlLiteralExpressionImpl;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptField;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.stubs.JSClassIndex;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveType;
import com.intellij.lang.javascript.psi.types.primitives.JSStringType;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.settings.JSRootConfiguration;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.html.HtmlFileImpl;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.impl.source.xml.TagNameReference;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.HtmlXmlExtension;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlExtension;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.XmlTagNameProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReactXmlExtension
extends HtmlXmlExtension
implements XmlTagNameProvider {
    private static final ResolveCache.AbstractResolver<ReactTagNameReference, PsiElement> RESOLVER = new ResolveCache.AbstractResolver<ReactTagNameReference, PsiElement>(){

        public PsiElement resolve(@NotNull ReactTagNameReference reference, boolean incompleteCode) {
            if (reference == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/lang/javascript/frameworks/react/ReactXmlExtension$1", "resolve"));
            }
            XmlTag tag = reference.getTagElement();
            assert (tag != null);
            PsiElement var = ReactXmlExtension.resolveTagOrComponent(tag);
            if (var != null) {
                return var;
            }
            return null;
        }
    };
    private static final String PROPERTY_RENDER = "render";
    private static final String PROPERTY_PROPS = "propTypes";
    public static final String GET_DEFAULT_PROPS = "getDefaultProps";
    public static final String DEFAULT_PROPS = "defaultProps";
    public static final String CHILDREN = "children";

    @Nullable
    private static PsiElement resolveTagOrComponent(XmlTag tag) {
        final String tagName = tag.getName();
        boolean isTypeScript = DialectDetector.isTypeScript((PsiElement)tag);
        if (isTypeScript && !ReactXmlExtension.isComponentName(tagName)) {
            return TypeScriptReactTagUtil.resolveTag(tag);
        }
        final Ref var = Ref.create();
        JSReferenceExpressionImpl.doProcessLocalDeclarations((PsiElement)tag, null, new ResolveProcessor(tagName, (PsiElement)tag){

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/frameworks/react/ReactXmlExtension$2", "execute"));
                }
                if (state == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/frameworks/react/ReactXmlExtension$2", "execute"));
                }
                Collection<PsiElement> elements = ReactXmlExtension.getElementsByImport(element);
                for (PsiElement candidate : elements) {
                    String name = ReactXmlExtension.getEffectiveName(element, candidate);
                    if (!StringUtil.equals((CharSequence)tagName, (CharSequence)name) || !ReactXmlExtension.isPossibleReactComponent(candidate)) continue;
                    var.setIfNull((Object)ReactXmlExtension.getElementForResolve(element, candidate));
                }
                return var.isNull();
            }
        }, false, false, null);
        if (!var.isNull()) {
            return (PsiElement)var.get();
        }
        if (isTypeScript) {
            for (JSClass jsClass : TypeScriptReactComponentUtil.resolveComponent(tag)) {
                JSElement container = ES6PsiUtil.getExportScope((PsiElement)jsClass);
                if (TypeScriptPsiUtil.isModule((PsiElement)container, false)) continue;
                return jsClass;
            }
        } else {
            PsiFile file = tag.getContainingFile();
            if (file instanceof JSFile && ((JSFile)file).isCommonJSModule()) {
                return null;
            }
            PsiElement clazz = ReactXmlExtension.resolveClassComponent(tag, tagName);
            if (clazz != null) {
                return clazz;
            }
        }
        return null;
    }

    private static PsiElement getElementForResolve(PsiElement element, PsiElement candidate) {
        if (element instanceof ES6ImportedBinding || element instanceof ES6ImportSpecifierAlias || element instanceof TypeScriptImportStatement || element instanceof JSVariable) {
            return element;
        }
        if (element instanceof ES6ImportSpecifier) {
            Object[] results = ((ES6ImportSpecifier)element).multiResolve(false);
            ResolveResult resolveResult = (ResolveResult)ArrayUtil.getFirstElement((Object[])results);
            return resolveResult == null ? candidate : resolveResult.getElement();
        }
        return candidate;
    }

    @Nullable
    private static PsiElement resolveClassComponent(XmlTag tag, String tagName) {
        JSQualifiedNameImpl fqn = JSQualifiedNameImpl.fromQualifiedName(tagName);
        Ref result = Ref.create();
        if (ReactXmlExtension.isComponentName(tagName)) {
            JSClassIndex.processElements(fqn.getName(), tag.getProject(), JSResolveUtil.getResolveScope((PsiElement)tag), (Processor<JSPsiElementBase>)((Processor)clazz -> {
                JSImplicitElement implicit;
                if (clazz instanceof JSImplicitElement && "ReactCompositeComponent".equals((implicit = (JSImplicitElement)clazz).getTypeString()) && Comparing.equal((Object)fqn.getParent(), (Object)implicit.getNamespace())) {
                    result.set(clazz);
                }
                return result.isNull();
            }));
        }
        return (PsiElement)result.get();
    }

    @Contract(value="null -> false")
    public static boolean isComponentName(@Nullable String tagName) {
        return StringUtil.isCapitalized((String)tagName);
    }

    @Nullable
    protected static JSExpression getInitializer(@NotNull PsiElement clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/lang/javascript/frameworks/react/ReactXmlExtension", "getInitializer"));
        }
        if (clazz instanceof JSVariable) {
            return ((JSVariable)clazz).getInitializerOrStub();
        }
        if (clazz instanceof JSDefinitionExpression) {
            return ((JSDefinitionExpression)clazz).getInitializerOrStub();
        }
        if (clazz instanceof JSProperty) {
            JSFunction function = ((JSProperty)clazz).tryGetFunctionInitializer();
            return function instanceof JSExpression ? (JSExpression)function : null;
        }
        return null;
    }

    public boolean isAvailable(PsiFile file) {
        return file instanceof JSFile || file instanceof HtmlFileImpl && JSRootConfiguration.getInstance(file.getProject()).getLanguageLevel() == JSLanguageLevel.JSX;
    }

    @Nullable
    public TagNameReference createTagNameReference(ASTNode nameElement, boolean startTagFlag) {
        return nameElement.getTreeParent() instanceof JSXmlLiteralExpressionImpl ? new ReactTagNameReference(nameElement, startTagFlag) : super.createTagNameReference(nameElement, startTagFlag);
    }

    public static boolean isPossibleReactComponent(@NotNull PsiElement candidate) {
        if (candidate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "com/intellij/lang/javascript/frameworks/react/ReactXmlExtension", "isPossibleReactComponent"));
        }
        if (ReactXmlExtension.isReactComponent(candidate)) {
            return true;
        }
        if (candidate instanceof JSVariable || candidate instanceof JSDefinitionExpression || candidate instanceof JSProperty) {
            if (candidate instanceof JSVariable && DialectDetector.isTypeScript(candidate)) {
                return ReactXmlExtension.isCompatibleComponentType(((JSVariable)candidate).getType());
            }
            JSExpression initializer = ReactXmlExtension.getInitializer(candidate);
            JSType type = JSResolveUtil.getExpressionJSType(initializer);
            return ReactXmlExtension.isCompatibleComponentType(type);
        }
        if (candidate instanceof JSClass && !(candidate instanceof TypeScriptTypeAlias)) {
            return !((JSClass)candidate).isInterface() && ((JSClass)candidate).getExtendsList() != null;
        }
        if (candidate instanceof JSCallExpression) {
            JSType type = JSResolveUtil.getExpressionJSType((JSExpression)candidate);
            return ReactXmlExtension.isCompatibleComponentType(type);
        }
        return true;
    }

    protected static boolean isCompatibleComponentType(JSType type) {
        if (type instanceof JSPrimitiveType && !(type instanceof JSStringType)) {
            return false;
        }
        return !(type instanceof JSRecordType) || ((JSRecordType)type).hasProperty(PROPERTY_RENDER);
    }

    public static boolean isReactComponent(@Nullable PsiElement candidate) {
        if (candidate == null) {
            return false;
        }
        if (candidate instanceof JSVariable || candidate instanceof JSDefinitionExpression) {
            JSExpression initializer = ReactXmlExtension.getInitializer(candidate);
            if (initializer instanceof JSXmlLiteralExpressionImpl) {
                return true;
            }
            if (JSXHarmonyLanguageDialect.isReactComponent(initializer)) {
                return true;
            }
            if (DialectDetector.isTypeScript(candidate) && candidate instanceof JSVariable) {
                JSRecordType recordType;
                JSType type = ((JSVariable)candidate).getType();
                JSRecordType jSRecordType = recordType = type != null ? type.asRecordType() : null;
                if (recordType != null && (recordType.hasProperty(PROPERTY_RENDER) || recordType.hasProperty(PROPERTY_PROPS))) {
                    return true;
                }
                if (initializer instanceof JSFunction && ReactXmlExtension.isComponentName(((JSVariable)candidate).getName())) {
                    return ReactXmlExtension.isAcceptableFunctionComponent((JSFunction)initializer);
                }
            }
        }
        if (candidate instanceof JSCallExpression && JSXHarmonyLanguageDialect.isReactComponent((JSExpression)((JSCallExpression)candidate))) {
            return true;
        }
        if (candidate instanceof ES6ImportExportDeclarationPart || candidate instanceof TypeScriptImportStatement) {
            return true;
        }
        if (candidate instanceof JSFunction) {
            JSFunction function = (JSFunction)candidate;
            return function.getName() != null && ReactXmlExtension.isComponentName(function.getName());
        }
        if (candidate instanceof JSClass) {
            return ReactXmlExtension.isAcceptableClassComponent((JSClass)candidate) == ThreeState.YES;
        }
        return false;
    }

    public void addTagNameVariants(List<LookupElement> elements, @NotNull XmlTag tag, String prefix) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/lang/javascript/frameworks/react/ReactXmlExtension", "addTagNameVariants"));
        }
    }

    @Nullable
    static String getEffectiveName(PsiElement element, PsiElement candidate) {
        if (element instanceof ES6ImportedBinding || element instanceof ES6ImportSpecifierAlias || element instanceof TypeScriptImportStatement) {
            return ((PsiNamedElement)element).getName();
        }
        if (element instanceof ES6ImportSpecifier) {
            return ((ES6ImportSpecifier)element).getDeclaredName();
        }
        JSPsiNamedElementBase jsElement = (JSPsiNamedElementBase)ObjectUtils.tryCast((Object)candidate, JSPsiNamedElementBase.class);
        return jsElement != null ? jsElement.getName() : null;
    }

    @NotNull
    public static Collection<PsiElement> getElementsByImport(@Nullable PsiElement element) {
        Collection<PsiElement> collection = ReactXmlExtension.getElementsByImport(element, true);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/react/ReactXmlExtension", "getElementsByImport"));
        }
        return collection;
    }

    @NotNull
    public static Collection<PsiElement> getElementsByImport(@Nullable PsiElement element, boolean resolveCallExpression) {
        PsiElement result;
        if (element instanceof ES6ImportSpecifier) {
            ResolveResult[] results = ((ES6ImportSpecifier)element).resolveOverAliases();
            Collection<PsiElement> collection = JSResolveResult.toElements(results);
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/react/ReactXmlExtension", "getElementsByImport"));
            }
            return collection;
        }
        if (element instanceof ES6ImportedBinding || element instanceof ES6ImportExportSpecifierAlias) {
            PsiElement result2 = JSStubBasedPsiTreeUtil.calculateMeaningfulElement(element);
            if (resolveCallExpression && result2 instanceof JSCallExpression) {
                List elements = ReactXmlExtension.resolveCallExpression((JSCallExpression)result2);
                List list = elements.size() == 0 ? ContainerUtil.createMaybeSingletonList((Object)result2) : elements;
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/react/ReactXmlExtension", "getElementsByImport"));
                }
                return list;
            }
            List list = ContainerUtil.createMaybeSingletonList((Object)result2);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/react/ReactXmlExtension", "getElementsByImport"));
            }
            return list;
        }
        if (element instanceof TypeScriptImportStatement) {
            ArrayList arrayList = ContainerUtil.newArrayList((Iterable)((TypeScriptImportStatement)element).findReferencedElements());
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/react/ReactXmlExtension", "getElementsByImport"));
            }
            return arrayList;
        }
        if (element instanceof JSVariable && (result = JSStubBasedPsiTreeUtil.calculateMeaningfulElement(element)) != element && result instanceof JSQualifiedNamedElement && ((JSQualifiedNamedElement)result).getName() != null) {
            List list = ContainerUtil.createMaybeSingletonList((Object)result);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/react/ReactXmlExtension", "getElementsByImport"));
            }
            return list;
        }
        List list = ContainerUtil.createMaybeSingletonList((Object)element);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/react/ReactXmlExtension", "getElementsByImport"));
        }
        return list;
    }

    @NotNull
    public static Collection<PsiElement> resolveCallExpression(@NotNull JSCallExpression result) {
        PsiElement componentCandidate;
        PsiElement module;
        String componentName;
        Map strings;
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/javascript/frameworks/react/ReactXmlExtension", "resolveCallExpression"));
        }
        JSElementIndexingData data = result.getIndexingData();
        if (data != null && (strings = data.getUserStrings()) != null && !StringUtil.isEmpty((String)(componentName = (String)strings.get("wrapped.component.name"))) && (module = ES6PsiUtil.findExternalModule((PsiElement)result)) != null && (componentCandidate = JSStubBasedPsiTreeUtil.resolveLocally(componentName, module)) != null && ReactXmlExtension.isPossibleReactComponent(componentCandidate)) {
            List list = ContainerUtil.createMaybeSingletonList((Object)componentCandidate);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/react/ReactXmlExtension", "resolveCallExpression"));
            }
            return list;
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/react/ReactXmlExtension", "resolveCallExpression"));
        }
        return list;
    }

    public static boolean nonJsxTag(@Nullable XmlTag tag) {
        return !(tag instanceof JSXmlLiteralExpressionImpl) || DialectDetector.dialectOfElement((PsiElement)tag) == DialectOptionHolder.ECMA_4;
    }

    public static ThreeState isAcceptableClassComponent(@NotNull JSClass jsClass) {
        String[] texts;
        if (jsClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsClass", "com/intellij/lang/javascript/frameworks/react/ReactXmlExtension", "isAcceptableClassComponent"));
        }
        if (jsClass.isInterface() || jsClass.getExtendsList() == null) {
            return ThreeState.NO;
        }
        for (String text : texts = jsClass.getExtendsList().getReferenceTexts()) {
            if (!"Component".equals(text) && !text.endsWith(".Component")) continue;
            return ThreeState.YES;
        }
        return ThreeState.NO;
    }

    @Nullable
    public XmlNSDescriptor getNSDescriptor(XmlTag element, String namespace, boolean strict) {
        XmlElementDescriptor elementDescriptor = element.getDescriptor();
        if (elementDescriptor instanceof ReactXmlElementDescriptor) {
            return elementDescriptor.getNSDescriptor();
        }
        return super.getNSDescriptor(element, namespace, strict);
    }

    public boolean isCollapsibleTag(XmlTag tag) {
        return true;
    }

    public boolean isRequiredAttributeImplicitlyPresent(XmlTag tag, String attrName) {
        String tagName = tag.getName();
        if (!ReactXmlExtension.isComponentName(tagName)) {
            return false;
        }
        boolean children = CHILDREN.equals(attrName);
        boolean passedAttributes = false;
        for (PsiElement child : tag.getChildren()) {
            if ((!children || passedAttributes) && child instanceof JSEmbeddedContent) {
                return true;
            }
            if (children && (child instanceof XmlText || child instanceof XmlTag)) {
                return true;
            }
            IElementType type = child.getNode().getElementType();
            if (!children && (type == XmlTokenType.XML_EMPTY_ELEMENT_END || type == XmlTokenType.XML_TAG_END)) break;
            passedAttributes |= type == XmlTokenType.XML_TAG_END;
        }
        Processor processor = base -> {
            if (StringUtil.equals((CharSequence)base.getQualifiedName(), (CharSequence)(tagName + "." + DEFAULT_PROPS)) || StringUtil.equals((CharSequence)base.getQualifiedName(), (CharSequence)(tagName + "." + GET_DEFAULT_PROPS))) {
                JSPsiElementBase root;
                Object object = root = base instanceof JSDefinitionExpression ? ((JSDefinitionExpression)base).getInitializerOrStub() : base;
                if (root == null) {
                    return true;
                }
                Collection<JSProperty> properties = JSStubBasedPsiTreeUtil.findDescendants((PsiElement)root, JSStubElementTypes.PROPERTY);
                for (JSProperty property : properties) {
                    if (!StringUtil.equals((CharSequence)attrName, (CharSequence)property.getName())) continue;
                    return false;
                }
            }
            return true;
        };
        return !JSClassResolver.processElementsByNameIncludingImplicit(DEFAULT_PROPS, JSResolveUtil.getResolveScope((PsiElement)tag), false, (Processor<JSPsiElementBase>)processor) || !JSClassResolver.processElementsByNameIncludingImplicit(GET_DEFAULT_PROPS, JSResolveUtil.getResolveScope((PsiElement)tag), false, (Processor<JSPsiElementBase>)processor);
    }

    public boolean shouldBeInserted(XmlAttributeDescriptor descriptor2) {
        if (CHILDREN.equals(descriptor2.getName())) {
            return false;
        }
        return super.shouldBeInserted(descriptor2);
    }

    @NotNull
    public XmlExtension.AttributeValuePresentation getAttributeValuePresentation(@Nullable XmlAttributeDescriptor descriptor2, @NotNull String defaultAttributeQuote) {
        if (defaultAttributeQuote == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultAttributeQuote", "com/intellij/lang/javascript/frameworks/react/ReactXmlExtension", "getAttributeValuePresentation"));
        }
        if (descriptor2 != null && !ReactXmlExtension.useQuotesForAttributeValue(descriptor2)) {
            XmlExtension.AttributeValuePresentation attributeValuePresentation = ReactXmlExtension.createValueWithBraces();
            if (attributeValuePresentation == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/react/ReactXmlExtension", "getAttributeValuePresentation"));
            }
            return attributeValuePresentation;
        }
        XmlExtension.AttributeValuePresentation attributeValuePresentation = super.getAttributeValuePresentation(descriptor2, defaultAttributeQuote);
        if (attributeValuePresentation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/react/ReactXmlExtension", "getAttributeValuePresentation"));
        }
        return attributeValuePresentation;
    }

    public static boolean useQuotesForAttributeValue(@NotNull XmlAttributeDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/lang/javascript/frameworks/react/ReactXmlExtension", "useQuotesForAttributeValue"));
        }
        return false;
    }

    @NotNull
    private static XmlExtension.AttributeValuePresentation createValueWithBraces() {
        XmlExtension.AttributeValuePresentation attributeValuePresentation = new XmlExtension.AttributeValuePresentation(){

            @NotNull
            public String getPrefix() {
                if ("{" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/react/ReactXmlExtension$3", "getPrefix"));
                }
                return "{";
            }

            @NotNull
            public String getPostfix() {
                if ("}" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/react/ReactXmlExtension$3", "getPostfix"));
                }
                return "}";
            }

            public boolean showAutoPopup() {
                return false;
            }
        };
        if (attributeValuePresentation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/react/ReactXmlExtension", "createValueWithBraces"));
        }
        return attributeValuePresentation;
    }

    @Nullable
    public static JSType getType(@Nullable XmlAttributeDescriptor descriptor2) {
        String typeString;
        if (descriptor2 == null) {
            return null;
        }
        PsiElement declaration = descriptor2.getDeclaration();
        if (declaration instanceof TypeScriptField) {
            TypeScriptField signature = (TypeScriptField)declaration;
            return signature.getType();
        }
        if (declaration instanceof JSImplicitElement && !StringUtil.isEmpty((String)(typeString = ((JSImplicitElement)declaration).getTypeString()))) {
            return JSNamedType.createType(typeString, JSTypeSourceFactory.createTypeSource(declaration), JSTypeContext.INSTANCE);
        }
        return null;
    }

    static boolean isAcceptableFunctionComponent(@NotNull JSFunction element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/frameworks/react/ReactXmlExtension", "isAcceptableFunctionComponent"));
        }
        JSType returnedType = element.getReturnType();
        if (returnedType instanceof JSPrimitiveType) {
            return false;
        }
        JSParameterListElement[] parameters = element.getParameters();
        return parameters.length == 1;
    }

    static class ReactTagNameReference
    extends TagNameReference {
        public ReactTagNameReference(ASTNode nameElement, boolean startTagFlag) {
            super(nameElement, startTagFlag);
        }

        public PsiElement resolve() {
            XmlTag tag = this.getTagElement();
            if (ReactXmlExtension.nonJsxTag(tag)) {
                return super.resolve();
            }
            PsiElement element = (PsiElement)ResolveCache.getInstance((Project)tag.getProject()).resolveWithCaching((PsiReference)this, RESOLVER, false, false);
            if (element instanceof ES6ImportedBinding) {
                JSElement topLevelContainer = ES6PsiUtil.getExportScope(element);
                JSElement currentContainer = ES6PsiUtil.getExportScope((PsiElement)tag);
                if (topLevelContainer != null && topLevelContainer.isEquivalentTo((PsiElement)currentContainer)) {
                    return element;
                }
            }
            return element != null ? element : super.resolve();
        }

        @Nullable
        public XmlTag getTagElement() {
            return super.getTagElement();
        }
    }
}

