/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.react.tsx;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.frameworks.react.JSXPropTypesUtil;
import com.intellij.lang.javascript.frameworks.react.ReactAttributeDescriptor;
import com.intellij.lang.javascript.frameworks.react.ReactXmlExtension;
import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProvider;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSNamespaceMembersIndex;
import com.intellij.lang.typescript.resolve.TypeScriptClassResolver;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlAttributeDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptReactTagUtil {
    private static final String TSX_TAG_NAMESPACE = "JSX.IntrinsicElements";
    public static final Key<ParameterizedCachedValue<TypeScriptPropertySignature, XmlTag>> CACHED_VALUE_KEY = Key.create((String)"tsx.resolve.tag");
    public static final ParameterizedCachedValueProvider<TypeScriptPropertySignature, XmlTag> CACHED_TAG_RESOLVE = new ParameterizedCachedValueProvider<TypeScriptPropertySignature, XmlTag>(){

        @Nullable
        public CachedValueProvider.Result<TypeScriptPropertySignature> compute(@NotNull XmlTag tag) {
            if (tag == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/lang/javascript/frameworks/react/tsx/TypeScriptReactTagUtil$1", "compute"));
            }
            Collection<JSElement> elements = TypeScriptReactTagUtil.getAllTags((PsiElement)tag);
            if (elements.isEmpty()) {
                return null;
            }
            String tagName = tag.getName();
            for (JSElement element : elements) {
                String elementName;
                if (!(element instanceof TypeScriptPropertySignature) || !tagName.equals(elementName = element.getName())) continue;
                return CachedValueProvider.Result.create((Object)((TypeScriptPropertySignature)element), (Object[])new Object[]{JSTypeUtils.getTypeInvalidationDependency()});
            }
            return CachedValueProvider.Result.create(null, (Object[])new Object[]{JSTypeUtils.getTypeInvalidationDependency()});
        }
    };

    public static boolean hasTagsNamespace(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/frameworks/react/tsx/TypeScriptReactTagUtil", "hasTagsNamespace"));
        }
        JSClass elementsClass = TypeScriptClassResolver.getInstance().findAnyClassByQName(TSX_TAG_NAMESPACE, JSResolveUtil.getResolveScope(context));
        return elementsClass != null && elementsClass.isInterface();
    }

    @Nullable
    public static XmlAttributeDescriptor getXmlAttributeDescriptor(@NotNull String attributeName, @Nullable JSType type) {
        if (attributeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributeName", "com/intellij/lang/javascript/frameworks/react/tsx/TypeScriptReactTagUtil", "getXmlAttributeDescriptor"));
        }
        Ref ref = Ref.create();
        boolean forceOptional = TypeScriptReactTagUtil.isForceOptional(type);
        TypeScriptReactTagUtil.processAttributes(type, (Processor<JSRecordType.PropertySignature>)((Processor)signature -> {
            if (attributeName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributeName", "com/intellij/lang/javascript/frameworks/react/tsx/TypeScriptReactTagUtil", "lambda$getXmlAttributeDescriptor$0"));
            }
            String name = signature.getMemberName();
            if (!attributeName.equals(name)) {
                return true;
            }
            ref.set((Object)TypeScriptReactTagUtil.createAttributeDescriptor(signature, forceOptional));
            return false;
        }));
        return (XmlAttributeDescriptor)ref.get();
    }

    private static boolean isForceOptional(@Nullable JSType type) {
        return type != null && !type.getSource().isExplicitlyDeclared();
    }

    @Nullable
    public static XmlAttributeDescriptor getXmlAttributeDescriptor(@NotNull String attributeName, @NotNull TypeScriptPropertySignature property) {
        if (attributeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributeName", "com/intellij/lang/javascript/frameworks/react/tsx/TypeScriptReactTagUtil", "getXmlAttributeDescriptor"));
        }
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/lang/javascript/frameworks/react/tsx/TypeScriptReactTagUtil", "getXmlAttributeDescriptor"));
        }
        return TypeScriptReactTagUtil.getXmlAttributeDescriptor(attributeName, property.getType());
    }

    public static XmlAttributeDescriptor[] getXmlAttributeDescriptors(@Nullable JSType type) {
        ArrayList members = ContainerUtil.newArrayList();
        boolean forceOptional = TypeScriptReactTagUtil.isForceOptional(type);
        TypeScriptReactTagUtil.processAttributes(type, (Processor<JSRecordType.PropertySignature>)((Processor)signature -> {
            members.add(TypeScriptReactTagUtil.createAttributeDescriptor(signature, forceOptional));
            return true;
        }));
        return (XmlAttributeDescriptor[])ContainerUtil.toArray((List)members, (Object[])new XmlAttributeDescriptor[members.size()]);
    }

    @NotNull
    public static XmlAttributeDescriptor[] getXmlAttributeDescriptors(@NotNull TypeScriptPropertySignature property) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/lang/javascript/frameworks/react/tsx/TypeScriptReactTagUtil", "getXmlAttributeDescriptors"));
        }
        XmlAttributeDescriptor[] xmlAttributeDescriptorArray = TypeScriptReactTagUtil.getXmlAttributeDescriptors(property.getType());
        if (xmlAttributeDescriptorArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/react/tsx/TypeScriptReactTagUtil", "getXmlAttributeDescriptors"));
        }
        return xmlAttributeDescriptorArray;
    }

    @Nullable
    public static TypeScriptPropertySignature resolveTag(@NotNull XmlTag tag) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/lang/javascript/frameworks/react/tsx/TypeScriptReactTagUtil", "resolveTag"));
        }
        if (ReactXmlExtension.isComponentName(tag.getName())) {
            return null;
        }
        return (TypeScriptPropertySignature)CachedValuesManager.getManager((Project)tag.getProject()).getParameterizedCachedValue((UserDataHolder)tag, CACHED_VALUE_KEY, CACHED_TAG_RESOLVE, false, (Object)tag);
    }

    public static Collection<JSElement> getAllTags(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/frameworks/react/tsx/TypeScriptReactTagUtil", "getAllTags"));
        }
        GlobalSearchScope scope = TypeScriptReactTagUtil.getScopeForTags(context);
        return ContainerUtil.filter((Collection)StubIndex.getElements(JSNamespaceMembersIndex.KEY, (Object)TSX_TAG_NAMESPACE, (Project)context.getProject(), (GlobalSearchScope)scope, JSElement.class), element -> element instanceof TypeScriptPropertySignature && element.getName() != null);
    }

    @NotNull
    public static GlobalSearchScope getScopeForTags(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/frameworks/react/tsx/TypeScriptReactTagUtil", "getScopeForTags"));
        }
        GlobalSearchScope result = JSResolveUtil.getResolveScope(context);
        DialectOptionHolder holder = DialectDetector.dialectOfElement(context);
        GlobalSearchScope globalSearchScope = holder != null && holder.isJSX && !holder.isTypeScript ? TypeScriptReactTagUtil.unionWithReactLibrary(context.getProject(), result) : result;
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/react/tsx/TypeScriptReactTagUtil", "getScopeForTags"));
        }
        return globalSearchScope;
    }

    @NotNull
    public static XmlAttributeDescriptor createAttributeDescriptor(@NotNull JSRecordType.PropertySignature signature, boolean forceOptional) {
        if (signature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "com/intellij/lang/javascript/frameworks/react/tsx/TypeScriptReactTagUtil", "createAttributeDescriptor"));
        }
        boolean optional = forceOptional || signature.isOptional();
        XmlAttributeDescriptor xmlAttributeDescriptor = ReactAttributeDescriptor.create(signature.getMemberName(), signature.getSource(), optional);
        if (xmlAttributeDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/react/tsx/TypeScriptReactTagUtil", "createAttributeDescriptor"));
        }
        return xmlAttributeDescriptor;
    }

    public static void processAttributes(@NotNull TypeScriptPropertySignature propertyTag, @NotNull Processor<JSRecordType.PropertySignature> processor) {
        if (propertyTag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyTag", "com/intellij/lang/javascript/frameworks/react/tsx/TypeScriptReactTagUtil", "processAttributes"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/frameworks/react/tsx/TypeScriptReactTagUtil", "processAttributes"));
        }
        TypeScriptReactTagUtil.processAttributes(propertyTag.getType(), processor);
    }

    public static void processAttributes(@Nullable JSType type, @NotNull Processor<JSRecordType.PropertySignature> processor) {
        JSRecordType.TypeMember member;
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/frameworks/react/tsx/TypeScriptReactTagUtil", "processAttributes"));
        }
        if (type == null) {
            return;
        }
        List typeMembers = JSXPropTypesUtil.convertFlowRecordType(type.asRecordType()).getTypeMembers();
        Iterator iterator = typeMembers.iterator();
        while (iterator.hasNext() && (!((member = (JSRecordType.TypeMember)iterator.next()) instanceof JSRecordType.PropertySignature) || processor.process((Object)((JSRecordType.PropertySignature)member)))) {
        }
    }

    public static GlobalSearchScope unionWithReactLibrary(Project project, @Nullable GlobalSearchScope scope) {
        if (scope == null) {
            return null;
        }
        return scope.uniteWith(TypeScriptReactTagUtil.getReactLibraryScope(project));
    }

    @NotNull
    public static GlobalSearchScope getReactLibraryScope(Project project) {
        GlobalSearchScope globalSearchScope = GlobalSearchScope.filesScope((Project)project, JSCorePredefinedLibrariesProvider.getJSXPredefinedLibraryFiles());
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/react/tsx/TypeScriptReactTagUtil", "getReactLibraryScope"));
        }
        return globalSearchScope;
    }
}

