/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.webpack;

import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.css.CssSupportLoader;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.psi.css.resolve.StylesheetFileReference;
import com.intellij.psi.impl.SyntheticFileSystemItem;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceHelper;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceResolver;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebpackFileReferenceHelper
extends FileReferenceHelper {
    @NotNull
    public Collection<PsiFileSystemItem> getContexts(Project project, @NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/frameworks/webpack/WebpackFileReferenceHelper", "getContexts"));
        }
        List<WebpackFileReferenceResolver> list = Collections.singletonList(new WebpackFileReferenceResolver(project, file));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/webpack/WebpackFileReferenceHelper", "getContexts"));
        }
        return list;
    }

    public boolean isMine(Project project, @NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/frameworks/webpack/WebpackFileReferenceHelper", "isMine"));
        }
        PsiFileSystemItem psiFile = this.getPsiFileSystemItem(project, file);
        return psiFile instanceof StylesheetFile || CssSupportLoader.isInFileThatSupportsEmbeddedCss((PsiElement)psiFile);
    }

    private static Collection<VirtualFile> findModulesDirectories(@NotNull VirtualFile context, @NotNull Project project) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/frameworks/webpack/WebpackFileReferenceHelper", "findModulesDirectories"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/frameworks/webpack/WebpackFileReferenceHelper", "findModulesDirectories"));
        }
        SmartList result = new SmartList();
        VirtualFile dir = context;
        if (!dir.isDirectory()) {
            dir = context.getParent();
        }
        ProjectFileIndex index = ProjectFileIndex.SERVICE.getInstance((Project)project);
        while (dir != null && index.getContentRootForFile(dir, false) != null) {
            VirtualFile modulesDir = dir.findChild("node_modules");
            if (modulesDir != null && modulesDir.isDirectory() && modulesDir.isValid()) {
                result.add(modulesDir);
            }
            dir = dir.getParent();
        }
        return result;
    }

    private static class WebpackFileReferenceResolver
    extends SyntheticFileSystemItem
    implements FileReferenceResolver {
        private final VirtualFile myContextFile;

        public WebpackFileReferenceResolver(Project project, VirtualFile contextFile) {
            super(project);
            this.myContextFile = contextFile;
        }

        @NotNull
        public String getName() {
            if ("<WebPack root>" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/webpack/WebpackFileReferenceHelper$WebpackFileReferenceResolver", "getName"));
            }
            return "<WebPack root>";
        }

        @Nullable
        public PsiFileSystemItem getParent() {
            return null;
        }

        public VirtualFile getVirtualFile() {
            return this.myContextFile;
        }

        public boolean processChildren(PsiElementProcessor<PsiFileSystemItem> processor) {
            return false;
        }

        @Nullable
        public PsiFileSystemItem resolveFileReference(@NotNull FileReference reference, @NotNull String name) {
            PsiElement element;
            VirtualFile context;
            if (reference == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/lang/javascript/frameworks/webpack/WebpackFileReferenceHelper$WebpackFileReferenceResolver", "resolveFileReference"));
            }
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/frameworks/webpack/WebpackFileReferenceHelper$WebpackFileReferenceResolver", "resolveFileReference"));
            }
            if (reference instanceof StylesheetFileReference && reference.getIndex() == 0 && (context = (element = reference.getElement()).getContainingFile().getVirtualFile()) != null) {
                Project project = element.getProject();
                String referenceText = reference.getText();
                if (referenceText.length() > 1 && StringUtil.startsWithChar((CharSequence)referenceText, (char)'~')) {
                    for (VirtualFile modulesDir : WebpackFileReferenceHelper.findModulesDirectories(context, project)) {
                        VirtualFile virtualFile = modulesDir.findChild(referenceText.substring(1));
                        if (virtualFile == null) continue;
                        return FileReferenceHelper.getPsiFileSystemItem((PsiManager)element.getManager(), (VirtualFile)virtualFile);
                    }
                }
            }
            return null;
        }

        public Collection<Object> getVariants(@NotNull FileReference reference) {
            PsiElement element;
            VirtualFile context;
            if (reference == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/lang/javascript/frameworks/webpack/WebpackFileReferenceHelper$WebpackFileReferenceResolver", "getVariants"));
            }
            if (reference instanceof StylesheetFileReference && reference.getIndex() == 0 && (context = (element = reference.getElement()).getContainingFile().getOriginalFile().getVirtualFile()) != null) {
                Project project = element.getProject();
                HashSet result = ContainerUtil.newHashSet();
                for (VirtualFile modulesDir : WebpackFileReferenceHelper.findModulesDirectories(context, project)) {
                    PsiManager psiManager = element.getManager();
                    for (VirtualFile file : modulesDir.getChildren()) {
                        PsiDirectory directory = psiManager.findDirectory(file);
                        if (directory == null || StringUtil.startsWithChar((CharSequence)directory.getName(), (char)'.')) continue;
                        LookupElementBuilder item = LookupElementBuilder.create((Object)directory, (String)("~" + directory.getName())).withIcon(directory.getIcon(0));
                        result.add(PrioritizedLookupElement.withPriority((LookupElement)item, (double)-1.0));
                    }
                }
                return result;
            }
            return Collections.emptyList();
        }
    }
}

