/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.webpack;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.frameworks.webpack.WebpackConfigHighlightingInspection;
import com.intellij.lang.javascript.frameworks.webpack.WebpackUtil;
import com.intellij.lang.javascript.json.JSJsonLikePsiWalker;
import com.intellij.lang.javascript.json.JsonSchemaInJavaScriptProvider;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCommaExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.extension.JsonSchemaProviderFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebpackInJavaScriptJsonSchemaProvider
implements JsonSchemaInJavaScriptProvider {
    public static VirtualFile getWebpackSchemaFile() {
        return JsonSchemaProviderFactory.getResourceFile(WebpackInJavaScriptJsonSchemaProvider.class, (String)"/jsonSchemas/webpack-schema.json");
    }

    @Override
    public VirtualFile getSchemaFile() {
        return WebpackInJavaScriptJsonSchemaProvider.getWebpackSchemaFile();
    }

    @Override
    public boolean isAvailable(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/frameworks/webpack/WebpackInJavaScriptJsonSchemaProvider", "isAvailable"));
        }
        return WebpackInJavaScriptJsonSchemaProvider.isWebpackInspectionAllowed(element) && WebpackInJavaScriptJsonSchemaProvider.isApplicable(element);
    }

    static boolean isAvailableForFile(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/frameworks/webpack/WebpackInJavaScriptJsonSchemaProvider", "isAvailableForFile"));
        }
        return Registry.is((String)"JavaScript.WebPack.With.JsonSchema", (boolean)true) && StringUtil.containsIgnoreCase((String)file.getName(), (String)"webpack") && DialectDetector.JAVASCRIPT_FILE_TYPES.contains(file.getFileType());
    }

    public static boolean isApplicable(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/frameworks/webpack/WebpackInJavaScriptJsonSchemaProvider", "isApplicable"));
        }
        return element.getContainingFile() != null && WebpackInJavaScriptJsonSchemaProvider.isAvailableForFile(element.getContainingFile()) && WebpackUtil.isWebpack2(element.getProject()) && WebpackInJavaScriptJsonSchemaProvider.isInSupportedArea(element) && WebpackInJavaScriptJsonSchemaProvider.isInTopLevelObject(element);
    }

    private static boolean isInTopLevelObject(@NotNull PsiElement element) {
        PsiElement current;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/frameworks/webpack/WebpackInJavaScriptJsonSchemaProvider", "isInTopLevelObject"));
        }
        for (current = element; !(current == null || JSJsonLikePsiWalker.isTerminalInStatement(current) || current instanceof PsiFile || current instanceof JSEmbeddedContent); current = current.getParent()) {
            if (current instanceof JSProperty || current instanceof JSLiteralExpression || current instanceof JSObjectLiteralExpression || current instanceof JSArrayLiteralExpression || current instanceof JSReferenceExpression || current instanceof LeafPsiElement) {
                continue;
            }
            return false;
        }
        return PsiTreeUtil.getParentOfType((PsiElement)current, JSObjectLiteralExpression.class) == null;
    }

    private static boolean isWebpackInspectionAllowed(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/frameworks/webpack/WebpackInJavaScriptJsonSchemaProvider", "isWebpackInspectionAllowed"));
        }
        if (element.getContainingFile() == null) {
            return false;
        }
        InspectionProfileImpl profile = InspectionProfileManager.getInstance((Project)element.getProject()).getCurrentProfile();
        String name = InspectionProfileEntry.getShortName((String)WebpackConfigHighlightingInspection.class.getSimpleName());
        InspectionToolWrapper tool = profile.getInspectionTool(name, element.getProject());
        return profile.isToolEnabled(HighlightDisplayKey.find((String)name), element) && tool != null && !tool.getTool().isSuppressedFor(element);
    }

    private static boolean isInSupportedArea(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/frameworks/webpack/WebpackInJavaScriptJsonSchemaProvider", "isInSupportedArea"));
        }
        PsiFile file = (PsiFile)ReadAction.compute(() -> {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/frameworks/webpack/WebpackInJavaScriptJsonSchemaProvider", "lambda$isInSupportedArea$0"));
            }
            if (element.getContainingFile() == null || !element.isValid() || !element.getContainingFile().isValid()) {
                return null;
            }
            if (JSTokenTypes.STRING_LITERAL.equals(element.getNode().getElementType())) {
                return null;
            }
            return element.getContainingFile();
        });
        if (file == null) {
            return false;
        }
        List ranges = (List)CachedValuesManager.getCachedValue((PsiElement)file, () -> CachedValueProvider.Result.create(WebpackInJavaScriptJsonSchemaProvider.getModuleExportsParts(file), (Object[])new Object[]{file}));
        return ContainerUtil.or((Iterable)ranges, range -> {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/frameworks/webpack/WebpackInJavaScriptJsonSchemaProvider", "lambda$isInSupportedArea$2"));
            }
            return range.contains(element.getTextRange());
        });
    }

    private static List<TextRange> getModuleExportsParts(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/frameworks/webpack/WebpackInJavaScriptJsonSchemaProvider", "getModuleExportsParts"));
        }
        List<JSAssignmentExpression> assignmentCandidates = PsiTreeUtil.findChildrenOfType((PsiElement)file, JSAssignmentExpression.class).stream().filter(assignment -> (assignment.getParent() instanceof JSStatement || assignment.getParent() instanceof JSCommaExpression) && assignment.getDefinitionExpression() != null && JSRefactoringUtil.isModuleExportsOrExports(assignment.getDefinitionExpression().getExpression())).collect(Collectors.toList());
        SmartList directParts = new SmartList();
        directParts.addAll(WebpackInJavaScriptJsonSchemaProvider.getObjectLiteralsAssignments(assignmentCandidates));
        directParts.addAll(WebpackInJavaScriptJsonSchemaProvider.getReferencesAssignments(assignmentCandidates));
        directParts.addAll(WebpackInJavaScriptJsonSchemaProvider.getReturnFromFunctionModuleExports(assignmentCandidates));
        directParts.addAll(WebpackInJavaScriptJsonSchemaProvider.getWebpackConfigVariables(file));
        return directParts.stream().sorted(Comparator.comparingInt(TextRange::getStartOffset)).collect(Collectors.toList());
    }

    @NotNull
    private static List<TextRange> getReturnFromFunctionModuleExports(@NotNull List<JSAssignmentExpression> candidates) {
        if (candidates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidates", "com/intellij/lang/javascript/frameworks/webpack/WebpackInJavaScriptJsonSchemaProvider", "getReturnFromFunctionModuleExports"));
        }
        List<TextRange> list = candidates.stream().filter(a -> a.getDefinitionExpression() != null && a.getDefinitionExpression().getInitializer() instanceof JSFunction).map(a -> {
            JSFunction function = (JSFunction)a.getDefinitionExpression().getInitializer();
            assert (function != null);
            JSElement body = JSChangeUtil.getFunctionBody(function);
            if (body instanceof JSStatement) {
                JSReturnStatement[] returns = (JSReturnStatement[])PsiTreeUtil.getChildrenOfType((PsiElement)body, JSReturnStatement.class);
                if (returns != null) {
                    return Arrays.stream(returns).map(r -> r.getExpression()).filter(e -> e instanceof JSObjectLiteralExpression).collect(Collectors.toList());
                }
            } else if (body instanceof JSObjectLiteralExpression) {
                return Collections.singletonList(body);
            }
            return Collections.emptyList();
        }).flatMap(Collection::stream).map(PsiElement::getTextRange).collect(Collectors.toList());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/webpack/WebpackInJavaScriptJsonSchemaProvider", "getReturnFromFunctionModuleExports"));
        }
        return list;
    }

    @NotNull
    private static List<TextRange> getWebpackConfigVariables(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/frameworks/webpack/WebpackInJavaScriptJsonSchemaProvider", "getWebpackConfigVariables"));
        }
        List lists = PsiTreeUtil.findChildrenOfType((PsiElement)file, JSVariable.class).stream().filter(variable -> "webpackConfig".equalsIgnoreCase(variable.getName())).map(variable -> PsiTreeUtil.findChildrenOfAnyType((PsiElement)variable, (Class[])new Class[]{JSObjectLiteralExpression.class, JSArrayLiteralExpression.class})).filter(e -> e != null).collect(Collectors.toList());
        List<TextRange> list = ContainerUtil.concat(lists).stream().filter(Objects::nonNull).map(PsiElement::getTextRange).sorted(Comparator.comparingInt(TextRange::getStartOffset)).collect(Collectors.toList());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/webpack/WebpackInJavaScriptJsonSchemaProvider", "getWebpackConfigVariables"));
        }
        return list;
    }

    @NotNull
    private static List<TextRange> getReferencesAssignments(List<JSAssignmentExpression> assignmentCandidates) {
        List<TextRange> list = assignmentCandidates.stream().filter(a -> a.getDefinitionExpression() != null).map(a -> WebpackInJavaScriptJsonSchemaProvider.getObjectLiteralFromReference(a.getDefinitionExpression().getInitializer())).filter(Objects::nonNull).map(PsiElement::getTextRange).collect(Collectors.toList());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/webpack/WebpackInJavaScriptJsonSchemaProvider", "getReferencesAssignments"));
        }
        return list;
    }

    @NotNull
    private static List<TextRange> getObjectLiteralsAssignments(List<JSAssignmentExpression> assignmentCandidates) {
        List<TextRange> list = assignmentCandidates.stream().filter(assignment -> {
            JSDefinitionExpression definition = assignment.getDefinitionExpression();
            return definition != null && (definition.getInitializer() instanceof JSObjectLiteralExpression || definition.getInitializer() instanceof JSArrayLiteralExpression);
        }).map(PsiElement::getTextRange).collect(Collectors.toList());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/webpack/WebpackInJavaScriptJsonSchemaProvider", "getObjectLiteralsAssignments"));
        }
        return list;
    }

    private static JSExpression getObjectLiteralFromReference(@Nullable JSExpression initializer) {
        JSExpression varInitializer;
        PsiElement resolve;
        if (initializer instanceof JSReferenceExpression && (resolve = ((JSReferenceExpression)initializer).resolve()) != null && resolve.isValid() && resolve instanceof JSVariable && (varInitializer = ((JSVariable)resolve).getInitializer()) instanceof JSObjectLiteralExpression) {
            return varInitializer;
        }
        return null;
    }
}

