/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.hierarchy.call;

import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.HierarchyTreeStructure;
import com.intellij.lang.javascript.hierarchy.JSHierarchyUtils;
import com.intellij.lang.javascript.hierarchy.call.JSCallHierarchyNodeDescriptor;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.search.JSFunctionsSearch;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.HashMap;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public final class JSCalleeMethodsTreeStructure
extends HierarchyTreeStructure {
    private final String myScopeType;

    public JSCalleeMethodsTreeStructure(Project project, JSFunction method, String scopeType) {
        super(project, (HierarchyNodeDescriptor)new JSCallHierarchyNodeDescriptor(project, null, (PsiElement)method, true, false));
        this.myScopeType = scopeType;
    }

    @NotNull
    protected final Object[] buildChildren(@NotNull HierarchyNodeDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/lang/javascript/hierarchy/call/JSCalleeMethodsTreeStructure", "buildChildren"));
        }
        PsiElement enclosingElement = ((JSCallHierarchyNodeDescriptor)descriptor2).getEnclosingElement();
        if (!(enclosingElement instanceof JSFunction)) {
            if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/hierarchy/call/JSCalleeMethodsTreeStructure", "buildChildren"));
            }
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        JSFunction method = (JSFunction)enclosingElement;
        ArrayList<JSSourceElement> jsSourceElements = new ArrayList<JSSourceElement>();
        JSSourceElement[] body = method.getBody();
        if (body != null) {
            JSCalleeMethodsTreeStructure.visitor(body, jsSourceElements);
        }
        JSFunction baseMethod = (JSFunction)((JSCallHierarchyNodeDescriptor)this.getBaseDescriptor()).getTargetElement();
        JSClass baseClass = JSResolveUtil.getClassOfContext((PsiElement)baseMethod);
        HashMap methodToDescriptorMap = new HashMap();
        ArrayList<JSCallHierarchyNodeDescriptor> result = new ArrayList<JSCallHierarchyNodeDescriptor>();
        for (JSSourceElement element : jsSourceElements) {
            if (!this.isInScope((PsiElement)baseClass, (PsiElement)element, this.myScopeType)) continue;
            JSCallHierarchyNodeDescriptor d = (JSCallHierarchyNodeDescriptor)((Object)methodToDescriptorMap.get((Object)element));
            if (d == null) {
                d = new JSCallHierarchyNodeDescriptor(this.myProject, descriptor2, (PsiElement)element, false, false);
                methodToDescriptorMap.put((Object)element, (Object)d);
                result.add(d);
                continue;
            }
            d.incrementUsageCount();
        }
        JSClass jsClass = JSResolveUtil.getClassOfContext((PsiElement)method);
        if (jsClass != null) {
            JSFunction[] overridingOrImplementingMethods;
            for (JSFunction jsFunction : overridingOrImplementingMethods = jsClass.isInterface() ? (JSFunction[])JSFunctionsSearch.searchImplementingFunctions(method, true).toArray((Object[])JSFunction.EMPTY_ARRAY) : (JSFunction[])JSFunctionsSearch.searchOverridingFunctions(method, true).toArray((Object[])JSFunction.EMPTY_ARRAY)) {
                JSCallHierarchyNodeDescriptor node;
                if (!this.isInScope((PsiElement)baseClass, (PsiElement)jsFunction, this.myScopeType) || result.contains((Object)(node = new JSCallHierarchyNodeDescriptor(this.myProject, descriptor2, (PsiElement)jsFunction, false, false)))) continue;
                result.add(node);
            }
        }
        Object[] objectArray = ArrayUtil.toObjectArray(result);
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/hierarchy/call/JSCalleeMethodsTreeStructure", "buildChildren"));
        }
        return objectArray;
    }

    private static void visitor(JSSourceElement[] elements, ArrayList<JSSourceElement> methods) {
        for (JSSourceElement element : elements) {
            JSCalleeMethodsTreeStructure.visitor((PsiElement)element, methods);
        }
    }

    private static void visitor(PsiElement psiElement, ArrayList<JSSourceElement> methods) {
        PsiElement[] children;
        for (PsiElement child : children = psiElement.getChildren()) {
            JSSourceElement element;
            JSCalleeMethodsTreeStructure.visitor(child, methods);
            if (!(child instanceof JSCallExpression) || (element = JSHierarchyUtils.getJSFunctionOrClass((JSCallExpression)child)) == null) continue;
            methods.add(element);
        }
    }
}

